/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.sitemap.web.context;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.json.JsonParser;
import org.springframework.boot.json.JsonParserFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;
import org.springframework.web.context.support.StandardServletEnvironment;

public class VcapPropertyLoaderListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent>,
Ordered {
    private static final String REDISHOST = "vcap.services.redis2.credentials.host";
    private static final String REDISPORT = "vcap.services.redis2.credentials.port";
    private static final String REDISPASSWORD = "vcap.services.redis2.credentials.password";
    private static final String SWIFT_AUTHENTICATION_URL = "vcap.services.swift-sitemap.credentials.authentication_uri";
    private static final String SWIFT_AUTHENTICATION_AV_ZONE = "vcap.services.swift-sitemap.credentials.availability_zone";
    private static final String SWIFT_AUTHENTICATION_TENANT_NAME = "vcap.services.swift-sitemap.credentials.tenant_name";
    private static final String SWIFT_AUTHENTICATION_USER_NAME = "vcap.services.swift-sitemap.credentials.user_name";
    private static final String SWIFT_AUTHENTICATION_PASSWORD = "vcap.services.swift-sitemap.credentials.password";
    private static final String VCAP_APPLICATION = "VCAP_APPLICATION";
    private static final String VCAP_SERVICES = "VCAP_SERVICES";
    private int order = -2147483639;
    private final JsonParser parser = JsonParserFactory.getJsonParser();
    private static StandardServletEnvironment env = new StandardServletEnvironment();

    public VcapPropertyLoaderListener() {
        this.onApplicationEvent(new ApplicationEnvironmentPreparedEvent(new SpringApplication(new Object[0]), new String[0], (ConfigurableEnvironment)env));
        ClassLoader c = this.getClass().getClassLoader();
        URLClassLoader urlC = (URLClassLoader)c;
        URL[] urls = urlC.getURLs();
        String path = urls[0].getPath();
        Properties props = new Properties();
        File europeanaProperties = new File(path + "/sitemap.properties");
        try {
            props.load(new FileInputStream(europeanaProperties));
            if (env.getProperty(SWIFT_AUTHENTICATION_URL) != null) {
                props.setProperty("swift.authUrl", env.getProperty(SWIFT_AUTHENTICATION_URL));
                props.setProperty("swift.password", env.getProperty(SWIFT_AUTHENTICATION_PASSWORD));
                props.setProperty("swift.username", env.getProperty(SWIFT_AUTHENTICATION_USER_NAME));
                props.setProperty("swift.regionName", env.getProperty(SWIFT_AUTHENTICATION_AV_ZONE));
                props.setProperty("swift.tenantName", env.getProperty(SWIFT_AUTHENTICATION_TENANT_NAME));
                props.setProperty("swift.containerName", env.getProperty("sitemap"));
            }
            ArrayList<String> sortedKeys = new ArrayList<String>();
            for (Object key : props.keySet()) {
                sortedKeys.add(key.toString());
            }
            Collections.sort(sortedKeys);
            StringBuilder sb = new StringBuilder();
            sb.append("#Generated by the VCAPPropertyLoaderListener\n");
            sb.append("#" + new Date().toString() + "\n");
            for (String key : sortedKeys) {
                sb.append(key + "=" + props.getProperty(key).toString() + "\n");
            }
            FileUtils.writeStringToFile((File)europeanaProperties, (String)(sb + "\n"), (boolean)false);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        ConfigurableEnvironment environment = event.getEnvironment();
        if (!environment.containsProperty(VCAP_APPLICATION) && !environment.containsProperty(VCAP_SERVICES)) {
            return;
        }
        Properties properties = new Properties();
        this.addWithPrefix(properties, this.getPropertiesFromApplication((Environment)environment), "vcap.application.");
        this.addWithPrefix(properties, this.getPropertiesFromServices((Environment)environment), "vcap.services.");
        MutablePropertySources propertySources = environment.getPropertySources();
        if (propertySources.contains("commandLineArgs")) {
            propertySources.addAfter("commandLineArgs", (PropertySource)new PropertiesPropertySource("vcap", properties));
        } else {
            propertySources.addFirst((PropertySource)new PropertiesPropertySource("vcap", properties));
        }
    }

    private void addWithPrefix(Properties properties, Properties other, String prefix) {
        Enumeration<?> propertynames = other.propertyNames();
        while (propertynames.hasMoreElements()) {
            String key = propertynames.nextElement().toString();
            String prefixed = prefix + key;
            if (other.getProperty(key) != null) {
                properties.setProperty(prefixed, other.getProperty(key));
                continue;
            }
            System.out.println(key);
        }
    }

    private Properties getPropertiesFromApplication(Environment environment) {
        Properties properties = new Properties();
        try {
            Map map = this.parser.parseMap(environment.getProperty(VCAP_APPLICATION, "{}"));
            this.extractPropertiesFromApplication(properties, map);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return properties;
    }

    private Properties getPropertiesFromServices(Environment environment) {
        Properties properties = new Properties();
        try {
            Map map = this.parser.parseMap(environment.getProperty(VCAP_SERVICES, "{}"));
            this.extractPropertiesFromServices(properties, map);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return properties;
    }

    private void extractPropertiesFromApplication(Properties properties, Map<String, Object> map) {
        if (map != null) {
            this.flatten(properties, map, "");
        }
    }

    private void extractPropertiesFromServices(Properties properties, Map<String, Object> map) {
        if (map != null) {
            for (Object services : map.values()) {
                List list = (List)services;
                for (Object object : list) {
                    Map service = (Map)object;
                    String key = (String)service.get("name");
                    if (key == null) {
                        key = (String)service.get("label");
                    }
                    this.flatten(properties, service, key);
                }
            }
        }
    }

    private void flatten(Properties properties, Map<String, Object> input, String path) {
        for (Map.Entry<String, Object> entry : input.entrySet()) {
            Object value;
            String key = entry.getKey();
            if (StringUtils.hasText((String)path)) {
                key = key.startsWith("[") ? path + key : path + "." + key;
            }
            if ((value = entry.getValue()) instanceof String) {
                properties.put(key, value);
                continue;
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                this.flatten(properties, map, key);
                continue;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                properties.put(key, StringUtils.collectionToCommaDelimitedString((Collection)collection));
                int count = 0;
                for (Object object : collection) {
                    this.flatten(properties, Collections.singletonMap("[" + count++ + "]", object), key);
                }
                continue;
            }
            System.out.println("is else " + key + ":" + value);
            properties.put(key, value == null ? "" : "" + value);
        }
    }
}

