/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.sitemap.service;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import eu.europeana.domain.StorageObject;
import eu.europeana.features.ObjectStorageClient;
import eu.europeana.sitemap.exceptions.SitemapNotReadyException;
import eu.europeana.sitemap.mongo.MongoProvider;
import eu.europeana.sitemap.service.ActiveSiteMapService;
import eu.europeana.sitemap.service.SitemapService;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Resource;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.jclouds.io.Payload;
import org.jclouds.io.payloads.ByteArrayPayload;
import org.springframework.util.StringUtils;

public class MongoSitemapService
implements SitemapService {
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String SITEMAP_HEADER = "<sitemapindex xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">";
    private static final String URLSET_HEADER = "<urlset xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\" xmlns:image=\"http://www.google.com/schemas/sitemap-image/1.1\" xmlns:geo=\"http://www.google.com/geo/schemas/sitemap/1.0\">";
    private static final String URL_OPENING = "<url>";
    private static final String URL_CLOSING = "</url>";
    private static final String LOC_OPENING = "<loc>";
    private static final String LOC_CLOSING = "</loc>";
    private static final String LN = "\n";
    private static final String PORTAL_URL = "http://www.europeana.eu/portal/record";
    private static final String HTML = ".html";
    private static final String FROM = "?from=";
    private static final String TO = "&to=";
    private static final String SITEMAP_OPENING = "<sitemap>";
    private static final String SITEMAP_CLOSING = "</sitemap>";
    private static final String SITEMAP_HEADER_CLOSING = "</sitemapindex>";
    private static final String URLSET_HEADER_CLOSING = "</urlset>";
    private static final String PRIORITY_OPENING = "<priority>";
    private static final String PRIORITY_CLOSING = "</priority>";
    private static final String LASTMOD_OPENING = "<lastmod>";
    private static final String LASTMOD_CLOSING = "</lastmod>";
    private static final String MASTER_KEY = "europeana-sitemap-index-hashed.xml";
    private static final String SLAVE_KEY = "europeana-sitemap-hashed.xml";
    private static final Logger log = Logger.getLogger(MongoSitemapService.class.getName());
    private static String status = "initial";
    public static final int NUMBER_OF_ELEMENTS = 45000;
    @Resource
    private MongoProvider mongoProvider;
    @Resource
    private ObjectStorageClient objectStorageProvider;
    @Resource
    private ActiveSiteMapService activeSiteMapService;

    public void generate() throws SitemapNotReadyException {
        DBCollection col = this.mongoProvider.getCollection();
        BasicDBObject query = new BasicDBObject();
        BasicDBObject fields = new BasicDBObject();
        fields.put("about", (Object)1);
        fields.put("europeanaCompleteness", (Object)1);
        fields.put("timestampUpdated", (Object)1);
        DBCursor cur = col.find((DBObject)query, (DBObject)fields).batchSize(45000);
        log.info("Got cursor");
        log.info("Cursor hasNext:" + cur.hasNext());
        int i = 0;
        StringBuilder master = new StringBuilder();
        master.append(XML_HEADER).append(LN);
        master.append(SITEMAP_HEADER).append(LN);
        StringBuilder slave = this.initializeSlaveGeneration();
        long startDate = new Date().getTime();
        while (cur.hasNext()) {
            DBObject obj = cur.next();
            String about = obj.get("about").toString();
            Date date = obj.get("timestampUpdated") != null ? (Date)obj.get("timestampUpdated") : new Date(0L);
            String update = DateFormatUtils.format((Date)date, (String)DateFormatUtils.ISO_DATE_FORMAT.getPattern());
            int completeness = Integer.parseInt(obj.get("europeanaCompleteness").toString());
            String lastMod = "";
            if (date.getTime() > 0L) {
                lastMod = LASTMOD_OPENING + update + LASTMOD_CLOSING + LN;
            }
            slave.append(URL_OPENING).append(LN).append(LOC_OPENING).append(LN).append(PORTAL_URL).append(about).append(HTML).append(LN).append(LOC_CLOSING).append(PRIORITY_OPENING).append(completeness > 9 ? "1.0" : "0." + completeness).append(PRIORITY_CLOSING).append(lastMod).append(LN).append(URL_CLOSING).append(LN);
            if (!(i <= 0 || i % 45000 != 0 && cur.hasNext())) {
                String indexEntry = "europeana-sitemap-hashed.xml?from=" + (i - 45000) + TO + i;
                master.append(SITEMAP_OPENING).append(LN).append(LOC_OPENING).append(StringEscapeUtils.escapeXml((String)("http://www.europeana.eu/portal/" + indexEntry))).append(LN).append(LOC_CLOSING).append(LN).append(SITEMAP_CLOSING).append(LN);
                slave.append(URLSET_HEADER_CLOSING);
                String fileName = this.activeSiteMapService.getInactiveFile() + FROM + (i - 45000) + TO + i;
                this.saveToSwift(fileName, slave.toString());
                slave = this.initializeSlaveGeneration();
                long now = new Date().getTime();
                log.info("Added " + i + " sitemap entries in " + (now - startDate) + " ms(" + fileName + ")");
                startDate = now;
            }
            ++i;
        }
        master.append(SITEMAP_HEADER_CLOSING);
        this.saveToSwift(MASTER_KEY, master.toString());
        log.info("Generation complete");
    }

    private StringBuilder initializeSlaveGeneration() {
        return new StringBuilder().append(XML_HEADER).append(LN).append(URLSET_HEADER).append(LN);
    }

    private void saveToSwift(String key, String value) {
        ByteArrayPayload payload = new ByteArrayPayload(value.getBytes());
        String ETag = this.objectStorageProvider.put(key, (Payload)payload);
        boolean siteMapCacheFileExists = this.checkIfFileExists(key);
        if (StringUtils.isEmpty((Object)ETag) || !siteMapCacheFileExists) {
            int MAX_ATTEMPTS = 3;
            for (int nSaveAttempts = 1; nSaveAttempts < MAX_ATTEMPTS && (StringUtils.isEmpty((Object)ETag) || !siteMapCacheFileExists); ++nSaveAttempts) {
                log.info("Failed to save to swift(Filename=" + key + ",siteMapCacheFileExists=" + siteMapCacheFileExists + ")");
                try {
                    long timeout = (long)nSaveAttempts * 5000L;
                    log.info("Waiting " + timeout / 1000L + "seconds to try again");
                    Thread.sleep(timeout);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                log.info("Retrying to save the file");
                ETag = this.objectStorageProvider.put(key, (Payload)payload);
                siteMapCacheFileExists = this.checkIfFileExists(key);
            }
        }
    }

    private boolean checkIfFileExists(String key) {
        return this.objectStorageProvider.getWithoutBody(key).isPresent();
    }

    public MongoProvider getMongoProvider() {
        return this.mongoProvider;
    }

    public void setMongoProvider(MongoProvider mongoProvider) {
        this.mongoProvider = mongoProvider;
    }

    public ObjectStorageClient getObjectStorageProvider() {
        return this.objectStorageProvider;
    }

    public void setObjectStorageProvider(ObjectStorageClient objectStorageProvider) {
        this.objectStorageProvider = objectStorageProvider;
    }

    public void delete() {
        List list = this.objectStorageProvider.list();
        if (list.isEmpty()) {
            log.info("No files to remove.");
        } else {
            log.info("Files to remove: " + (list.size() / 2 - 1));
        }
        int i = 0;
        String inactiveFilename = this.activeSiteMapService.getInactiveFile();
        log.info("Deleting all old files with the name " + inactiveFilename);
        for (StorageObject obj : list) {
            if (obj.getName().contains(inactiveFilename)) {
                this.objectStorageProvider.delete(obj.getName());
                ++i;
            }
            if (i != 100) continue;
            log.info("Removed 100 files");
        }
        log.info("Removed all files");
    }

    public void update() {
        log.info("Status :" + status);
        if (status.equalsIgnoreCase("working")) {
            throw new SitemapNotReadyException();
        }
        status = "working";
        this.delete();
        this.generate();
        this.activeSiteMapService.switchFile();
        status = "done";
    }
}

