/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.sitemap.service;

import eu.europeana.domain.StorageObject;
import eu.europeana.features.ObjectStorageClient;
import eu.europeana.sitemap.service.MongoSitemapService;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.jclouds.io.Payload;
import org.jclouds.io.payloads.StringPayload;

public class ActiveSiteMapService {
    private static final Logger log = Logger.getLogger(MongoSitemapService.class.getName());
    public static final String EUROPEANA_SITEMAP_HASHED_GREEN = "europeana-sitemap-hashed-green.xml";
    public static final String EUROPEANA_SITEMAP_HASHED_BLUE = "europeana-sitemap-hashed-blue.xml";
    public static final String EUROPEANA_ACTIVE_SITEMAP_SWITCH_FILE = "europeana-sitemap-active-xml-file.txt";
    @Resource
    private ObjectStorageClient objectStorageProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getActiveFile() {
        StorageObject storageObjectValue;
        String result;
        block9: {
            result = "";
            String activeSiteMapFile = EUROPEANA_ACTIVE_SITEMAP_SWITCH_FILE;
            Optional withoutBody = this.objectStorageProvider.getWithoutBody(activeSiteMapFile);
            storageObjectValue = null;
            InputStream in = null;
            if (!withoutBody.isPresent()) {
                this.saveToStorageProvider(EUROPEANA_SITEMAP_HASHED_GREEN);
                return EUROPEANA_SITEMAP_HASHED_GREEN;
            }
            try {
                StringWriter writer = new StringWriter();
                Optional storageObject = this.objectStorageProvider.get(activeSiteMapFile);
                storageObjectValue = (StorageObject)storageObject.get();
                in = storageObjectValue.getPayload().openStream();
                IOUtils.copy((InputStream)in, (Writer)writer);
                result = writer.toString();
                in.close();
                storageObjectValue.getPayload().close();
                if (in == null) break block9;
            }
            catch (IOException e) {
                block10: {
                    try {
                        log.log(Level.SEVERE, String.format("Error while processing the file: %s to determen the current active site map", activeSiteMapFile), e.getCause());
                        if (in == null) break block10;
                    }
                    catch (Throwable throwable) {
                        if (in != null) {
                            IOUtils.closeQuietly(in);
                        }
                        if (storageObjectValue != null) {
                            IOUtils.closeQuietly((Closeable)storageObjectValue.getPayload());
                        }
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)in);
                }
                if (storageObjectValue != null) {
                    IOUtils.closeQuietly((Closeable)storageObjectValue.getPayload());
                }
            }
            IOUtils.closeQuietly((InputStream)in);
        }
        if (storageObjectValue != null) {
            IOUtils.closeQuietly((Closeable)storageObjectValue.getPayload());
        }
        return result;
    }

    public String getInactiveFile() {
        String result = this.getActiveFile().equals(EUROPEANA_SITEMAP_HASHED_GREEN) ? EUROPEANA_SITEMAP_HASHED_BLUE : EUROPEANA_SITEMAP_HASHED_GREEN;
        return result;
    }

    public void switchFile() {
        if (this.getActiveFile().equals(EUROPEANA_SITEMAP_HASHED_GREEN)) {
            log.info("Switching to europeana-sitemap-hashed-blue.xml");
            this.saveToStorageProvider(EUROPEANA_SITEMAP_HASHED_BLUE);
        } else {
            log.info("Switching to europeana-sitemap-hashed-green.xml");
            this.saveToStorageProvider(EUROPEANA_SITEMAP_HASHED_GREEN);
        }
    }

    private String saveToStorageProvider(String value) {
        StringPayload payload = new StringPayload(value);
        return this.objectStorageProvider.put(EUROPEANA_ACTIVE_SITEMAP_SWITCH_FILE, (Payload)payload);
    }

    public ObjectStorageClient getObjectStorageProvider() {
        return this.objectStorageProvider;
    }

    public void setObjectStorageProvider(ObjectStorageClient objectStorageProvider) {
        this.objectStorageProvider = objectStorageProvider;
    }
}

