/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.sitemap.mongo;

import com.mongodb.DBCollection;
import com.mongodb.MongoClient;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;

public class MongoProvider {
    private DBCollection collection;

    public MongoProvider(String mongoHosts, String port, String username, String password, String database) {
        String[] addresses = mongoHosts.split(",");
        ArrayList<ServerAddress> mongoAddresses = new ArrayList<ServerAddress>();
        try {
            for (String address : addresses) {
                ServerAddress mongoAddress = new ServerAddress(address, Integer.parseInt(port));
                mongoAddresses.add(mongoAddress);
            }
            MongoCredential credential = MongoCredential.createCredential((String)username, (String)database, (char[])password.toCharArray());
            ArrayList<MongoCredential> credentials = new ArrayList<MongoCredential>();
            credentials.add(credential);
            MongoClient mongoClient = new MongoClient(mongoAddresses, credentials);
            this.collection = mongoClient.getDB(database).getCollection("record");
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    public DBCollection getCollection() {
        return this.collection;
    }
}

