/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.sitemap.jedis;

import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisProvider {
    JedisPool pool;

    public RedisProvider(String host, int port, String password) {
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setTestOnBorrow(true);
        poolConfig.setTestOnReturn(true);
        poolConfig.setMaxIdle(5);
        poolConfig.setMinIdle(1);
        poolConfig.setTestWhileIdle(true);
        poolConfig.setNumTestsPerEvictionRun(10);
        poolConfig.setTimeBetweenEvictionRunsMillis(60000L);
        this.pool = new JedisPool((GenericObjectPoolConfig)poolConfig, host, port, 300, password);
    }

    public Jedis getJedis() {
        Jedis jedis = this.pool.getResource();
        return jedis;
    }

    public void returnJedis(Jedis jedis) {
        this.pool.returnResource(jedis);
    }
}

