/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.set.web.service.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.europeana.api.commons.definitions.search.Query;
import eu.europeana.api.commons.definitions.search.ResultSet;
import eu.europeana.api.commons.oauth2.model.ApiCredentials;
import eu.europeana.api.commons.web.exception.ApplicationAuthenticationException;
import eu.europeana.api.commons.web.exception.HttpException;
import eu.europeana.api.commons.web.exception.InternalServerException;
import eu.europeana.api.commons.web.exception.ParamValidationException;
import eu.europeana.set.definitions.exception.UserSetAttributeInstantiationException;
import eu.europeana.set.definitions.exception.UserSetInstantiationException;
import eu.europeana.set.definitions.model.UserSet;
import eu.europeana.set.definitions.model.agent.Agent;
import eu.europeana.set.definitions.model.search.UserSetQuery;
import eu.europeana.set.definitions.model.utils.UserSetUtils;
import eu.europeana.set.definitions.model.vocabulary.LdProfiles;
import eu.europeana.set.definitions.model.vocabulary.UserSetTypes;
import eu.europeana.set.definitions.model.vocabulary.VisibilityTypes;
import eu.europeana.set.mongo.model.internal.PersistentUserSet;
import eu.europeana.set.search.exception.SearchApiClientException;
import eu.europeana.set.search.service.SearchApiResponse;
import eu.europeana.set.web.exception.request.RequestBodyValidationException;
import eu.europeana.set.web.exception.response.UserSetNotFoundException;
import eu.europeana.set.web.model.WebUser;
import eu.europeana.set.web.model.WebUserSetImpl;
import eu.europeana.set.web.model.vocabulary.Roles;
import eu.europeana.set.web.search.BaseUserSetResultPage;
import eu.europeana.set.web.search.CollectionView;
import eu.europeana.set.web.search.UserSetIdsResultPage;
import eu.europeana.set.web.search.UserSetResultPage;
import eu.europeana.set.web.service.UserSetService;
import eu.europeana.set.web.service.impl.BaseUserSetServiceImpl;
import ioinformarics.oss.jackson.module.jsonld.JsonldModule;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.web.util.UriComponentsBuilder;

public class UserSetServiceImpl
extends BaseUserSetServiceImpl
implements UserSetService {
    @Override
    public UserSet storeUserSet(UserSet newUserSet, Authentication authentication) throws HttpException {
        WebUser user = new WebUser();
        user.setHttpUrl(this.getUserId(authentication));
        user.setNickname(((ApiCredentials)authentication.getCredentials()).getUserName());
        newUserSet.setCreator((Agent)user);
        if (newUserSet.getVisibility() == null) {
            newUserSet.setVisibility(VisibilityTypes.PRIVATE.getJsonValue());
        }
        this.validateWebUserSet(newUserSet);
        UserSet extUserSet = this.getUserSetUtils().analysePagination(newUserSet);
        return this.getMongoPersistence().store(extUserSet);
    }

    @Override
    public UserSet getUserSetById(String userSetId) throws UserSetNotFoundException {
        PersistentUserSet res = this.getMongoPersistence().getByIdentifier(userSetId);
        if (res == null) {
            throw new UserSetNotFoundException("error.userset_not_found", "error.userset_not_found", new String[]{userSetId});
        }
        return res;
    }

    @Override
    public List<PersistentUserSet> getUserSetByCreatorId(String creatorId) throws UserSetNotFoundException {
        return this.getMongoPersistence().getByCreator(creatorId).asList();
    }

    public UserSet getBookmarksFolder(Agent creator) {
        return this.getMongoPersistence().getBookmarksFolder(creator.getHttpUrl());
    }

    @Override
    public UserSet fillPagination(UserSet userSet) {
        return this.getUserSetUtils().fillPagination(userSet);
    }

    @Override
    public UserSet updatePagination(UserSet userSet) {
        return this.getUserSetUtils().updatePagination(userSet);
    }

    @Override
    public UserSet parseUserSetLd(String userSetJsonLdStr) throws RequestBodyValidationException, UserSetInstantiationException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JsonldModule());
        mapper.configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, true);
        JsonFactory jsonFactory = mapper.getFactory();
        try {
            JsonParser parser = jsonFactory.createParser(userSetJsonLdStr);
            UserSet userSet = (UserSet)mapper.readValue(parser, WebUserSetImpl.class);
            if (userSet.getModified() == null) {
                Date now = new Date();
                userSet.setModified(now);
            }
            this.removeItemDuplicates(userSet);
            return userSet;
        }
        catch (UserSetAttributeInstantiationException e) {
            throw new RequestBodyValidationException("error.userset_cant_parse_body", new String[]{e.getMessage()}, e);
        }
        catch (JsonParseException e) {
            throw new UserSetInstantiationException("Json formating exception! " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new UserSetInstantiationException("Json reading exception! " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void removeItemDuplicates(UserSet userSet) {
        if (userSet.getItems() != null && !userSet.getItems().isEmpty()) {
            List distinctItems = userSet.getItems().stream().distinct().collect(Collectors.toList());
            userSet.setItems(distinctItems);
        }
    }

    @Override
    public void validateWebUserSet(UserSet webUserSet) throws RequestBodyValidationException, ParamValidationException {
        if (webUserSet.getTitle() == null && !this.isBookmarksFolder(webUserSet)) {
            throw new RequestBodyValidationException("error.userset_validation_mandatory_property", new String[]{"title"});
        }
        if (webUserSet.getItems() != null && webUserSet.isOpenSet()) {
            throw new RequestBodyValidationException("error.userset_validation_property_not_allowed", new String[]{"items", "open"});
        }
        this.validateBookmarkFolder(webUserSet);
        this.validateControlledValues(webUserSet);
        this.validateIsDefinedBy(webUserSet);
    }

    private void validateBookmarkFolder(UserSet webUserSet) throws RequestBodyValidationException, ParamValidationException {
        if (!this.isBookmarksFolder(webUserSet)) {
            return;
        }
        if (!webUserSet.isPrivate()) {
            throw new ParamValidationException("error.userset_validation_property_value", "error.userset_validation_property_value", new String[]{"visibility", webUserSet.getVisibility()});
        }
        if (webUserSet.isOpenSet()) {
            throw new ParamValidationException("error.userset_validation_property_not_allowed", "error.userset_validation_property_not_allowed", new String[]{"isDefinedBy", webUserSet.getType()});
        }
        if (webUserSet.getCreator() == null || webUserSet.getCreator().getHttpUrl() == null) {
            throw new ParamValidationException("error.userset_validation_mandatory_property", "error.userset_validation_mandatory_property", new String[]{"creator"});
        }
        UserSet usersBookmarkFolder = this.getBookmarksFolder(webUserSet.getCreator());
        if (usersBookmarkFolder == null) {
            return;
        }
        if (webUserSet.getIdentifier() == null) {
            throw new RequestBodyValidationException("error.userset_validation_bookmark_folder_exists", new String[]{usersBookmarkFolder.getIdentifier(), usersBookmarkFolder.getCreator().getHttpUrl()});
        }
        if (!webUserSet.getIdentifier().equals(usersBookmarkFolder.getIdentifier())) {
            throw new RequestBodyValidationException("error.userset_validation_bookmark_folder_exists", new String[]{usersBookmarkFolder.getIdentifier(), usersBookmarkFolder.getCreator().getHttpUrl()});
        }
    }

    private void validateControlledValues(UserSet webUserSet) throws RequestBodyValidationException {
        if (webUserSet.getVisibility() != null && !VisibilityTypes.isValid((String)webUserSet.getVisibility())) {
            throw new RequestBodyValidationException("error.userset_validation_property_value", new String[]{"visibility", webUserSet.getVisibility()});
        }
        if (webUserSet.getType() != null && !UserSetTypes.isValid((String)webUserSet.getType())) {
            throw new RequestBodyValidationException("error.userset_validation_property_value", new String[]{"type", webUserSet.getType()});
        }
    }

    private void validateIsDefinedBy(UserSet webUserSet) throws ParamValidationException, RequestBodyValidationException {
        if (webUserSet.isOpenSet()) {
            SearchApiResponse apiResult;
            StringBuilder validateUrl;
            String queryUrl;
            String searchUrl = this.getBaseSearchUrl(this.getConfiguration().getSearchApiUrl());
            if (!searchUrl.equals(queryUrl = this.getBaseSearchUrl((validateUrl = new StringBuilder(webUserSet.getIsDefinedBy())).toString()))) {
                throw new ParamValidationException("error.userset_validation_property_value", "error.userset_validation_property_value", new String[]{"isDefinedBy", " the access to api endpoint is not allowed: " + queryUrl});
            }
            String apiKey = this.getConfiguration().getSearchApiKey();
            try {
                validateUrl.append("&rows=0");
                apiResult = this.getSearchApiClient().searchItems(validateUrl.toString(), apiKey, false);
            }
            catch (SearchApiClientException e) {
                throw new RequestBodyValidationException("error.userset_validation_property_value", new String[]{"isDefinedBy", "an error occured when calling " + validateUrl}, e);
            }
            if (apiResult.getTotal() <= 0) {
                throw new RequestBodyValidationException("error.userset_validation_property_value", new String[]{"isDefinedBy", "no items returned when calling " + validateUrl});
            }
        }
    }

    private String getBaseSearchUrl(String searchUrl) {
        String res = searchUrl;
        int endPos = searchUrl.indexOf(63);
        if (endPos >= 0) {
            res = searchUrl.substring(0, endPos);
        }
        return res;
    }

    boolean isBookmarksFolder(UserSet userSet) {
        return UserSetTypes.BOOKMARKSFOLDER.getJsonValue().equals(userSet.getType());
    }

    @Override
    public void deleteUserSet(String userSetId) throws UserSetNotFoundException {
        this.getMongoPersistence().remove(userSetId);
    }

    @Override
    public void deleteUserSets(String creatorId, List<PersistentUserSet> userSets) {
        ArrayList<String> setsToBeDeleted = new ArrayList<String>();
        if (!userSets.isEmpty()) {
            for (PersistentUserSet userSet : userSets) {
                setsToBeDeleted.add(userSet.getIdentifier());
            }
        }
        this.getMongoPersistance().removeAll(userSets);
        this.getLogger().info("User sets deleted for user {}. Sets deleted are : {} ", (Object)creatorId, setsToBeDeleted);
    }

    @Override
    public int validatePosition(String position, List<String> items) throws ApplicationAuthenticationException {
        int positionInt = -1;
        if (StringUtils.isNotEmpty((CharSequence)position)) {
            try {
                positionInt = Integer.parseInt(position);
                if (positionInt > items.size()) {
                    positionInt = -1;
                }
            }
            catch (RuntimeException e) {
                this.getLogger().trace("Position validation warning: {} ", (Object)position, (Object)e);
            }
        }
        return positionInt;
    }

    @Override
    public UserSet insertItem(String datasetId, String localId, String position, UserSet existingUserSet) throws ApplicationAuthenticationException {
        int positionInt = this.validatePosition(position, existingUserSet.getItems());
        String newItem = UserSetUtils.buildItemUrl((String)"http://data.europeana.eu/item/", (String)datasetId, (String)localId);
        UserSet extUserSet = null;
        if (existingUserSet.getItems() == null) {
            this.addNewItemToList(existingUserSet, -1, newItem);
            extUserSet = this.updateItemList(existingUserSet);
        } else if (!existingUserSet.getItems().contains(newItem)) {
            this.addNewItemToList(existingUserSet, positionInt, newItem);
            extUserSet = this.updateItemList(existingUserSet);
        } else {
            int currentPos = existingUserSet.getItems().indexOf(newItem);
            if (currentPos == positionInt) {
                extUserSet = this.fillPagination(existingUserSet);
            } else {
                this.replaceItem(existingUserSet, positionInt, newItem);
                extUserSet = this.updateItemList(existingUserSet);
            }
        }
        return extUserSet;
    }

    @Override
    public UserSet updateItemList(UserSet existingUserSet) {
        this.updateUserSetPagination(existingUserSet);
        existingUserSet.setModified(new Date());
        UserSet updatedUserSet = this.updateUserSetInDb(existingUserSet, null);
        UserSet extUserSet = this.fillPagination(updatedUserSet);
        return extUserSet;
    }

    @Override
    public void replaceItem(UserSet existingUserSet, int positionInt, String newItem) {
        existingUserSet.getItems().remove(newItem);
        this.addNewItemToList(existingUserSet, positionInt, newItem);
    }

    @Override
    public void addNewItemToList(UserSet existingUserSet, int positionInt, String newItem) {
        if (existingUserSet.getItems() == null) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(newItem);
            existingUserSet.setItems(list);
        } else if (positionInt == -1) {
            existingUserSet.getItems().add(newItem);
        } else {
            existingUserSet.getItems().add(positionInt, newItem);
        }
    }

    @Override
    public UserSet fetchItems(UserSet userSet, String sort, String sortOrder, int pageNr, int pageSize, LdProfiles profile) throws HttpException {
        if (!userSet.isOpenSet() && (userSet.getItems() == null || userSet.getItems() != null && userSet.getItems().isEmpty())) {
            return userSet;
        }
        String apiKey = this.getConfiguration().getSearchApiKey();
        String url = this.buildSearchApiUrl(userSet, apiKey, sort, sortOrder, pageNr, pageSize);
        try {
            if (LdProfiles.STANDARD == profile) {
                SearchApiResponse apiResult = this.getSearchApiClient().searchItems(url, apiKey, false);
                this.setItemIds(userSet, apiResult);
            } else if (LdProfiles.ITEMDESCRIPTIONS == profile) {
                SearchApiResponse apiResult = this.getSearchApiClient().searchItems(url, apiKey, true);
                int total = apiResult.getTotal();
                if (!userSet.isOpenSet()) {
                    total = userSet.getItems().size();
                }
                this.setItems(userSet, apiResult.getItems(), total);
            }
            return userSet;
        }
        catch (SearchApiClientException e) {
            if ("An error occured when retrieving items through search API. isDefinedBy might not be a valid API URL.".equals(e.getMessage())) {
                throw new RequestBodyValidationException("error.userset_validation_property_value", new String[]{"isDefinedBy", url}, e);
            }
            throw new InternalServerException((Throwable)e);
        }
    }

    private void setItemIds(UserSet userSet, SearchApiResponse apiResult) {
        if (apiResult.getItems() == null) {
            return;
        }
        ArrayList<String> items = new ArrayList<String>(apiResult.getItems().size());
        for (String item : apiResult.getItems()) {
            items.add(UserSetUtils.buildItemUrl((String)item));
        }
        this.setItems(userSet, items, apiResult.getTotal());
    }

    private void setItems(UserSet userSet, List<String> items, int total) {
        userSet.setItems(items);
        userSet.setTotal(total);
    }

    private String buildSearchApiUrl(UserSet userSet, String apiKey, String sort, String sortOrder, int pageNr, int pageSize) {
        if (!userSet.isOpenSet()) {
            return this.buildSearchApiUrlForClosedSets(userSet, apiKey);
        }
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)userSet.getIsDefinedBy());
        uriBuilder.replaceQueryParam("profile", new Object[]{"minimal"});
        Integer start = pageNr * pageSize + 1;
        uriBuilder.replaceQueryParam("start", new Object[]{start});
        uriBuilder.replaceQueryParam("rows", new Object[]{pageSize});
        if (apiKey != null) {
            uriBuilder.replaceQueryParam("wskey", new Object[]{apiKey});
        }
        if (sortOrder == null) {
            uriBuilder.replaceQueryParam("sort", new Object[]{sort});
        } else {
            uriBuilder.replaceQueryParam("sort", new Object[]{sort + "+" + sortOrder});
        }
        return uriBuilder.build(true).toUriString();
    }

    @Override
    @Deprecated(since="")
    public UserSet updateUserSetInDb(UserSet storedUserSet, List<String> items) {
        storedUserSet.setModified(new Date());
        return this.getMongoPersistence().update((PersistentUserSet)storedUserSet);
    }

    @Override
    public ResultSet<? extends UserSet> search(UserSetQuery searchQuery, LdProfiles profile, Authentication authentication) {
        searchQuery.setAdmin(this.hasAdminRights(authentication));
        searchQuery.setUser(this.getUserId(authentication));
        return this.getMongoPersistance().find(searchQuery);
    }

    @Override
    public BaseUserSetResultPage<?> buildResultsPage(UserSetQuery searchQuery, ResultSet<? extends UserSet> results, StringBuilder requestUrl, String reqParams, LdProfiles profile, Authentication authentication) throws HttpException {
        BaseUserSetResultPage resPage = null;
        int resultPageSize = results.getResults().size();
        if (LdProfiles.STANDARD == profile || LdProfiles.ITEMDESCRIPTIONS == profile) {
            resPage = new UserSetResultPage();
            this.setPageItems(results, (UserSetResultPage)resPage, authentication, profile);
        } else {
            resPage = new UserSetIdsResultPage();
            this.setPageItems(results, (UserSetIdsResultPage)resPage, resultPageSize);
        }
        int lastPage = this.getLastPage(results.getResultSize(), searchQuery.getPageSize());
        String collectionUrl = this.buildCollectionUrl((Query)searchQuery, requestUrl, reqParams);
        String first = this.buildPageUrl(collectionUrl, 0, searchQuery.getPageSize());
        String last = this.buildPageUrl(collectionUrl, lastPage, searchQuery.getPageSize());
        resPage.setPartOf(new CollectionView(collectionUrl, results.getResultSize(), first, last));
        int currentPage = searchQuery.getPageNr();
        String currentPageUrl = this.buildPageUrl(collectionUrl, currentPage, searchQuery.getPageSize());
        resPage.setCurrentPageUri(currentPageUrl);
        if (currentPage > 0) {
            String prevPage = this.buildPageUrl(collectionUrl, currentPage - 1, searchQuery.getPageSize());
            resPage.setPrevPageUri(prevPage);
        }
        if (!this.isLastPage(currentPage, lastPage)) {
            String nextPage = this.buildPageUrl(collectionUrl, currentPage + 1, searchQuery.getPageSize());
            resPage.setNextPageUri(nextPage);
        }
        return resPage;
    }

    protected int getLastPage(long totalResults, int pageSize) {
        long lastPage = 0L;
        if (totalResults > 0L) {
            long reaminder = totalResults % (long)pageSize;
            int extraPage = reaminder == 0L ? 0 : 1;
            lastPage = totalResults / (long)pageSize + (long)extraPage - 1L;
        }
        return Math.toIntExact(lastPage);
    }

    private boolean isLastPage(int currentPage, int lastPage) {
        return currentPage == lastPage;
    }

    private void setPageItems(ResultSet<? extends UserSet> results, UserSetIdsResultPage resPage, int resultPageSize) {
        ArrayList<String> items = new ArrayList<String>(resultPageSize);
        for (UserSet set : results.getResults()) {
            items.add(((WebUserSetImpl)set).getId());
        }
        resPage.setItems(items);
        resPage.setTotalInPage(items.size());
    }

    private void setPageItems(ResultSet<? extends UserSet> results, UserSetResultPage resPage, Authentication authentication, LdProfiles profile) throws HttpException {
        ArrayList<Object> items = new ArrayList<Object>(results.getResults().size());
        int derefItems = 5;
        for (UserSet userSet : results.getResults()) {
            if (LdProfiles.ITEMDESCRIPTIONS == profile) {
                this.fetchItems(userSet, null, null, 0, derefItems, profile);
            }
            if (!userSet.isPrivate()) {
                items.add(userSet);
            } else if (this.isOwner(userSet, authentication) || this.hasAdminRights(authentication)) {
                items.add(userSet);
            } else {
                WebUserSetImpl id = new WebUserSetImpl();
                id.setIdentifier(userSet.getIdentifier());
                items.add(id);
            }
            this.applyProfile(userSet, profile);
        }
        resPage.setItems(items);
        resPage.setTotalInPage(items.size());
    }

    protected String buildPageUrl(String collectionUrl, int page, int pageSize) {
        StringBuilder builder = new StringBuilder(collectionUrl);
        builder.append("&").append("page").append("=").append(page);
        builder.append("&").append("pageSize").append("=").append(pageSize);
        return builder.toString();
    }

    private String buildCollectionUrl(Query searchQuery, StringBuilder requestUrl, String queryString) {
        queryString = this.removeParam("page", (String)queryString);
        queryString = this.removeParam("pageSize", (String)queryString);
        queryString = this.removeParam("profile", (String)queryString);
        if (StringUtils.isNotBlank((CharSequence)searchQuery.getSearchProfile())) {
            queryString = (String)queryString + "&profile=" + searchQuery.getSearchProfile();
        }
        return requestUrl.append("?").append((String)queryString).toString();
    }

    protected String removeParam(String queryParam, String queryParams) {
        String tmp;
        int startPos = queryParams.indexOf(queryParam + "=");
        int startEndPos = queryParams.indexOf(38, startPos + 1);
        if (startPos >= 0) {
            if (startPos > 0) {
                --startPos;
            }
            tmp = queryParams.substring(0, startPos);
            if (startEndPos > 0) {
                tmp = tmp + queryParams.substring(startEndPos);
            }
        } else {
            tmp = queryParams;
        }
        return tmp;
    }

    public boolean isOwner(UserSet userSet, Authentication authentication) {
        if (authentication == null) {
            return false;
        }
        if (userSet.getCreator() == null || userSet.getCreator().getHttpUrl() == null) {
            return false;
        }
        String userId = UserSetUtils.buildCreatorUri((String)((String)authentication.getPrincipal()));
        return userSet.getCreator().getHttpUrl().equals(userId);
    }

    @Override
    public String getUserId(Authentication authentication) {
        return UserSetUtils.buildCreatorUri((String)((String)authentication.getPrincipal()));
    }

    @Override
    public UserSet verifyOwnerOrAdmin(UserSet userSet, Authentication authentication) throws HttpException {
        if (authentication == null) {
            throw new ApplicationAuthenticationException("error.userset_user_not_authorized", "error.userset_user_not_authorized", new String[]{"Access to update operations of private User Sets require user authentication with JwtToken"}, HttpStatus.FORBIDDEN);
        }
        if (this.isOwner(userSet, authentication) || this.hasAdminRights(authentication)) {
            return userSet;
        }
        throw new ApplicationAuthenticationException("error.operation_not_authorized", "error.operation_not_authorized", new String[]{"Only the creators of the user set or admins are authorized to perform this operation."}, HttpStatus.FORBIDDEN);
    }

    protected boolean hasAdminRights(Authentication authentication) {
        if (authentication == null) {
            return false;
        }
        Iterator iterator = authentication.getAuthorities().iterator();
        while (iterator.hasNext()) {
            String role = ((GrantedAuthority)iterator.next()).getAuthority();
            if (!Roles.ADMIN.getName().equalsIgnoreCase(role)) continue;
            return true;
        }
        return false;
    }

    private String buildSearchApiUrlForClosedSets(UserSet userSet, String apiKey) {
        int maxDerefItems = 100;
        int maxItems = Math.min(userSet.getItems().size(), maxDerefItems);
        StringBuilder query = new StringBuilder(100);
        query.append("europeana_id:(");
        for (int i = 0; i < maxItems; ++i) {
            String fullId = (String)userSet.getItems().get(i);
            if (i > 0) {
                query.append(" OR ");
            }
            String id = fullId.replace("http://data.europeana.eu/item/", "");
            query.append('\"').append('/').append(id).append('\"');
        }
        query.append(')');
        StringBuilder url = new StringBuilder(this.getConfiguration().getSearchApiUrl());
        url.append(URLEncoder.encode(query.toString(), StandardCharsets.UTF_8));
        url.append('&').append("wskey").append('=').append(apiKey);
        url.append('&').append("rows").append('=').append(maxDerefItems);
        return url.toString();
    }

    @Override
    public UserSet applyProfile(UserSet userSet, LdProfiles profile) {
        int itemsCount;
        if (profile != LdProfiles.MINIMAL && userSet.getItems() != null && (itemsCount = userSet.getItems().size()) > 1000) {
            List itemsPage = userSet.getItems().subList(0, 1000);
            userSet.setItems(itemsPage);
            profile = LdProfiles.STANDARD;
            this.getLogger().debug("Profile switched to standard, due to set size!");
        }
        switch (profile) {
            case ITEMDESCRIPTIONS: {
                ((WebUserSetImpl)userSet).setSerializedItems(userSet.getItems());
                break;
            }
            case STANDARD: {
                this.setSerializedItemIds(userSet);
                break;
            }
            case MINIMAL: {
                if (userSet.isOpenSet()) {
                    userSet.setTotal(-1);
                }
                userSet.setItems(null);
                break;
            }
            default: {
                userSet.setItems(null);
            }
        }
        return userSet;
    }

    private void setSerializedItemIds(UserSet userSet) {
        if (userSet.getItems() == null) {
            return;
        }
        ArrayList<CallSite> jsonSerialized = new ArrayList<CallSite>(userSet.getItems().size());
        for (String itemId : userSet.getItems()) {
            jsonSerialized.add((CallSite)((Object)("\"" + itemId + "\"")));
        }
        ((WebUserSetImpl)userSet).setSerializedItems(jsonSerialized);
    }
}

