/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.set.web.service.impl;

import eu.europeana.api.commons.config.i18n.I18nService;
import eu.europeana.set.definitions.config.UserSetConfiguration;
import eu.europeana.set.definitions.model.UserSet;
import eu.europeana.set.definitions.model.utils.UserSetUtils;
import eu.europeana.set.mongo.model.internal.PersistentUserSet;
import eu.europeana.set.mongo.service.PersistentUserSetService;
import eu.europeana.set.search.service.SearchApiClient;
import eu.europeana.set.search.service.impl.SearchApiClientImpl;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BaseUserSetServiceImpl {
    @Resource
    PersistentUserSetService mongoPersistance;
    @Resource
    I18nService i18nService;
    UserSetUtils userSetUtils = new UserSetUtils();
    @Resource
    UserSetConfiguration configuration;
    private SearchApiClient setApiService = new SearchApiClientImpl();
    Logger logger = LogManager.getLogger(this.getClass());

    protected PersistentUserSetService getMongoPersistence() {
        return this.mongoPersistance;
    }

    public void setMongoPersistance(PersistentUserSetService mongoPersistance) {
        this.mongoPersistance = mongoPersistance;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public PersistentUserSetService getMongoPersistance() {
        return this.mongoPersistance;
    }

    public UserSetUtils getUserSetUtils() {
        return this.userSetUtils;
    }

    public SearchApiClient getSearchApiClient() {
        return this.setApiService;
    }

    protected UserSetConfiguration getConfiguration() {
        return this.configuration;
    }

    @Deprecated(since="")
    void mergeUserSetProperties(PersistentUserSet persistedSet, UserSet updates) {
        if (updates == null) {
            return;
        }
        this.mergeDescriptiveProperties(persistedSet, updates);
        this.mergeProvenanceProperties(persistedSet, updates);
        if (updates.getIsDefinedBy() != null) {
            persistedSet.setIsDefinedBy(updates.getIsDefinedBy());
        }
    }

    void mergeProvenanceProperties(PersistentUserSet persistedSet, UserSet updates) {
        if (updates.getCreator() != null) {
            persistedSet.setCreator(updates.getCreator());
        }
        if (updates.getCreated() != null) {
            persistedSet.setCreated(updates.getCreated());
        }
    }

    void mergeDescriptiveProperties(PersistentUserSet persistedSet, UserSet updates) {
        if (updates.getType() != null) {
            persistedSet.setType(updates.getType());
        }
        if (updates.getVisibility() != null) {
            persistedSet.setVisibility(updates.getVisibility());
        }
        if (updates.getTitle() != null) {
            if (persistedSet.getTitle() != null) {
                for (Map.Entry entry : updates.getTitle().entrySet()) {
                    persistedSet.getTitle().put((String)entry.getKey(), (String)entry.getValue());
                }
            } else {
                persistedSet.setTitle(updates.getTitle());
            }
        }
        if (updates.getDescription() != null) {
            if (persistedSet.getDescription() != null) {
                for (Map.Entry entry : updates.getDescription().entrySet()) {
                    persistedSet.getDescription().put((String)entry.getKey(), (String)entry.getValue());
                }
            } else {
                persistedSet.setDescription(updates.getDescription());
            }
        }
    }

    public UserSet updateUserSet(PersistentUserSet persistentUserSet, UserSet webUserSet) {
        this.mergeUserSetProperties(persistentUserSet, webUserSet);
        this.updateUserSetPagination((UserSet)persistentUserSet);
        persistentUserSet.setModified(new Date());
        return this.getMongoPersistence().update(persistentUserSet);
    }

    public void updateUserSetPagination(UserSet newUserSet) {
        this.getUserSetUtils().updatePagination(newUserSet);
    }
}

