/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.set.web.service.controller.jsonld;

import com.fasterxml.jackson.core.JsonParseException;
import eu.europeana.api.common.config.swagger.SwaggerSelect;
import eu.europeana.api.commons.web.exception.ApplicationAuthenticationException;
import eu.europeana.api.commons.web.exception.HttpException;
import eu.europeana.api.commons.web.exception.InternalServerException;
import eu.europeana.set.definitions.exception.UserSetAttributeInstantiationException;
import eu.europeana.set.definitions.exception.UserSetInstantiationException;
import eu.europeana.set.definitions.exception.UserSetValidationException;
import eu.europeana.set.definitions.model.UserSet;
import eu.europeana.set.definitions.model.utils.UserSetUtils;
import eu.europeana.set.definitions.model.vocabulary.LdProfiles;
import eu.europeana.set.mongo.model.internal.PersistentUserSet;
import eu.europeana.set.web.exception.request.RequestBodyValidationException;
import eu.europeana.set.web.exception.request.RequestValidationException;
import eu.europeana.set.web.exception.response.UserSetNotFoundException;
import eu.europeana.set.web.model.vocabulary.Roles;
import eu.europeana.set.web.service.controller.BaseRest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.codehaus.jettison.json.JSONException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Controller;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@SwaggerSelect
@Api(tags={"Web User Set API"})
public class WebUserSetRest
extends BaseRest {
    @PostMapping(value={"/set/"}, produces={"application/ld+json;charset=utf-8", "application/json;charset=utf-8"})
    @ApiOperation(notes="Please find JSON-LD samples for user set in <a href=\"../jsp/template/jsonld.jsp\" target=\"_blank\">templates</a>. ", value="Create user set", nickname="createUserSet", response=Void.class)
    public ResponseEntity<String> createUserSet(@RequestBody String userSet, @RequestParam(value="profile", required=false, defaultValue="minimal") String profile, HttpServletRequest request) throws HttpException {
        Authentication authentication = this.verifyWriteAccess("create", request);
        return this.storeUserSet(userSet, authentication, profile, request);
    }

    protected ResponseEntity<String> storeUserSet(String userSetJsonLdStr, Authentication authentication, String profileStr, HttpServletRequest request) throws HttpException {
        try {
            LdProfiles profile = this.getProfile(profileStr, request);
            UserSet webUserSet = this.getUserSetService().parseUserSetLd(userSetJsonLdStr);
            UserSet storedUserSet = this.getUserSetService().storeUserSet(webUserSet, authentication);
            if (this.mustFetchItems(storedUserSet, profile)) {
                storedUserSet = this.getUserSetService().fetchItems(storedUserSet, null, null, 0, 5, profile);
            }
            String serializedUserSetJsonLdStr = this.serializeUserSet(profile, storedUserSet);
            String etag = this.generateETag(storedUserSet.getModified(), "jsonld", this.getApiVersion());
            LinkedMultiValueMap headers = new LinkedMultiValueMap(5);
            headers.add((Object)"Link", (Object)"<http://www.w3.org/ns/ldp#BasicContainer>; rel=\"type\"");
            headers.add((Object)"Link", (Object)"<http://www.w3.org/ns/ldp#Resource>; rel=\"type\"");
            headers.add((Object)"Allow", (Object)"POST,GET");
            headers.add((Object)"Cache-Control", (Object)"no-cache, no-store, must-revalidate");
            headers.add((Object)"ETag", (Object)etag);
            headers.add((Object)"Preference-Applied", (Object)profile.getPreferHeaderValue());
            return new ResponseEntity((Object)serializedUserSetJsonLdStr, (MultiValueMap)headers, HttpStatus.CREATED);
        }
        catch (JsonParseException | UserSetAttributeInstantiationException | UserSetValidationException e) {
            throw new RequestBodyValidationException("error.userset_cant_parse_body", new String[]{e.getMessage()}, e);
        }
        catch (UserSetInstantiationException e) {
            throw new HttpException(null, "error.userset_invalid_body", null, HttpStatus.BAD_REQUEST, (Throwable)e);
        }
        catch (HttpException e) {
            throw e;
        }
        catch (IOException | RuntimeException | JSONException e) {
            throw new InternalServerException(e);
        }
    }

    @GetMapping(value={"/set/{identifier}", "/set/{identifier}.jsonld"}, produces={"application/ld+json;charset=utf-8", "application/json;charset=utf-8"})
    @ApiOperation(notes="Identifier is a number.", value="Retrieve a user set", nickname="retrieve", response=Void.class)
    public ResponseEntity<String> getUserSet(@RequestParam(value="wskey", required=false) String wskey, @PathVariable(value="identifier") String identifier, @RequestParam(value="sort", required=false) String sortField, @RequestParam(value="sortOrder", required=false) String sortOrderField, @RequestParam(value="page", defaultValue="0") int page, @RequestParam(value="pageSize", defaultValue="10") int pageSize, @RequestParam(value="profile", required=false, defaultValue="minimal") String profile, HttpServletRequest request) throws HttpException {
        Authentication authentication = this.verifyReadAccess(request);
        return this.getUserSet(profile, identifier, request, sortField, sortOrderField, page, pageSize, authentication);
    }

    private ResponseEntity<String> getUserSet(String profileStr, String identifier, HttpServletRequest request, String sort, String sortOrder, int pageNr, int pageSize, Authentication authentication) throws HttpException {
        try {
            LdProfiles profile = this.getProfile(profileStr, request);
            UserSet userSet = this.getUserSetService().getUserSetById(identifier);
            if (userSet.isPrivate()) {
                this.getUserSetService().verifyOwnerOrAdmin(userSet, authentication);
            }
            if (this.mustFetchItems(userSet, profile)) {
                userSet = this.getUserSetService().fetchItems(userSet, sort, sortOrder, pageNr, pageSize, profile);
            }
            String userSetJsonLdStr = this.serializeUserSet(profile, userSet);
            String etag = this.generateETag(userSet.getModified(), "jsonld", this.getApiVersion());
            LinkedMultiValueMap headers = new LinkedMultiValueMap(5);
            headers.add((Object)"Link", (Object)"<http://www.w3.org/ns/ldp#BasicContainer>; rel=\"type\"");
            headers.add((Object)"Link", (Object)"<http://www.w3.org/ns/ldp#Resource>; rel=\"type\"");
            headers.add((Object)"Allow", (Object)"GET,PUT,DELETE");
            headers.add((Object)"Vary", (Object)"Prefer");
            headers.add((Object)"Preference-Applied", (Object)profile.getPreferHeaderValue());
            headers.add((Object)"ETag", (Object)etag);
            return new ResponseEntity((Object)userSetJsonLdStr, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (HttpException e) {
            throw e;
        }
        catch (IOException | RuntimeException | JSONException e) {
            throw new InternalServerException(e);
        }
    }

    private boolean mustFetchItems(UserSet userSet, LdProfiles profile) {
        boolean itemDescriptionsProfile = LdProfiles.ITEMDESCRIPTIONS == profile;
        boolean fetchItemsForOpenSet = userSet.isOpenSet() && LdProfiles.MINIMAL != profile;
        return itemDescriptionsProfile || fetchItemsForOpenSet;
    }

    @PutMapping(value={"/set/{identifier}"}, produces={"application/ld+json;charset=utf-8", "application/json;charset=utf-8"})
    @ApiOperation(notes="Please find JSON-LD samples for user set in <a href=\"../jsp/template/jsonld.jsp\" target=\"_blank\">templates</a>. Please create your JSON update request using selected fields you are going to update. E.g. 'title' and 'description' example:  { \"title\": {\r\n \"en\": \"New Title\"\r\n  }\r\n }", value="Update an existing user set", nickname="update", response=Void.class)
    public ResponseEntity<String> updateUserSet(@PathVariable(value="identifier") String identifier, @RequestBody String userSet, @RequestParam(value="profile", required=false, defaultValue="minimal") String profile, HttpServletRequest request) throws HttpException {
        Authentication authentication = this.verifyWriteAccess("update", request);
        return this.updateUserSet(request, authentication, identifier, userSet, profile);
    }

    protected ResponseEntity<String> updateUserSet(HttpServletRequest request, Authentication authentication, String identifier, String userSetJsonLdStr, String profileStr) throws HttpException {
        try {
            LdProfiles profile = this.getProfile(profileStr, request);
            UserSet existingUserSet = this.getUserSetService().getUserSetById(identifier);
            this.checkVisibilityForUpdate(existingUserSet, authentication);
            String eTagOrigin = this.generateETag(existingUserSet.getModified(), "jsonld", this.getApiVersion());
            this.checkIfMatchHeader(eTagOrigin, request);
            UserSet newUserSet = this.getUserSetService().parseUserSetLd(userSetJsonLdStr);
            newUserSet.setCreator(existingUserSet.getCreator());
            newUserSet.setIdentifier(existingUserSet.getIdentifier());
            this.getUserSetService().validateWebUserSet(newUserSet);
            if (existingUserSet.isOpenSet() && !newUserSet.isOpenSet()) {
                throw new RequestBodyValidationException("error.userset_validation_mandatory_property", new String[]{"isDefinedBy (for open sets)"});
            }
            this.validateAndSetItems(existingUserSet, newUserSet, profile);
            this.getUserSetService().removeItemDuplicates(newUserSet);
            UserSet updatedUserSet = this.getUserSetService().updateUserSet((PersistentUserSet)existingUserSet, newUserSet);
            if (this.mustFetchItems(updatedUserSet, profile)) {
                updatedUserSet = this.getUserSetService().fetchItems(updatedUserSet, null, null, 0, 5, profile);
            }
            String serializedUserSetJsonLdStr = this.serializeUserSet(profile, updatedUserSet);
            String eTagNew = this.generateETag(updatedUserSet.getModified(), "jsonld", this.getApiVersion());
            LinkedMultiValueMap headers = new LinkedMultiValueMap(5);
            headers.add((Object)"Link", (Object)"<http://www.w3.org/ns/ldp#BasicContainer>; rel=\"type\"");
            headers.add((Object)"Link", (Object)"<http://www.w3.org/ns/ldp#Resource>; rel=\"type\"");
            headers.add((Object)"Allow", (Object)"GET,PUT,DELETE");
            headers.add((Object)"Vary", (Object)"Prefer");
            headers.add((Object)"Preference-Applied", (Object)profile.getPreferHeaderValue());
            headers.add((Object)"ETag", (Object)eTagNew);
            return new ResponseEntity((Object)serializedUserSetJsonLdStr, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (UserSetInstantiationException | UserSetValidationException e) {
            throw new RequestBodyValidationException("error.userset_cant_parse_body", new String[]{e.getMessage()}, e);
        }
        catch (HttpException e) {
            throw e;
        }
        catch (IOException | RuntimeException | JSONException e) {
            throw new InternalServerException(e);
        }
    }

    private void checkVisibilityForUpdate(UserSet existingUserSet, Authentication authentication) throws HttpException {
        if (this.hasEditorRole(authentication) && !existingUserSet.isPrivate()) {
            return;
        }
        this.getUserSetService().verifyOwnerOrAdmin(existingUserSet, authentication);
    }

    protected boolean hasEditorRole(Authentication authentication) {
        Iterator iterator = authentication.getAuthorities().iterator();
        while (iterator.hasNext()) {
            String role = ((GrantedAuthority)iterator.next()).getAuthority();
            if (!Roles.EDITOR.getName().equals(role)) continue;
            return true;
        }
        return false;
    }

    private void validateAndSetItems(UserSet storedUserSet, UserSet updateUserSet, LdProfiles profile) throws ApplicationAuthenticationException {
        if (storedUserSet.isOpenSet()) {
            return;
        }
        if (LdProfiles.MINIMAL == profile) {
            if (updateUserSet.getItems() != null && updateUserSet.getItems().size() > 0) {
                throw new ApplicationAuthenticationException("error.userset_minimal_update_profile", "error.userset_minimal_update_profile", new String[0], HttpStatus.PRECONDITION_FAILED, null);
            }
        } else {
            if (updateUserSet.getItems() == null || updateUserSet.getItems().size() == 0) {
                throw new ApplicationAuthenticationException("error.userset_contains_no_items", "error.userset_contains_no_items", new String[0], HttpStatus.PRECONDITION_FAILED, null);
            }
            storedUserSet.setItems(updateUserSet.getItems());
        }
    }

    @PutMapping(value={"/set/{identifier}/{datasetId}/{localId}"}, produces={"application/ld+json;charset=utf-8", "application/json;charset=utf-8"})
    @ApiOperation(notes="Please create your insert item request using selected parameters.", value="Insert item to an existing user set", nickname="insert item", response=Void.class)
    public ResponseEntity<String> insertItemIntoUserSet(@PathVariable(value="identifier") String identifier, @PathVariable(value="datasetId") String datasetId, @PathVariable(value="localId") String localId, @RequestParam(value="position", required=false) String position, @RequestParam(value="profile", required=false, defaultValue="minimal") String profile, HttpServletRequest request) throws HttpException {
        Authentication authentication = this.verifyWriteAccess("update", request);
        return this.insertItemIntoUserSet(request, authentication, identifier, datasetId, localId, position, profile);
    }

    protected ResponseEntity<String> insertItemIntoUserSet(HttpServletRequest request, Authentication authentication, String identifier, String datasetId, String localId, String position, String profileStr) throws HttpException {
        try {
            LdProfiles profile = this.getProfile(profileStr, request);
            UserSet existingUserSet = this.getUserSetService().getUserSetById(identifier);
            if (existingUserSet.isOpenSet()) {
                throw new RequestValidationException("error.userset_operation_not_allowed", new String[]{"'Insert item to existing user set'", "open"});
            }
            this.getUserSetService().verifyOwnerOrAdmin(existingUserSet, authentication);
            String eTagOrigin = this.generateETag(existingUserSet.getModified(), "jsonld", this.getApiVersion());
            this.checkIfMatchHeader(eTagOrigin, request);
            UserSet updatedUserSet = this.getUserSetService().insertItem(datasetId, localId, position, existingUserSet);
            String serializedUserSetJsonLdStr = this.serializeUserSet(profile, updatedUserSet);
            String etag = this.generateETag(updatedUserSet.getModified(), "jsonld", this.getApiVersion());
            LinkedMultiValueMap headers = new LinkedMultiValueMap();
            headers.add((Object)"Allow", (Object)"POST,PUT,GET,HEAD,DELETE");
            headers.add((Object)"Vary", (Object)"Prefer");
            headers.add((Object)"Preference-Applied", (Object)profile.getPreferHeaderValue());
            headers.add((Object)"ETag", (Object)etag);
            return new ResponseEntity((Object)serializedUserSetJsonLdStr, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (UserSetValidationException e) {
            throw new RequestValidationException("error.userset_validation", new String[]{e.getMessage()}, e);
        }
        catch (HttpException e) {
            throw e;
        }
        catch (IOException | RuntimeException e) {
            throw new InternalServerException((Throwable)e);
        }
    }

    @RequestMapping(value={"/set/{identifier}/{datasetId}/{localId}"}, method={RequestMethod.GET}, produces={"application/ld+json;charset=utf-8", "application/json;charset=utf-8"})
    @ApiOperation(notes="Check if item is already in a user set", value="Check if item is member of the Set", nickname="check item", response=Void.class)
    public ResponseEntity<String> isItemInUserSet(@RequestParam(value="wskey", required=false) String wskey, @PathVariable(value="identifier") String identifier, @PathVariable(value="datasetId") String datasetId, @PathVariable(value="localId") String localId, HttpServletRequest request) throws HttpException {
        Authentication authentication = this.verifyReadAccess(request);
        return this.isItemInUserSet(wskey, identifier, datasetId, localId, authentication);
    }

    protected ResponseEntity<String> isItemInUserSet(String wsKey, String identifier, String datasetId, String localId, Authentication authentication) throws HttpException {
        try {
            UserSet existingUserSet = this.getUserSetService().getUserSetById(identifier);
            if (existingUserSet.isPrivate()) {
                this.getUserSetService().verifyOwnerOrAdmin(existingUserSet, authentication);
            }
            HttpStatus httpStatus = null;
            String newItem = UserSetUtils.buildItemUrl((String)"http://data.europeana.eu/item/", (String)datasetId, (String)localId);
            httpStatus = existingUserSet.getItems().contains(newItem) ? HttpStatus.NO_CONTENT : HttpStatus.NOT_FOUND;
            LinkedMultiValueMap headers = new LinkedMultiValueMap(5);
            headers.add((Object)"Allow", (Object)"POST,PUT,GET,HEAD,DELETE");
            return new ResponseEntity((Object)"", (MultiValueMap)headers, httpStatus);
        }
        catch (UserSetInstantiationException | UserSetValidationException e) {
            throw new RequestBodyValidationException("error.userset_cant_parse_body", new String[]{e.getMessage()}, e);
        }
        catch (HttpException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new InternalServerException((Throwable)e);
        }
    }

    @DeleteMapping(value={"/set/{identifier}/{datasetId}/{localId}"}, produces={"application/ld+json;charset=utf-8", "application/json;charset=utf-8"})
    @ApiOperation(notes="Delete a item from the set ", value="Delete a item from the set", nickname="delete item", response=Void.class)
    public ResponseEntity<String> deleteItemFromUserSet(@PathVariable(value="identifier") String identifier, @PathVariable(value="datasetId") String datasetId, @PathVariable(value="localId") String localId, @RequestParam(value="profile", required=false, defaultValue="minimal") String profile, HttpServletRequest request) throws HttpException {
        Authentication authentication = this.verifyWriteAccess("delete", request);
        return this.deleteItemFromUserSet(request, authentication, identifier, datasetId, localId, profile);
    }

    protected ResponseEntity<String> deleteItemFromUserSet(HttpServletRequest request, Authentication authentication, String identifier, String datasetId, String localId, String profileStr) throws HttpException {
        try {
            boolean hasItem;
            LdProfiles profile = this.getProfile(profileStr, request);
            UserSet existingUserSet = this.getUserSetService().getUserSetById(identifier);
            this.getUserSetService().verifyOwnerOrAdmin(existingUserSet, authentication);
            String newItem = UserSetUtils.buildItemUrl((String)"http://data.europeana.eu/item/", (String)datasetId, (String)localId);
            boolean bl = hasItem = existingUserSet.getItems() != null && existingUserSet.getItems().contains(newItem);
            if (!hasItem) {
                throw new UserSetNotFoundException("error.userset_item_not_found", "error.userset_item_not_found", new String[]{datasetId + "/" + localId, identifier});
            }
            existingUserSet.getItems().remove(newItem);
            UserSet existingUserSetPaginated = this.getUserSetService().updatePagination(existingUserSet);
            UserSet updatedUserSet = this.getUserSetService().updateUserSetInDb(existingUserSetPaginated, null);
            String serializedUserSetJsonLdStr = this.serializeUserSet(profile, updatedUserSet);
            String etag = this.generateETag(updatedUserSet.getModified(), "jsonld", this.getApiVersion());
            LinkedMultiValueMap headers = new LinkedMultiValueMap(5);
            headers.add((Object)"Allow", (Object)"POST,PUT,GET,HEAD,DELETE");
            headers.add((Object)"Preference-Applied", (Object)profile.getPreferHeaderValue());
            headers.add((Object)"ETag", (Object)etag);
            return new ResponseEntity((Object)serializedUserSetJsonLdStr, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (UserSetInstantiationException | UserSetValidationException e) {
            throw new RequestBodyValidationException("error.userset_cant_parse_body", new String[]{e.getMessage()}, e);
        }
        catch (HttpException e) {
            throw e;
        }
        catch (IOException | RuntimeException e) {
            throw new InternalServerException((Throwable)e);
        }
    }

    @DeleteMapping(value={"/set/{identifier}"})
    @ApiOperation(value="Delete an existing user set", nickname="delete", response=Void.class)
    public ResponseEntity<String> deleteUserSet(@PathVariable(value="identifier") String identifier, HttpServletRequest request) throws HttpException {
        Authentication authentication = this.verifyWriteAccess("delete", request);
        return this.deleteUserSet(request, identifier, authentication);
    }

    protected ResponseEntity<String> deleteUserSet(HttpServletRequest request, String identifier, Authentication authentication) throws HttpException {
        try {
            UserSet existingUserSet = this.getUserSetService().getUserSetById(identifier);
            this.getUserSetService().verifyOwnerOrAdmin(existingUserSet, authentication);
            String eTagOrigin = this.generateETag(existingUserSet.getModified(), "jsonld", this.getApiVersion());
            this.checkIfMatchHeader(eTagOrigin, request);
            HttpStatus httpStatus = null;
            httpStatus = HttpStatus.NO_CONTENT;
            this.getUserSetService().deleteUserSet(existingUserSet.getIdentifier());
            LinkedMultiValueMap headers = new LinkedMultiValueMap(5);
            headers.add((Object)"Link", (Object)"<http://www.w3.org/ns/ldp#BasicContainer>; rel=\"type\"");
            headers.add((Object)"Link", (Object)"<http://www.w3.org/ns/ldp#Resource>; rel=\"type\"");
            headers.add((Object)"Allow", (Object)"GET,POST,PUT,DELETE");
            return new ResponseEntity((Object)identifier, (MultiValueMap)headers, httpStatus);
        }
        catch (HttpException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new InternalServerException((Throwable)e);
        }
    }

    @DeleteMapping(value={"/set/"})
    @ApiOperation(value="Delete sets associated with user", nickname="delete user's sets", response=Void.class)
    public ResponseEntity<String> deleteUserAssociatedSet(HttpServletRequest request) throws HttpException {
        Authentication authentication = this.verifyWriteAccess("delete", request);
        return this.deleteUserAssociatedSets(authentication);
    }

    protected ResponseEntity<String> deleteUserAssociatedSets(Authentication authentication) throws HttpException {
        try {
            String creatorId = this.getUserSetService().getUserId(authentication);
            List<PersistentUserSet> userSets = this.getUserSetService().getUserSetByCreatorId(creatorId);
            HttpStatus httpStatus = null;
            httpStatus = HttpStatus.NO_CONTENT;
            this.getUserSetService().deleteUserSets(creatorId, userSets);
            LinkedMultiValueMap headers = new LinkedMultiValueMap(5);
            headers.add((Object)"Allow", (Object)"POST,GET,DELETE");
            headers.add((Object)"Cache-Control", (Object)"no-cache, no-store, must-revalidate");
            return new ResponseEntity((MultiValueMap)headers, httpStatus);
        }
        catch (HttpException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new InternalServerException((Throwable)e);
        }
    }
}

