/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.set.web.service.controller.jsonld;

import eu.europeana.api.common.config.swagger.SwaggerSelect;
import eu.europeana.api.commons.definitions.search.ResultSet;
import eu.europeana.api.commons.web.exception.HttpException;
import eu.europeana.api.commons.web.exception.InternalServerException;
import eu.europeana.set.definitions.model.UserSet;
import eu.europeana.set.definitions.model.search.UserSetQuery;
import eu.europeana.set.definitions.model.vocabulary.LdProfiles;
import eu.europeana.set.web.search.BaseUserSetResultPage;
import eu.europeana.set.web.search.UserSetLdSerializer;
import eu.europeana.set.web.search.UserSetQueryBuilder;
import eu.europeana.set.web.service.controller.BaseRest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Controller;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@SwaggerSelect
@Api(tags={"User Set Discovery API"})
public class SearchUserSetRest
extends BaseRest {
    UserSetQueryBuilder queryBuilder;

    public synchronized UserSetQueryBuilder getQueryBuilder() {
        if (this.queryBuilder == null) {
            this.queryBuilder = new UserSetQueryBuilder();
        }
        return this.queryBuilder;
    }

    @GetMapping(value={"/set/search", "/set/search.json", "/set/search.jsonld"}, produces={"application/ld+json;charset=utf-8", "application/json;charset=utf-8"})
    @ApiOperation(notes="Searching user sets. The criteria for filtering results is provided in form of <field>:<value> pairs, using the query and qf request parameters. Currently supported fields are: type, visibility, creator, item.", value="Search user sets", nickname="searchUserSet", response=Void.class)
    public ResponseEntity<String> searchUserSet(@RequestParam(value="wskey", required=false) String wskey, @RequestParam(value="query", required=true) String query, @RequestParam(value="qf", required=false) String[] qf, @RequestParam(value="sort", required=false) String sort, @RequestParam(value="page", required=false, defaultValue="0") int page, @RequestParam(value="pageSize", required=false, defaultValue="10") int pageSize, @RequestParam(value="profile", required=false, defaultValue="minimal") String profileStr, HttpServletRequest request) throws HttpException {
        try {
            Authentication authentication = this.verifyReadAccess(request);
            LdProfiles profile = this.getProfile(profileStr, request);
            UserSetQuery searchQuery = this.getQueryBuilder().buildUserSetQuery(query, qf, sort, page, pageSize);
            ResultSet<? extends UserSet> results = this.getUserSetService().search(searchQuery, profile, authentication);
            StringBuilder requestURL = new StringBuilder(request.getRequestURL().toString());
            BaseUserSetResultPage<?> resultsPage = this.getUserSetService().buildResultsPage(searchQuery, results, requestURL, request.getQueryString(), profile, authentication);
            String jsonLd = this.serializeResultsPage(resultsPage);
            LinkedMultiValueMap headers = new LinkedMultiValueMap(5);
            headers.add((Object)"Vary", (Object)"Accept");
            headers.add((Object)"Vary", (Object)"Prefer");
            headers.add((Object)"Allow", (Object)"GET");
            return new ResponseEntity((Object)jsonLd, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (HttpException e) {
            throw e;
        }
        catch (IOException | RuntimeException e) {
            throw new InternalServerException((Throwable)e);
        }
    }

    private String serializeResultsPage(BaseUserSetResultPage resultsPage) throws IOException {
        UserSetLdSerializer serializer = new UserSetLdSerializer();
        return serializer.serialize(resultsPage);
    }
}

