/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.set.web.service.controller;

import eu.europeana.api.commons.web.controller.BaseRestController;
import eu.europeana.api.commons.web.exception.HttpException;
import eu.europeana.api.commons.web.exception.ParamValidationException;
import eu.europeana.set.definitions.config.UserSetConfiguration;
import eu.europeana.set.definitions.exception.UserSetProfileValidationException;
import eu.europeana.set.definitions.model.UserSet;
import eu.europeana.set.definitions.model.vocabulary.LdProfiles;
import eu.europeana.set.web.search.UserSetLdSerializer;
import eu.europeana.set.web.service.UserSetService;
import eu.europeana.set.web.service.authorization.UserSetAuthorizationService;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;

public class BaseRest
extends BaseRestController {
    @Resource
    UserSetConfiguration configuration;
    @Resource
    private UserSetService userSetService;
    @Resource
    UserSetAuthorizationService authorizationService;
    Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());

    public Logger getLogger() {
        return this.logger;
    }

    protected UserSetConfiguration getConfiguration() {
        return this.configuration;
    }

    protected UserSetService getUserSetService() {
        return this.userSetService;
    }

    public void setUserSetService(UserSetService userSetService) {
        this.userSetService = userSetService;
    }

    public void setConfiguration(UserSetConfiguration configuration) {
        this.configuration = configuration;
    }

    public UserSetAuthorizationService getAuthorizationService() {
        return this.authorizationService;
    }

    public void setAuthorizationService(UserSetAuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    public String toResourceId(String collection, String object) {
        return "/" + collection + "/" + object;
    }

    public LdProfiles getProfile(String paramProfile, HttpServletRequest request) throws HttpException {
        LdProfiles profile = null;
        profile = this.getHeaderProfile(request);
        if (profile == null) {
            try {
                profile = LdProfiles.getByName((String)paramProfile);
            }
            catch (UserSetProfileValidationException e) {
                throw new ParamValidationException("error.invalid_param_value", "error.invalid_param_value", new String[]{"profile", paramProfile}, (Throwable)e);
            }
        }
        return profile;
    }

    public LdProfiles getHeaderProfile(HttpServletRequest request) throws HttpException {
        LdProfiles profile = null;
        String preferHeader = request.getHeader("Prefer");
        if (preferHeader != null) {
            String ldPreferHeaderStr = null;
            String include = "include";
            if (StringUtils.isNotEmpty((CharSequence)preferHeader)) {
                this.getLogger().debug("'Prefer' header value: {} ", (Object)preferHeader);
                try {
                    Map<String, String> preferHeaderMap = this.parsePreferHeader(preferHeader);
                    ldPreferHeaderStr = preferHeaderMap.get(include).replace("\"", "");
                    profile = LdProfiles.getByHeaderValue((String)ldPreferHeaderStr.trim());
                }
                catch (UserSetProfileValidationException e) {
                    throw new HttpException("error.userset_invalid_header_value", "error.userset_invalid_header_value", new String[]{"Prefer", preferHeader}, HttpStatus.BAD_REQUEST, (Throwable)e);
                }
                catch (RuntimeException e) {
                    throw new HttpException("error.userset_invalid_header_format", "error.userset_invalid_header_format", new String[]{"Prefer", preferHeader}, HttpStatus.BAD_REQUEST, (Throwable)e);
                }
            }
            this.getLogger().debug("Profile identified by prefer header: {} ", profile);
        }
        return profile;
    }

    protected String serializeUserSet(LdProfiles profile, UserSet storedUserSet) throws IOException {
        UserSet set = this.getUserSetService().applyProfile(storedUserSet, profile);
        UserSetLdSerializer serializer = new UserSetLdSerializer();
        return serializer.serialize(set);
    }

    public Map<String, String> parsePreferHeader(String preferHeader) {
        String[] headerParts = null;
        String[] contentParts = null;
        int keyPos = 0;
        int valuePos = 1;
        HashMap<String, String> resMap = new HashMap<String, String>(3);
        for (String headerPart : headerParts = preferHeader.split(";")) {
            contentParts = headerPart.split("=");
            if (contentParts.length != 2) continue;
            resMap.put(contentParts[keyPos], contentParts[valuePos]);
        }
        return resMap;
    }

    public String getApiVersion() {
        return this.getConfiguration().getApiVersion();
    }
}

