/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.set.web.service.controller;

import eu.europeana.set.web.model.UserSetOperationResponse;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ApiResponseBuilder {
    Logger logger = LogManager.getLogger(this.getClass());

    public Logger getLogger() {
        return this.logger;
    }

    public UserSetOperationResponse buildErrorResponse(String errorMessage, String action, String apiKey) {
        UserSetOperationResponse response = new UserSetOperationResponse(apiKey, action);
        response.success = false;
        response.error = errorMessage;
        return response;
    }

    public UserSetOperationResponse getValidationReport(String apiKey, String action, String errorMessage, Throwable th, boolean includeErrorStack) {
        UserSetOperationResponse response = new UserSetOperationResponse(apiKey, action);
        String blank = " ";
        StringBuilder messageBuilder = new StringBuilder();
        if (errorMessage != null) {
            messageBuilder.append(" ").append(errorMessage).append(". ");
        }
        if (th != null) {
            if (errorMessage != null) {
                messageBuilder.append("Caused by: ");
            }
            messageBuilder.append(th.getMessage());
        }
        if (th != null && th.getCause() != null && th != th.getCause()) {
            messageBuilder.append(" ").append(th.getCause().getMessage());
        }
        response = this.buildErrorResponse(messageBuilder.toString(), response.action, response.apikey);
        if (includeErrorStack && th != null) {
            response.setStackTrace(this.getStackTraceAsString(th));
        }
        return response;
    }

    String getStackTraceAsString(Throwable th) {
        StringWriter out = new StringWriter();
        th.printStackTrace(new PrintWriter(out));
        return out.toString();
    }

    public UserSetOperationResponse buildResponse(String message, String action, String apiKey) {
        UserSetOperationResponse response = new UserSetOperationResponse(apiKey, action);
        response.success = true;
        response.setStatus(message);
        return response;
    }
}

