/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.set.web.service;

import eu.europeana.api.commons.definitions.search.ResultSet;
import eu.europeana.api.commons.web.exception.ApplicationAuthenticationException;
import eu.europeana.api.commons.web.exception.HttpException;
import eu.europeana.api.commons.web.exception.ParamValidationException;
import eu.europeana.set.definitions.model.UserSet;
import eu.europeana.set.definitions.model.search.UserSetQuery;
import eu.europeana.set.definitions.model.vocabulary.LdProfiles;
import eu.europeana.set.mongo.model.internal.PersistentUserSet;
import eu.europeana.set.web.exception.request.RequestBodyValidationException;
import eu.europeana.set.web.exception.response.UserSetNotFoundException;
import eu.europeana.set.web.search.BaseUserSetResultPage;
import java.io.IOException;
import java.util.List;
import org.codehaus.jettison.json.JSONException;
import org.springframework.security.core.Authentication;

public interface UserSetService {
    public UserSet storeUserSet(UserSet var1, Authentication var2) throws HttpException;

    public UserSet fetchItems(UserSet var1, String var2, String var3, int var4, int var5, LdProfiles var6) throws HttpException, IOException, JSONException;

    public UserSet updateUserSetInDb(UserSet var1, List<String> var2);

    public UserSet updateUserSet(PersistentUserSet var1, UserSet var2);

    public void updateUserSetPagination(UserSet var1);

    public UserSet getUserSetById(String var1) throws UserSetNotFoundException;

    public List<PersistentUserSet> getUserSetByCreatorId(String var1) throws UserSetNotFoundException;

    public UserSet fillPagination(UserSet var1);

    public UserSet updatePagination(UserSet var1);

    public UserSet parseUserSetLd(String var1) throws HttpException;

    public void validateWebUserSet(UserSet var1) throws RequestBodyValidationException, ParamValidationException;

    public void deleteUserSet(String var1) throws UserSetNotFoundException;

    public void deleteUserSets(String var1, List<PersistentUserSet> var2);

    public void removeItemDuplicates(UserSet var1);

    public int validatePosition(String var1, List<String> var2) throws ApplicationAuthenticationException;

    public UserSet insertItem(String var1, String var2, String var3, UserSet var4) throws ApplicationAuthenticationException;

    public UserSet updateItemList(UserSet var1);

    public void replaceItem(UserSet var1, int var2, String var3);

    public void addNewItemToList(UserSet var1, int var2, String var3);

    public ResultSet<? extends UserSet> search(UserSetQuery var1, LdProfiles var2, Authentication var3);

    public BaseUserSetResultPage<?> buildResultsPage(UserSetQuery var1, ResultSet<? extends UserSet> var2, StringBuilder var3, String var4, LdProfiles var5, Authentication var6) throws HttpException;

    public UserSet verifyOwnerOrAdmin(UserSet var1, Authentication var2) throws HttpException;

    public String getUserId(Authentication var1);

    public UserSet applyProfile(UserSet var1, LdProfiles var2);
}

