/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.set.web.search;

import eu.europeana.api.commons.search.util.QueryBuilder;
import eu.europeana.api.commons.web.exception.ParamValidationException;
import eu.europeana.set.definitions.model.search.UserSetQuery;
import eu.europeana.set.definitions.model.search.UserSetQueryImpl;
import eu.europeana.set.definitions.model.utils.UserSetUtils;
import eu.europeana.set.definitions.model.vocabulary.UserSetTypes;
import eu.europeana.set.definitions.model.vocabulary.VisibilityTypes;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class UserSetQueryBuilder
extends QueryBuilder {
    String[] fields = new String[]{"creator", "visibility", "type", "item", "set_id"};
    Set<String> suportedFields = Set.of(this.fields);

    private UserSetQuery buildSearchQuery(Map<String, String> searchCriteria, String sort, int page, int pageSize) throws ParamValidationException {
        UserSetQueryImpl searchQuery = new UserSetQueryImpl();
        searchQuery.setQuery(searchCriteria.toString());
        if (searchCriteria.containsKey("visibility")) {
            String visibility = searchCriteria.get("visibility");
            if (visibility != null && !VisibilityTypes.isValid((String)visibility)) {
                throw new ParamValidationException("error.invalid_param_value", "error.invalid_param_value", new String[]{"invalid value for search field visibility", visibility});
            }
            searchQuery.setVisibility(visibility);
        }
        if (searchCriteria.containsKey("type")) {
            String type = searchCriteria.get("type");
            if (type != null && !UserSetTypes.isValid((String)type)) {
                throw new ParamValidationException("error.invalid_param_value", "error.invalid_param_value", new String[]{"invalid value for search field type", type});
            }
            searchQuery.setType(type);
        }
        if (searchCriteria.containsKey("creator")) {
            String creatorId = searchCriteria.get("creator");
            if (creatorId.startsWith("http")) {
                searchQuery.setCreator(creatorId);
            } else {
                searchQuery.setCreator(UserSetUtils.buildCreatorUri((String)creatorId));
            }
        }
        if (searchCriteria.containsKey("item")) {
            String item = searchCriteria.get("item");
            if (item.startsWith("http")) {
                searchQuery.setItem(item);
            } else {
                searchQuery.setItem(UserSetUtils.buildItemUrl((String)item));
            }
        }
        if (searchCriteria.containsKey("set_id")) {
            String setId = searchCriteria.get("set_id");
            if (!UserSetUtils.isInteger((String)setId)) {
                throw new ParamValidationException("error.invalid_param_value", "error.invalid_param_value", new String[]{"set_id", setId});
            }
            searchQuery.setSetId(setId);
        }
        searchQuery.setSortCriteria(this.toArray(sort));
        searchQuery.setPageSize(pageSize);
        searchQuery.setPageNr(page);
        return searchQuery;
    }

    public UserSetQuery buildUserSetQuery(String query, String[] qf, String sort, int page, int pageSize) throws ParamValidationException {
        HashMap<String, String> criteria = new HashMap<String, String>();
        this.parseSearchCriteria(criteria, query, qf);
        return this.buildSearchQuery(criteria, sort, page, pageSize);
    }

    private void parseSearchCriteria(Map<String, String> criteria, String query, String[] qf) throws ParamValidationException {
        boolean searchAllQuery;
        boolean bl = searchAllQuery = "*".equals(query) || "*:*".equals(query);
        if (!searchAllQuery) {
            this.parseCriterion(criteria, query);
        }
        if (qf != null) {
            for (String criterion : qf) {
                this.parseCriterion(criteria, criterion);
            }
        }
    }

    private void parseCriterion(Map<String, String> criteria, String criterion) throws ParamValidationException {
        String toParse = criterion;
        String separator = ":";
        String space = " ";
        while (toParse.contains(separator)) {
            String field = StringUtils.substringBefore((String)toParse, (String)separator);
            toParse = StringUtils.substringAfter((String)toParse, (String)separator);
            if (!this.suportedFields.contains(field)) {
                throw new ParamValidationException("error.invalid_param_value", "error.invalid_param_value", new String[]{"invalid field name in search query", field});
            }
            String value = StringUtils.substringBefore((String)toParse, (String)space);
            toParse = StringUtils.substringAfter((String)toParse, (String)space);
            if (value.contains(separator) || StringUtils.isBlank((CharSequence)value)) {
                throw new ParamValidationException("error.invalid_param_value", "error.invalid_param_value", new String[]{"invalid formatting of search query for field " + field, value});
            }
            criteria.put(field, value);
        }
    }
}

