/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.set.web.search;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.europeana.set.definitions.model.UserSet;
import eu.europeana.set.definitions.model.utils.UserSetUtils;
import eu.europeana.set.web.search.BaseUserSetResultPage;
import ioinformarics.oss.jackson.module.jsonld.JsonldModule;
import ioinformarics.oss.jackson.module.jsonld.JsonldResource;
import ioinformarics.oss.jackson.module.jsonld.JsonldResourceBuilder;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class UserSetLdSerializer {
    UserSetUtils userSetUtils = new UserSetUtils();
    ObjectMapper mapper = new ObjectMapper();

    public UserSetUtils getUserSetUtils() {
        return this.userSetUtils;
    }

    public UserSetLdSerializer() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ENGLISH);
        this.mapper.setDateFormat((DateFormat)df);
    }

    public String serialize(UserSet userSet) throws IOException {
        this.mapper.registerModule((Module)new JsonldModule());
        JsonldResourceBuilder jsonResourceBuilder = JsonldResource.Builder.create();
        jsonResourceBuilder.context("http://www.europeana.eu/schemas/context/collection.jsonld");
        return this.mapper.writer().writeValueAsString((Object)jsonResourceBuilder.build((Object)userSet));
    }

    public String serialize(BaseUserSetResultPage<?> resultsPage) throws IOException {
        this.mapper.registerModule((Module)new JsonldModule());
        JsonldResourceBuilder jsonResourceBuilder = JsonldResource.Builder.create();
        jsonResourceBuilder.context("http://www.europeana.eu/schemas/context/collection.jsonld");
        return this.mapper.writer().writeValueAsString((Object)jsonResourceBuilder.build(resultsPage));
    }
}

