/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.set.web.service.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.europeana.api.commons.definitions.search.ResultSet;
import eu.europeana.api.commons.definitions.search.result.ResultsPage;
import eu.europeana.api.commons.definitions.utils.LoggingUtils;
import eu.europeana.api.commons.nosql.entity.NoSqlEntity;
import eu.europeana.api.commons.web.exception.ApplicationAuthenticationException;
import eu.europeana.api.commons.web.exception.HttpException;
import eu.europeana.api.commons.web.exception.InternalServerException;
import eu.europeana.api.commons.web.exception.ParamValidationException;
import eu.europeana.set.definitions.exception.UserSetAttributeInstantiationException;
import eu.europeana.set.definitions.exception.UserSetInstantiationException;
import eu.europeana.set.definitions.model.BaseWebResource;
import eu.europeana.set.definitions.model.UserSet;
import eu.europeana.set.definitions.model.agent.Agent;
import eu.europeana.set.definitions.model.search.UserSetFacetQuery;
import eu.europeana.set.definitions.model.search.UserSetQuery;
import eu.europeana.set.definitions.model.utils.UserSetUtils;
import eu.europeana.set.definitions.model.vocabulary.SetPageProfile;
import eu.europeana.set.definitions.model.vocabulary.SetResourceProfile;
import eu.europeana.set.definitions.model.vocabulary.UserSetProfile;
import eu.europeana.set.mongo.model.internal.PersistentUserSet;
import eu.europeana.set.search.SearchApiRequest;
import eu.europeana.set.search.exception.SearchApiClientException;
import eu.europeana.set.search.service.SearchApiResponse;
import eu.europeana.set.web.exception.request.ItemValidationException;
import eu.europeana.set.web.exception.request.RequestBodyValidationException;
import eu.europeana.set.web.exception.request.RequestValidationException;
import eu.europeana.set.web.exception.response.UserSetNotFoundException;
import eu.europeana.set.web.model.WebResource;
import eu.europeana.set.web.model.WebUserSetImpl;
import eu.europeana.set.web.model.search.BaseUserSetResultPage;
import eu.europeana.set.web.model.search.CollectionOverview;
import eu.europeana.set.web.model.search.CollectionPage;
import eu.europeana.set.web.model.search.FacetFieldViewImpl;
import eu.europeana.set.web.model.search.ItemDescriptionsCollectionPage;
import eu.europeana.set.web.model.search.ItemDescriptionsResultPage;
import eu.europeana.set.web.model.search.ItemIdsCollectionPage;
import eu.europeana.set.web.model.search.ItemIdsResultPage;
import eu.europeana.set.web.model.search.SearchApiUtils;
import eu.europeana.set.web.model.search.UserSetIdsResultPage;
import eu.europeana.set.web.model.search.UserSetResultPage;
import eu.europeana.set.web.service.controller.jsonld.WebUserSetRequestUtils;
import eu.europeana.set.web.service.impl.BaseUserSetServiceImpl;
import eu.europeana.set.web.service.impl.UserSetServiceImpl;
import ioinformarics.oss.jackson.module.jsonld.JsonldModule;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.lang.NonNull;
import org.springframework.security.core.Authentication;

public class UserSetServiceImpl
extends BaseUserSetServiceImpl {
    public UserSet getUserSetById(String userSetId) throws UserSetNotFoundException {
        PersistentUserSet userSet = this.getMongoPersistence().getByIdentifier(userSetId);
        if (userSet == null) {
            throw new UserSetNotFoundException("error.userset_not_found", "error.userset_not_found", new String[]{userSetId});
        }
        this.getUserSetUtils().updatedTotal((UserSet)userSet);
        return userSet;
    }

    public List<PersistentUserSet> getUserSetByCreatorId(String creatorId) throws UserSetNotFoundException {
        ArrayList<PersistentUserSet> result = new ArrayList<PersistentUserSet>();
        Iterator iter = this.getMongoPersistence().getByCreator(creatorId).iterator();
        iter.forEachRemaining(result::add);
        return result;
    }

    public UserSet getBookmarkFolder(Agent creator) {
        return this.getBookmarkFolder(creator.getHttpUrl());
    }

    public UserSet getBookmarkFolder(String creatorId) {
        PersistentUserSet set = this.getMongoPersistence().getBookmarkFolder(creatorId);
        if (set != null) {
            set.setBaseUrl(this.getConfiguration().getSetDataEndpoint());
        }
        return set;
    }

    public UserSet parseUserSetLd(String userSetJsonLdStr) throws RequestBodyValidationException, UserSetInstantiationException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JsonldModule());
        mapper.configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, true);
        JsonFactory jsonFactory = mapper.getFactory();
        try {
            JsonParser parser = jsonFactory.createParser(userSetJsonLdStr);
            UserSet userSet = (UserSet)mapper.readValue(parser, WebUserSetImpl.class);
            if (userSet.getModified() == null) {
                Date now = new Date();
                userSet.setModified(now);
            }
            this.removeItemDuplicates(userSet);
            return userSet;
        }
        catch (UserSetAttributeInstantiationException | IOException e) {
            throw new RequestBodyValidationException("error.userset_cant_parse_body", new String[]{e.getMessage()}, e);
        }
    }

    public void removeItemDuplicates(UserSet userSet) {
        if (userSet.getItems() != null && !userSet.getItems().isEmpty()) {
            List distinctItems = userSet.getItems().stream().distinct().collect(Collectors.toList());
            userSet.setItems(distinctItems);
        }
    }

    public void deleteUserSet(String userSetId) throws UserSetNotFoundException {
        this.getMongoPersistence().remove(userSetId);
    }

    public void deleteUserSets(String creatorId, List<PersistentUserSet> userSets) {
        ArrayList<String> setsToBeDeleted = new ArrayList<String>();
        if (!userSets.isEmpty()) {
            for (PersistentUserSet userSet : userSets) {
                setsToBeDeleted.add(userSet.getIdentifier());
            }
        }
        this.getMongoPersistance().removeAll(userSets);
        this.getLogger().info("User sets deleted for user {}. Sets deleted are : {} ", (Object)LoggingUtils.sanitizeUserInput((String)creatorId), setsToBeDeleted);
    }

    int validatePosition(String position, List<String> items, int pinnedItems) {
        int positionInt = -1;
        if (StringUtils.isNotEmpty((CharSequence)position)) {
            try {
                positionInt = Integer.parseInt(position);
                if (positionInt < pinnedItems) {
                    positionInt = pinnedItems + positionInt;
                }
                if (positionInt > items.size()) {
                    positionInt = -1;
                }
            }
            catch (RuntimeException e) {
                this.getLogger().trace("Position validation warning: {} ", (Object)position, (Object)e);
            }
        }
        return positionInt;
    }

    public UserSet deleteItem(String item, UserSet existingUserSet) {
        int currentPosition;
        if (existingUserSet.getItems() == null) {
            return existingUserSet;
        }
        if (existingUserSet.isEntityBestItemsSet() && (currentPosition = existingUserSet.getItems().indexOf(item)) < existingUserSet.getPinned()) {
            existingUserSet.setPinned(existingUserSet.getPinned() - 1);
        }
        existingUserSet.getItems().remove(item);
        return (UserSet)this.getMongoPersistence().store((NoSqlEntity)((PersistentUserSet)existingUserSet));
    }

    private void updateIsShownBy(UserSet userSet, String firstItemOld) {
        block4: {
            String firstItemNew = null;
            if (userSet.getItems() != null && !userSet.getItems().isEmpty()) {
                firstItemNew = (String)userSet.getItems().get(0);
            }
            if (!StringUtils.equals((CharSequence)firstItemOld, firstItemNew)) {
                try {
                    WebResource isShownBy = this.generateDepiction(userSet);
                    userSet.setIsShownBy((BaseWebResource)isShownBy);
                }
                catch (SearchApiClientException e) {
                    if (!this.getLogger().isInfoEnabled()) break block4;
                    this.getLogger().info("Cannot generate depiciton for set: {}. Exception: {}.", (Object)userSet.getIdentifier(), (Object)e.getMessage());
                }
            }
        }
    }

    public UserSet deleteMultipleItems(List<String> items, UserSet existingUserSet) throws ItemValidationException {
        if (existingUserSet.getItems() == null || existingUserSet.getItems().isEmpty()) {
            return existingUserSet;
        }
        String firstItemOld = (String)existingUserSet.getItems().get(0);
        List fullUriItems = this.validateItemsStrings(items);
        boolean itemsRemoved = false;
        itemsRemoved = existingUserSet.isEntityBestItemsSet() ? this.removeItemsForEntityBestItemsSet(existingUserSet, fullUriItems) : existingUserSet.getItems().removeAll(fullUriItems);
        UserSet updatedUserSet = existingUserSet;
        if (itemsRemoved) {
            this.updateIsShownBy(updatedUserSet, firstItemOld);
            updatedUserSet = (UserSet)this.getMongoPersistence().store((NoSqlEntity)((PersistentUserSet)existingUserSet));
        }
        return updatedUserSet;
    }

    private boolean removeItemsForEntityBestItemsSet(UserSet existingUserSet, List<String> fullUriItems) {
        boolean itemsRemoved = false;
        for (String item : fullUriItems) {
            int currentPosition = existingUserSet.getItems().indexOf(item);
            if (currentPosition <= -1) continue;
            if (currentPosition < existingUserSet.getPinned()) {
                existingUserSet.descreasePinned(1);
            }
            existingUserSet.getItems().remove(item);
            itemsRemoved = true;
        }
        return itemsRemoved;
    }

    public UserSet insertMultipleItems(List<String> items, String position, int itemsPosition, UserSet existingUserSet) throws ItemValidationException {
        String firstItemOld = null;
        if (existingUserSet.getItems() != null && !existingUserSet.getItems().isEmpty()) {
            firstItemOld = (String)existingUserSet.getItems().get(0);
        }
        List fullUriItems = this.validateItemsStrings(items);
        List duplicatedItems = this.computeDuplicateList(existingUserSet, fullUriItems);
        boolean isPinnRequest = WebUserSetRequestUtils.isPinPosition((String)position);
        if (duplicatedItems != null) {
            this.processDuplicates(existingUserSet, fullUriItems, duplicatedItems, isPinnRequest);
        }
        this.addItems(existingUserSet, fullUriItems, itemsPosition, isPinnRequest);
        if (existingUserSet.isGallery()) {
            this.validateGallerySize(existingUserSet, 0);
        }
        this.updateIsShownBy(existingUserSet, firstItemOld);
        return (UserSet)this.getMongoPersistence().store((NoSqlEntity)((PersistentUserSet)existingUserSet));
    }

    private void processDuplicates(UserSet existingUserSet, List<String> items, List<String> duplicatedItems, boolean isPinnRequest) {
        if (isPinnRequest) {
            int duplicatedPinned = 0;
            if (existingUserSet.getPinned() > 0) {
                List pinnedItems = existingUserSet.getItems().subList(0, existingUserSet.getPinned());
                duplicatedPinned = this.countDupplicatedItems(duplicatedItems, pinnedItems);
            }
            existingUserSet.getItems().removeAll(duplicatedItems);
            existingUserSet.descreasePinned(duplicatedPinned);
        } else {
            if (existingUserSet.getPinned() > 0) {
                List pinedItems = existingUserSet.getItems().subList(0, existingUserSet.getPinned());
                items.removeAll(pinedItems);
                duplicatedItems.removeAll(pinedItems);
            }
            existingUserSet.getItems().removeAll(duplicatedItems);
        }
    }

    private int countDupplicatedItems(List<String> duplicatedItems, List<String> pinnedItems) {
        int counter = 0;
        for (String pinnedItem : pinnedItems) {
            if (!duplicatedItems.contains(pinnedItem)) continue;
            ++counter;
        }
        return counter;
    }

    private void addItems(UserSet existingUserSet, List<String> items, int position, boolean isPinnRequest) {
        if (existingUserSet.getItems() == null) {
            existingUserSet.setItems(new ArrayList());
        }
        if (isPinnRequest) {
            existingUserSet.getItems().addAll(0, items);
            existingUserSet.increasePinned(items.size());
        } else {
            boolean insertAtFixPosition;
            boolean bl = insertAtFixPosition = position > -1 && existingUserSet.getItems() != null && position < existingUserSet.getItems().size();
            if (insertAtFixPosition) {
                existingUserSet.getItems().addAll(position, items);
            } else {
                existingUserSet.getItems().addAll(items);
            }
        }
    }

    private List<String> computeDuplicateList(@NonNull UserSet existingUserSet, @NonNull List<String> newItems) {
        if (existingUserSet.getItems() == null || existingUserSet.getItems().isEmpty()) {
            return null;
        }
        ArrayList<String> res = new ArrayList<String>(newItems);
        res.retainAll(existingUserSet.getItems());
        if (res.isEmpty()) {
            return null;
        }
        return res;
    }

    public UserSet insertItem(String datasetId, String localId, String position, UserSet existingUserSet) throws ApplicationAuthenticationException, ItemValidationException {
        UserSet userSet;
        String itemForPartialValidation = "/" + datasetId + "/" + localId;
        this.validateEuropeanaRecordId(itemForPartialValidation);
        String newItem = UserSetUtils.buildItemUrl((String)this.getConfiguration().getItemDataEndpoint(), (String)datasetId, (String)localId);
        if (existingUserSet.isGallery() && !existingUserSet.hasItem(newItem)) {
            this.validateGallerySize(existingUserSet, 1);
        }
        if (WebUserSetRequestUtils.isPinPosition((String)position) && existingUserSet.isEntityBestItemsSet()) {
            userSet = this.insertItem(existingUserSet, newItem, 0, true);
        } else {
            int positionInt = this.validatePosition(position, existingUserSet.getItems(), existingUserSet.getPinned());
            userSet = this.insertItem(existingUserSet, newItem, positionInt, false);
        }
        this.updatePagination(userSet, this.getConfiguration());
        return userSet;
    }

    private UserSet insertItem(UserSet existingUserSet, String newItem, int positionInt, boolean pinnedItem) {
        boolean insert;
        UserSet extUserSet = null;
        int finalPosition = existingUserSet.getItems() == null ? -1 : positionInt;
        boolean bl = insert = existingUserSet.getItems() == null || !existingUserSet.getItems().contains(newItem);
        if (insert) {
            this.addNewItemToList(existingUserSet, finalPosition, newItem);
            this.updatePinCount(existingUserSet, pinnedItem, -1);
            extUserSet = (UserSet)this.getMongoPersistence().store((NoSqlEntity)((PersistentUserSet)existingUserSet));
        } else {
            int oldPosition = existingUserSet.getItems().indexOf(newItem);
            if (oldPosition == positionInt) {
                extUserSet = existingUserSet;
            } else {
                this.replaceItem(existingUserSet, finalPosition, newItem);
                this.updatePinCount(existingUserSet, pinnedItem, oldPosition);
                extUserSet = (UserSet)this.getMongoPersistence().store((NoSqlEntity)((PersistentUserSet)existingUserSet));
            }
        }
        return extUserSet;
    }

    private void updatePinCount(UserSet existingUserSet, boolean pinnedItem, int oldPosition) {
        boolean previouslyPinned;
        boolean mustHandlePinCount = existingUserSet.isEntityBestItemsSet();
        if (!mustHandlePinCount) {
            return;
        }
        boolean bl = previouslyPinned = oldPosition >= 0 && oldPosition < existingUserSet.getPinned();
        if (previouslyPinned && !pinnedItem) {
            existingUserSet.setPinned(existingUserSet.getPinned() - 1);
        } else if (pinnedItem) {
            existingUserSet.setPinned(existingUserSet.getPinned() + 1);
        }
    }

    void replaceItem(UserSet existingUserSet, int positionInt, String newItem) {
        existingUserSet.getItems().remove(newItem);
        if (positionInt > existingUserSet.getItems().size()) {
            positionInt = existingUserSet.getItems().size();
        }
        this.addNewItemToList(existingUserSet, positionInt, newItem);
    }

    void addNewItemToList(UserSet existingUserSet, int positionInt, String newItem) {
        if (existingUserSet.getItems() == null) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(newItem);
            existingUserSet.setItems(list);
        } else if (positionInt == -1) {
            existingUserSet.getItems().add(newItem);
        } else {
            existingUserSet.getItems().add(positionInt, newItem);
        }
    }

    public UserSet fetchUserSetItems(UserSet userSet, String sort, String sortOrder, int pageNr, int pageSize, SetPageProfile profile) throws HttpException {
        if (!userSet.isOpenSet() && (userSet.getItems() == null || userSet.getItems() != null && userSet.getItems().isEmpty())) {
            return userSet;
        }
        if (!userSet.isOpenSet() && userSet.getItems().size() > 0) {
            this.validateLastPage((long)userSet.getItems().size(), pageSize, pageNr);
        }
        String apiKey = this.getConfiguration().getSearchApiKey();
        String searchApiProfile = null;
        searchApiProfile = this.getConfiguration().getSearchApiProfileForItemDescriptions();
        String url = this.getSearchApiUtils().buildSearchApiUrl(userSet, apiKey, this.getConfiguration().getSearchApiUrl(), searchApiProfile);
        SearchApiRequest searchApiRequest = this.getSearchApiUtils().buildSearchApiPostBody(userSet, this.getConfiguration().getItemDataEndpoint(), sort, sortOrder, pageNr, pageSize, searchApiProfile);
        try {
            String jsonBody = this.serializeSearchApiRequest(searchApiRequest);
            if (userSet.isOpenSet() && SetPageProfile.ITEMS == profile) {
                SearchApiResponse apiResult = this.getSearchApiClient().searchItems(url, jsonBody, apiKey, false);
                this.setItemIds(userSet, apiResult);
            } else if (SetPageProfile.ITEMS_META == profile) {
                SearchApiResponse apiResult = this.getSearchApiClient().searchItems(url, jsonBody, apiKey, true);
                int total = apiResult.getTotal();
                if (!userSet.isOpenSet()) {
                    total = userSet.getItems().size();
                }
                List sortedItemDescriptions = this.sortItemDescriptions(userSet, apiResult.getItems(), pageNr, pageSize);
                this.setItems(userSet, sortedItemDescriptions, total);
            }
            return userSet;
        }
        catch (SearchApiClientException e) {
            if ("An error occured when retrieving items through search API. isDefinedBy might not be a valid API URL.".equals(e.getMessage())) {
                throw new RequestBodyValidationException("error.userset_validation_property_value", new String[]{"isDefinedBy", url}, (Throwable)e);
            }
            throw new InternalServerException((Throwable)e);
        }
        catch (IOException e) {
            throw new RequestBodyValidationException("error.userset_validation_search_request_not_valid", new String[0], (Throwable)e);
        }
    }

    private List<String> sortItemDescriptions(UserSet userSet, List<String> itemDescriptions, int pageNr, int pageSize) {
        if (userSet.getItems() != null) {
            return this.reorderItemDescriptions(userSet.getItems(), itemDescriptions, pageNr, pageSize);
        }
        return itemDescriptions;
    }

    private List<String> reorderItemDescriptions(List<String> itemIds, List<String> itemDescriptions, int pageNr, int pageSize) {
        ArrayList<String> orderedItemDescriptions = new ArrayList<String>(itemDescriptions.size());
        Integer start = (pageNr - 1) * pageSize;
        Integer end = Math.min(start + pageSize, itemIds.size());
        String itemDataEndpoint = this.getConfiguration().getItemDataEndpoint();
        for (int i = start.intValue(); i < end; ++i) {
            String itemUri = itemIds.get(i);
            boolean found = false;
            String localId = UserSetUtils.extractItemIdentifier((String)itemUri, (String)itemDataEndpoint);
            String recordIdJsonString = UserSetUtils.buildRecordIdJsonString((String)localId, (boolean)true, (boolean)true);
            for (String description : itemDescriptions) {
                System.out.println(description);
                if (!description.contains(recordIdJsonString)) continue;
                orderedItemDescriptions.add(description);
                found = true;
                break;
            }
            if (found) continue;
            orderedItemDescriptions.add("{\"id\":\"" + localId + "\"}");
        }
        return orderedItemDescriptions;
    }

    public ResultSet<? extends UserSet> search(UserSetQuery searchQuery, UserSetFacetQuery facetQuery, List<SetPageProfile> profiles, Authentication authentication) {
        searchQuery.setAdmin(this.hasAdminRights(authentication));
        searchQuery.setUser(this.getUserId(authentication));
        ResultSet results = this.getMongoPersistance().find(searchQuery);
        if (profiles.contains(SetPageProfile.FACETS) && facetQuery != null) {
            Map valueCountMap = this.getMongoPersistence().getFacets(facetQuery);
            results.setFacetFields(Arrays.asList(new FacetFieldViewImpl(facetQuery.getOutputField(), valueCountMap)));
        }
        return results;
    }

    public BaseUserSetResultPage<?> buildResultsPage(UserSetQuery searchQuery, ResultSet<? extends UserSet> results, String requestUrl, String reqParams, List<SetPageProfile> profiles, Authentication authentication) throws HttpException {
        BaseUserSetResultPage resPage = null;
        int resultPageSize = results.getResults().size();
        int pageSize = searchQuery.getPageSize();
        int currentPage = searchQuery.getPageNr();
        long totalInCollection = results.getResultSize();
        int lastPage = this.validateLastPage(totalInCollection, pageSize, currentPage);
        SetPageProfile profile = this.getProfileForPagination(profiles);
        String apiEndpointUrl = this.getConfiguration().getSetApiEndpoint() + "search";
        String resultsPageId = this.buildResultsPageUrl(apiEndpointUrl, reqParams, profile.getProfileParamValue());
        resPage = this.createResultPageWithItems(results, resultPageSize, profile, profiles, authentication);
        CollectionOverview ResultList = this.buildCollectionOverview(resultsPageId, resultsPageId, pageSize, totalInCollection, lastPage, "ResultList", null);
        resPage.setPartOf(ResultList);
        this.addPagination((ResultsPage)resPage, resultsPageId, currentPage, pageSize, lastPage, (UserSetProfile)profile);
        return resPage;
    }

    private BaseUserSetResultPage<?> createResultPageWithItems(ResultSet<? extends UserSet> results, int resultPageSize, SetPageProfile serializationProfile, List<SetPageProfile> profiles, Authentication authentication) throws HttpException {
        UserSetResultPage resPage = switch (1.$SwitchMap$eu$europeana$set$definitions$model$vocabulary$SetPageProfile[serializationProfile.ordinal()]) {
            case 1 -> this.setPageItemsAsSetData(results, authentication, serializationProfile);
            case 2 -> this.setPageItemsAsSetIds(results, resultPageSize);
            case 3 -> new UserSetResultPage();
            default -> throw new ParamValidationException("error.invalid_param_value", "error.invalid_param_value", new String[]{"profile", serializationProfile.getProfileParamValue()});
        };
        if (profiles.contains(SetPageProfile.FACETS)) {
            resPage.setFacetFields(results.getFacetFields());
        }
        return resPage;
    }

    UserSetIdsResultPage setPageItemsAsSetIds(ResultSet<? extends UserSet> results, int resultPageSize) {
        UserSetIdsResultPage resPage = new UserSetIdsResultPage();
        ArrayList<String> items = new ArrayList<String>(resultPageSize);
        for (UserSet set : results.getResults()) {
            items.add(UserSetUtils.buildUserSetId((String)this.getConfiguration().getSetDataEndpoint(), (String)set.getIdentifier()));
        }
        resPage.setItems(items);
        resPage.setTotalInPage((long)items.size());
        return resPage;
    }

    UserSetResultPage setPageItemsAsSetData(ResultSet<? extends UserSet> results, Authentication authentication, SetPageProfile profile) throws HttpException {
        UserSetResultPage resPage = new UserSetResultPage();
        ArrayList<Object> items = new ArrayList<Object>(results.getResults().size());
        for (UserSet userSet : results.getResults()) {
            if (!userSet.isPrivate()) {
                items.add(userSet);
            } else if (this.isOwner(userSet, authentication) || this.hasAdminRights(authentication)) {
                items.add(userSet);
            } else {
                WebUserSetImpl id = new WebUserSetImpl();
                id.setBaseUrl(this.getConfiguration().getSetDataEndpoint());
                id.setIdentifier(userSet.getIdentifier());
                items.add(id);
            }
            this.updatePagination(userSet, this.configuration);
            this.applyProfile(userSet, SetResourceProfile.META);
            if (!userSet.isOpenSet()) continue;
            userSet.setTotal(-1);
        }
        resPage.setItems(items);
        resPage.setTotalInPage((long)items.size());
        return resPage;
    }

    public CollectionPage buildCollectionPage(UserSet userSet, UserSetProfile profile, int pageNr, int pageSize, HttpServletRequest request) throws ParamValidationException {
        int totalInCollection = userSet.getTotal();
        int lastPage = this.validateLastPage((long)totalInCollection, pageSize, pageNr);
        String apiEndpointUrl = this.getConfiguration().getSetApiEndpoint() + userSet.getIdentifier();
        String paginationBaseUrl = this.buildResultsPageUrl(apiEndpointUrl, request.getQueryString(), null);
        String setId = this.buildSetIdUrl(userSet.getIdentifier());
        CollectionOverview partOf = this.buildCollectionOverview(setId, paginationBaseUrl, pageSize, (long)totalInCollection, lastPage, "Collection", profile);
        CollectionPage page = this.createCollectionPageWithItems(userSet, profile, pageNr, pageSize, totalInCollection, partOf);
        if (page == null) {
            return null;
        }
        page.setCurrentPageUri(this.buildPageUrl(paginationBaseUrl, pageNr, pageSize, profile));
        if (pageNr > 1) {
            page.setPrevPageUri(this.buildPageUrl(paginationBaseUrl, pageNr - 1, pageSize, profile));
        }
        if (pageNr < lastPage) {
            page.setNextPageUri(this.buildPageUrl(paginationBaseUrl, pageNr + 1, pageSize, profile));
        }
        return page;
    }

    private CollectionPage createCollectionPageWithItems(UserSet userSet, UserSetProfile profile, int pageNr, int pageSize, int totalInCollection, CollectionOverview partOf) {
        CollectionPage page = null;
        int startIndex = (pageNr - 1) * pageSize;
        int endIndex = Math.min(startIndex + pageSize, totalInCollection);
        switch (1.$SwitchMap$eu$europeana$set$definitions$model$vocabulary$SetPageProfile[((SetPageProfile)profile).ordinal()]) {
            case 1: {
                page = this.createItemDescriptionsCollectionPage(userSet, partOf, startIndex);
                break;
            }
            case 3: {
                page = this.createEmptyCollectionPage(userSet, partOf, startIndex, endIndex);
                break;
            }
            case 2: {
                if (startIndex >= endIndex) {
                    page = this.createEmptyCollectionPage(userSet, partOf, startIndex, endIndex);
                    break;
                }
                page = this.createItemIdsCollectionPage(userSet, partOf, startIndex, endIndex);
                break;
            }
        }
        return page;
    }

    private CollectionPage createItemIdsCollectionPage(UserSet userSet, CollectionOverview partOf, int startIndex, int endIndex) {
        ItemIdsCollectionPage page = new ItemIdsCollectionPage(userSet, partOf, startIndex);
        if (userSet.getItems() == null) {
            return page;
        }
        List items = userSet.getItems().subList(startIndex, endIndex);
        page.setItems(items);
        page.setTotalInPage((long)items.size());
        return page;
    }

    private CollectionPage createItemDescriptionsCollectionPage(UserSet userSet, CollectionOverview partOf, int startIndex) {
        ItemDescriptionsCollectionPage page = new ItemDescriptionsCollectionPage(userSet, partOf, startIndex);
        page.setItemList(userSet.getItems());
        if (userSet.getItems() != null) {
            page.setTotalInPage((long)userSet.getItems().size());
        }
        return page;
    }

    private CollectionPage createEmptyCollectionPage(UserSet userSet, CollectionOverview partOf, int startIndex, int endIndex) {
        CollectionPage page = new CollectionPage(userSet, partOf, startIndex);
        page.setTotalInPage((long)Math.max(0, endIndex - startIndex));
        return page;
    }

    public BaseUserSetResultPage<String> buildRecodsResultsPage(String setIdentifier, List<String> itemIds, int page, int pageSize, SetPageProfile profile, HttpServletRequest request) throws HttpException {
        ItemIdsResultPage result;
        String baseUrl = this.getConfiguration().getSetApiEndpoint();
        String relativePath = request.getRequestURI().replaceFirst(this.getConfiguration().getApiBasePath(), "");
        String resultPageId = baseUrl + relativePath;
        String collectionUrl = this.buildResultsPageUrl(resultPageId, request.getQueryString(), null);
        if (itemIds == null || itemIds.isEmpty()) {
            return this.createItemIdsResultPage(page, pageSize, 0L, profile, collectionUrl);
        }
        long totalnCollection = itemIds.size();
        int lastPage = this.getLastPage((long)itemIds.size(), pageSize);
        int startPos = (page - 1) * pageSize;
        if (startPos >= itemIds.size()) {
            return this.createItemIdsResultPage(page, pageSize, 0L, profile, collectionUrl);
        }
        int toIndex = Math.min(startPos + pageSize, itemIds.size());
        List<String> pageItems = itemIds.subList(startPos, toIndex);
        switch (1.$SwitchMap$eu$europeana$set$definitions$model$vocabulary$SetPageProfile[profile.ordinal()]) {
            case 3: {
                result = this.createItemIdsResultPage(lastPage, pageSize, totalnCollection, profile, collectionUrl);
                break;
            }
            case 2: {
                result = this.createItemIdsResultPage(lastPage, pageSize, totalnCollection, profile, collectionUrl);
                result.setItems(pageItems);
                result.setTotalInPage((long)pageItems.size());
                break;
            }
            case 1: {
                result = this.createItemDescriptionsResultPage(lastPage, pageSize, totalnCollection, profile, collectionUrl);
                List dereferencedItems = this.dereferenceItems(pageItems, profile);
                ((ItemDescriptionsResultPage)result).setItemList(dereferencedItems);
                result.setTotalInPage((long)dereferencedItems.size());
                break;
            }
            default: {
                throw new ParamValidationException("error.invalid_param_value", "error.invalid_param_value", new String[]{"profile", profile.getProfileParamValue()});
            }
        }
        CollectionOverview collectionOverview = this.buildCollectionOverview(collectionUrl, collectionUrl, pageSize, totalnCollection, lastPage, "ResultList", (UserSetProfile)profile);
        result.setPartOf(collectionOverview);
        this.addPagination((ResultsPage)result, collectionUrl, page, pageSize, lastPage, (UserSetProfile)profile);
        return result;
    }

    private List<String> dereferenceItems(@NonNull List<String> pageItems, SetPageProfile profile) throws HttpException {
        WebUserSetImpl itemsSet = new WebUserSetImpl();
        itemsSet.setItems(pageItems);
        UserSet dereferenced = this.fetchUserSetItems((UserSet)itemsSet, null, null, 1, pageItems.size(), profile);
        return dereferenced.getItems();
    }

    private ItemIdsResultPage createItemIdsResultPage(int page, int pageSize, long totalnCollection, SetPageProfile profile, String collectionUrl) {
        ItemIdsResultPage result = new ItemIdsResultPage();
        result.setCurrentPageUri(this.buildPageUrl(collectionUrl, page, pageSize, (UserSetProfile)profile));
        result.setTotalInCollection(totalnCollection);
        return result;
    }

    private ItemDescriptionsResultPage createItemDescriptionsResultPage(int page, int pageSize, long totalnCollection, SetPageProfile profile, String collectionUrl) {
        ItemDescriptionsResultPage result = new ItemDescriptionsResultPage();
        result.setCurrentPageUri(this.buildPageUrl(collectionUrl, page, pageSize, (UserSetProfile)profile));
        result.setTotalInCollection(totalnCollection);
        return result;
    }

    public boolean isAdmin(Authentication authentication) {
        return this.hasAdminRights(authentication);
    }

    public boolean hasEditorRole(Authentication authentication) {
        return this.hasEditorRights(authentication);
    }

    public void applyProfile(UserSet userSet, SetResourceProfile profile) {
        if (this.hasNoPagination(userSet)) {
            this.updatePagination(userSet, this.getConfiguration());
        }
        switch (1.$SwitchMap$eu$europeana$set$definitions$model$vocabulary$SetResourceProfile[profile.ordinal()]) {
            case 1: {
                userSet.setItems(null);
                break;
            }
            default: {
                userSet.setItems(null);
            }
        }
    }

    public void applyProfile(UserSet userSet, SetPageProfile profile) {
        int maxPageSize;
        int itemsCount;
        if (this.hasNoPagination(userSet)) {
            this.updatePagination(userSet, this.getConfiguration());
        }
        if (SetPageProfile.META != profile && userSet.getItems() != null && (itemsCount = userSet.getItems().size()) > (maxPageSize = this.getConfiguration().getMaxPageSize(profile.getProfileParamValue()))) {
            List itemsPage = userSet.getItems().subList(0, maxPageSize);
            userSet.setItems(itemsPage);
        }
        switch (1.$SwitchMap$eu$europeana$set$definitions$model$vocabulary$SetPageProfile[profile.ordinal()]) {
            case 1: {
                ((WebUserSetImpl)userSet).setSerializedItems(userSet.getItems());
                break;
            }
            case 2: {
                this.setSerializedItemIds(userSet);
                break;
            }
            case 3: {
                userSet.setItems(null);
                break;
            }
            default: {
                userSet.setItems(null);
            }
        }
    }

    private boolean hasNoPagination(UserSet userSet) {
        return StringUtils.isEmpty((CharSequence)userSet.getFirst());
    }

    public List<PersistentUserSet> getEntitySetBestBetsItems(UserSetQuery query) {
        return this.getMongoPersistance().getEntitySetsItemAndSubject(query);
    }

    private void setSerializedItemIds(UserSet userSet) {
        if (userSet.getItems() == null) {
            return;
        }
        ArrayList<CallSite> jsonSerialized = new ArrayList<CallSite>(userSet.getItems().size());
        for (String itemId : userSet.getItems()) {
            jsonSerialized.add((CallSite)((Object)("\"" + itemId + "\"")));
        }
        ((WebUserSetImpl)userSet).setSerializedItems(jsonSerialized);
    }

    public UserSet publishUnpublishUserSet(String userSetId, Date issued, Authentication authentication, boolean publish) throws HttpException {
        PersistentUserSet userSet = this.getMongoPersistence().getByIdentifier(userSetId);
        if (userSet == null) {
            throw new UserSetNotFoundException("error.userset_not_found", "error.userset_not_found", new String[]{userSetId});
        }
        this.validateUserSetForPublishUnPublish(userSet, publish);
        if (publish) {
            return this.updateUserSetForPublish(userSet, issued, authentication);
        }
        return this.updateUserSetForUnpublish(userSet, authentication);
    }

    private void validateUserSetForPublishUnPublish(PersistentUserSet userSet, boolean publish) throws HttpException {
        if (this.isPublishingPrevented(userSet)) {
            throw new RequestValidationException("error.userset_operation_not_allowed", new String[]{"Publish/Unpublish user set ", userSet.getType()});
        }
        if (!publish && !userSet.isPublished()) {
            throw new RequestValidationException("error.userset_operation_not_allowed", new String[]{"Unpublish", "not published"});
        }
    }

    private boolean isPublishingPrevented(PersistentUserSet userSet) {
        return userSet.isBookmarksFolder() || userSet.isEntityBestItemsSet();
    }

    public WebResource generateDepiction(UserSet userSet) throws SearchApiClientException {
        if (userSet.getItems() == null || userSet.getItems().isEmpty()) {
            return null;
        }
        String itemId = (String)userSet.getItems().get(0);
        WebResource depiction = this.generateDepictionByItemId(itemId);
        if (!depiction.hasThumbnail() && userSet.getItems().size() > 1) {
            int shortListSize = 10;
            depiction = this.generateDepictionByItemList(userSet, 10);
            if (!depiction.hasThumbnail() && userSet.getItems().size() > 10) {
                int longListSize = 100;
                depiction = this.generateDepictionByItemList(userSet, 100);
            }
        }
        if (depiction.hasThumbnail()) {
            return depiction;
        }
        return null;
    }

    private WebResource generateDepictionByItemId(String itemId) throws SearchApiClientException {
        String url = SearchApiUtils.getInstance().buildSearchApiUrlForItem(this.getConfiguration().getSearchApiUrl(), this.getConfiguration().getItemDataEndpoint(), itemId, this.getConfiguration().getSearchApiKey(), this.getConfiguration().getSearchApiProfileForItemDescriptions());
        WebResource depiction = new WebResource();
        this.getSearchApiClient().fillDepiction(url, itemId, (BaseWebResource)depiction);
        return depiction;
    }

    private WebResource generateDepictionByItemList(UserSet userSet, int pageSize) throws SearchApiClientException {
        WebResource depiction;
        block2: {
            depiction = new WebResource();
            String apiKey = this.getConfiguration().getSearchApiKey();
            String searchApiProfile = this.getConfiguration().getSearchApiProfileForItemDescriptions();
            String url = this.getSearchApiUtils().buildSearchApiUrl(userSet, apiKey, this.getConfiguration().getSearchApiUrl(), searchApiProfile);
            List itemsToSearch = userSet.getItems().subList(0, Math.min(userSet.getItems().size(), pageSize));
            SearchApiRequest searchApiRequest = this.getSearchApiUtils().buildSearchApiPostBodyForItemIds(itemsToSearch, this.getConfiguration().getItemDataEndpoint(), 1, pageSize, searchApiProfile);
            try {
                String jsonBody = this.serializeSearchApiRequest(searchApiRequest);
                this.getSearchApiClient().fillDepiction(url, jsonBody, itemsToSearch, this.getConfiguration().getItemDataEndpoint(), (BaseWebResource)depiction);
            }
            catch (SearchApiClientException | IOException e) {
                if (!this.logger.isInfoEnabled()) break block2;
                this.logger.info("Cannot retrieve depiction using the first {} items of set with id: {} ", (Object)pageSize, (Object)userSet.getIdentifier(), (Object)e);
            }
        }
        return depiction;
    }

    public UserSet createUserSet(UserSet userSet, Authentication authentication) throws HttpException, IOException {
        this.setDefaults(userSet, authentication);
        if (userSet.isEntityBestItemsSet()) {
            this.verifyPermissionToUpdate(userSet, authentication, true);
        }
        this.validateWebUserSet(userSet, false);
        UserSet updatedUserSet = this.getMongoPersistence().create(userSet);
        this.updatePagination(updatedUserSet, this.getConfiguration());
        return updatedUserSet;
    }
}

