/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.set.web.service.impl;

import eu.europeana.api.commons.definitions.search.result.ResultsPage;
import eu.europeana.api.commons.nosql.entity.NoSqlEntity;
import eu.europeana.api.commons.oauth2.model.ApiCredentials;
import eu.europeana.api.commons.web.exception.ApplicationAuthenticationException;
import eu.europeana.api.commons.web.exception.HttpException;
import eu.europeana.api.commons.web.exception.ParamValidationException;
import eu.europeana.set.definitions.config.UserSetConfiguration;
import eu.europeana.set.definitions.model.UserSet;
import eu.europeana.set.definitions.model.agent.Agent;
import eu.europeana.set.definitions.model.utils.UserSetUtils;
import eu.europeana.set.definitions.model.vocabulary.SetPageProfile;
import eu.europeana.set.definitions.model.vocabulary.UserSetProfile;
import eu.europeana.set.definitions.model.vocabulary.UserSetTypes;
import eu.europeana.set.definitions.model.vocabulary.VisibilityTypes;
import eu.europeana.set.mongo.model.internal.PersistentUserSet;
import eu.europeana.set.mongo.service.PersistentUserSetService;
import eu.europeana.set.search.SearchApiRequest;
import eu.europeana.set.search.exception.SearchApiClientException;
import eu.europeana.set.search.service.SearchApiClient;
import eu.europeana.set.search.service.SearchApiResponse;
import eu.europeana.set.search.service.impl.SearchApiClientImpl;
import eu.europeana.set.web.exception.request.ItemValidationException;
import eu.europeana.set.web.exception.request.RequestBodyValidationException;
import eu.europeana.set.web.model.WebResource;
import eu.europeana.set.web.model.WebUser;
import eu.europeana.set.web.model.search.CollectionOverview;
import eu.europeana.set.web.model.search.SearchApiUtils;
import eu.europeana.set.web.model.vocabulary.Roles;
import eu.europeana.set.web.search.UserSetLdSerializer;
import eu.europeana.set.web.service.UserSetService;
import eu.europeana.set.web.service.controller.exception.SetUniquenessValidationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

public abstract class BaseUserSetServiceImpl
implements UserSetService {
    @Resource(name="set_db_setService")
    PersistentUserSetService mongoPersistance;
    UserSetUtils userSetUtils = new UserSetUtils();
    SearchApiUtils userSetSearchApiUtils = SearchApiUtils.getInstance();
    @Resource
    UserSetConfiguration configuration;
    private SearchApiClient searchApiClient = new SearchApiClientImpl();
    Logger logger = LogManager.getLogger(this.getClass());

    protected void updatePagination(UserSet userSet, UserSetConfiguration config) {
        this.userSetUtils.updatePagination(userSet, config);
    }

    protected PersistentUserSetService getMongoPersistence() {
        return this.mongoPersistance;
    }

    public void setMongoPersistance(PersistentUserSetService mongoPersistance) {
        this.mongoPersistance = mongoPersistance;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public PersistentUserSetService getMongoPersistance() {
        return this.mongoPersistance;
    }

    public UserSetUtils getUserSetUtils() {
        return this.userSetUtils;
    }

    public SearchApiClient getSearchApiClient() {
        return this.searchApiClient;
    }

    protected UserSetConfiguration getConfiguration() {
        return this.configuration;
    }

    protected SearchApiUtils getSearchApiUtils() {
        return this.userSetSearchApiUtils;
    }

    @Deprecated(since="")
    void mergeUserSetProperties(PersistentUserSet persistedSet, UserSet updates) {
        if (updates == null) {
            return;
        }
        this.mergeDescriptiveProperties(persistedSet, updates);
        this.mergeProvenanceProperties(persistedSet, updates);
        if (updates.getIsDefinedBy() != null) {
            persistedSet.setIsDefinedBy(updates.getIsDefinedBy());
        }
    }

    void mergeProvenanceProperties(PersistentUserSet persistedSet, UserSet updates) {
        if (updates.getCreator() != null) {
            persistedSet.setCreator(updates.getCreator());
        }
        if (updates.getCreated() != null) {
            persistedSet.setCreated(updates.getCreated());
        }
    }

    void mergeDescriptiveProperties(PersistentUserSet persistedSet, UserSet updates) {
        if (updates.getType() != null) {
            persistedSet.setType(updates.getType());
        }
        persistedSet.setCollectionType(updates.getCollectionType());
        if (updates.getVisibility() != null) {
            persistedSet.setVisibility(updates.getVisibility());
        }
        if (updates.getSubject() != null) {
            persistedSet.setSubject(updates.getSubject());
        }
        if (updates.getTitle() != null) {
            if (persistedSet.getTitle() != null) {
                for (Map.Entry entry : updates.getTitle().entrySet()) {
                    persistedSet.getTitle().put((String)entry.getKey(), (String)entry.getValue());
                }
            } else {
                persistedSet.setTitle(updates.getTitle());
            }
        }
        if (updates.getDescription() != null) {
            if (persistedSet.getDescription() != null) {
                for (Map.Entry entry : updates.getDescription().entrySet()) {
                    persistedSet.getDescription().put((String)entry.getKey(), (String)entry.getValue());
                }
            } else {
                persistedSet.setDescription(updates.getDescription());
            }
        }
    }

    public UserSet updateUserSet(PersistentUserSet persistentUserSet, UserSet webUserSet) throws SetUniquenessValidationException, RequestBodyValidationException, ParamValidationException, ApplicationAuthenticationException, ItemValidationException {
        this.resetImmutableFields(webUserSet, persistentUserSet);
        if (persistentUserSet.isOpenSet() && webUserSet.getIsDefinedBy() == null) {
            throw new RequestBodyValidationException("error.userset_validation_mandatory_property", new String[]{"isDefinedBy (for open sets)"});
        }
        if (webUserSet.isGallery()) {
            this.validateGallerySize((UserSet)persistentUserSet, 0);
        }
        this.validateWebUserSet(webUserSet, persistentUserSet.isPublished());
        this.mergeUserSetProperties(persistentUserSet, webUserSet);
        return (UserSet)this.getMongoPersistence().store((NoSqlEntity)persistentUserSet);
    }

    private void resetImmutableFields(UserSet webUserSet, PersistentUserSet persistentUserSet) {
        webUserSet.setCreator(persistentUserSet.getCreator());
        webUserSet.setIdentifier(persistentUserSet.getIdentifier());
        if (webUserSet.getVisibility() == null) {
            webUserSet.setVisibility(persistentUserSet.getVisibility());
        }
        webUserSet.setContributor(persistentUserSet.getContributor());
    }

    public String buildResultsPageUrl(String apiUrl, String queryString, String searchProfile) {
        if (StringUtils.isNotBlank((CharSequence)queryString)) {
            queryString = this.removeParam("page", (String)queryString);
            queryString = this.removeParam("pageSize", (String)queryString);
            queryString = this.removeParam("facet", (String)queryString);
            queryString = this.removeParam("profile", (String)queryString);
        }
        if (StringUtils.isNotBlank((CharSequence)searchProfile)) {
            if (StringUtils.isNotEmpty((CharSequence)queryString)) {
                queryString = (String)queryString + "&";
            }
            queryString = (String)queryString + "profile=" + searchProfile;
        }
        if (StringUtils.isNotEmpty((CharSequence)queryString)) {
            return apiUrl + "?" + (String)queryString;
        }
        return apiUrl;
    }

    protected String removeParam(String queryParam, String queryString) {
        String tmp;
        int startPos = queryString.indexOf(queryParam + "=");
        int startEndPos = queryString.indexOf(38, startPos + 1);
        if (startPos >= 0) {
            if (startPos > 0) {
                --startPos;
            }
            tmp = queryString.substring(0, startPos);
            if (startEndPos > 0) {
                tmp = tmp + queryString.substring(startEndPos);
            }
        } else {
            tmp = queryString;
        }
        return tmp;
    }

    protected CollectionOverview buildCollectionOverview(String pageId, String paginationBaseUrl, int pageSize, long totalInCollection, int lastPage, String type, UserSetProfile profile) {
        String first = null;
        String last = null;
        if (totalInCollection > 0L && pageSize > 0) {
            first = this.buildPageUrl(paginationBaseUrl, 1, pageSize, profile);
            last = this.buildPageUrl(paginationBaseUrl, lastPage, pageSize, profile);
        }
        return new CollectionOverview(pageId, Long.valueOf(totalInCollection), first, last, type);
    }

    protected int getLastPage(long totalResults, int pageSize) {
        long lastPage = 1L;
        if (totalResults > 0L && pageSize > 0) {
            long reaminder = totalResults % (long)pageSize;
            int extraPage = reaminder == 0L ? 0 : 1;
            lastPage = totalResults / (long)pageSize + (long)extraPage + 1L - 1L;
        }
        return Math.toIntExact(lastPage);
    }

    protected boolean isLastPage(int currentPage, int lastPage) {
        return currentPage == lastPage;
    }

    public String buildPageUrl(String collectionUrl, int page, int pageSize, UserSetProfile profile) {
        StringBuilder builder = new StringBuilder(collectionUrl);
        if (collectionUrl.contains("?")) {
            builder.append('&');
        } else {
            builder.append('?');
        }
        builder.append("page").append('=').append(page);
        builder.append('&').append("pageSize").append('=').append(pageSize);
        boolean hasProfileParam = StringUtils.contains((CharSequence)collectionUrl, (CharSequence)"profile=");
        if (profile != null && !hasProfileParam) {
            builder.append('&').append("profile").append('=').append(profile.getProfileParamValue());
        }
        return builder.toString();
    }

    public String buildCollectionUrl(String searchProfile, String requestUrl, String queryString) {
        queryString = this.removeParam("page", (String)queryString);
        queryString = this.removeParam("pageSize", (String)queryString);
        queryString = this.removeParam("facet", (String)queryString);
        queryString = this.removeParam("profile", (String)queryString);
        if (StringUtils.isNotBlank((CharSequence)searchProfile)) {
            if (!((String)queryString).isEmpty()) {
                queryString = (String)queryString + "&";
            }
            queryString = (String)queryString + "profile=" + searchProfile;
        }
        if (!((String)queryString).isEmpty()) {
            return requestUrl + "?" + (String)queryString;
        }
        return requestUrl;
    }

    protected CollectionOverview buildCollectionOverview(String collectionUrl, int pageSize, long totalInCollection, int lastPage, String type, SetPageProfile profile) {
        String first = null;
        String last = null;
        if (totalInCollection > 0L) {
            first = this.buildPageUrl(collectionUrl, 1, pageSize, (UserSetProfile)profile);
            last = this.buildPageUrl(collectionUrl, lastPage, pageSize, (UserSetProfile)profile);
        }
        return new CollectionOverview(collectionUrl, Long.valueOf(totalInCollection), first, last, type);
    }

    protected void setDefaults(UserSet newUserSet, Authentication authentication) {
        WebUser user = new WebUser();
        if (StringUtils.equals((CharSequence)newUserSet.getType(), (CharSequence)UserSetTypes.ENTITYBESTITEMSSET.getJsonValue())) {
            newUserSet.setVisibility(VisibilityTypes.PUBLIC.getJsonValue());
            user.setHttpUrl(UserSetUtils.buildUserUri((String)this.getConfiguration().getUserDataEndpoint(), (String)this.getConfiguration().getEntityUserSetUserId()));
            user.setNickname("entitygalleries");
            newUserSet.setPinned(0);
            if (this.hasEditorRights(authentication)) {
                newUserSet.setContributor(Collections.singletonList(this.getUserId(authentication)));
            }
        } else {
            user.setHttpUrl(this.getUserId(authentication));
            user.setNickname(((ApiCredentials)authentication.getCredentials()).getUserName());
        }
        newUserSet.setCreator((Agent)user);
        if (newUserSet.getVisibility() == null) {
            newUserSet.setVisibility(VisibilityTypes.PRIVATE.getJsonValue());
        }
        if (newUserSet.getType() == null) {
            newUserSet.setType(UserSetTypes.COLLECTION.getJsonValue());
        }
    }

    public String getUserId(Authentication authentication) {
        return UserSetUtils.buildUserUri((String)this.getConfiguration().getUserDataEndpoint(), (String)((String)authentication.getPrincipal()));
    }

    protected boolean hasAdminRights(Authentication authentication) {
        if (authentication == null) {
            return false;
        }
        return this.hasRole(authentication, Roles.ADMIN.getName());
    }

    public boolean hasEditorRights(Authentication authentication) {
        if (authentication == null) {
            return false;
        }
        return this.hasRole(authentication, Roles.EDITOR.getName());
    }

    protected boolean hasRole(Authentication authentication, String roleType) {
        Iterator iterator = authentication.getAuthorities().iterator();
        while (iterator.hasNext()) {
            String role = ((GrantedAuthority)iterator.next()).getAuthority();
            if (!StringUtils.equalsIgnoreCase((CharSequence)roleType, (CharSequence)role)) continue;
            return true;
        }
        return false;
    }

    void setItemIds(UserSet userSet, SearchApiResponse apiResult) {
        if (apiResult.getItems() == null) {
            return;
        }
        ArrayList<String> items = new ArrayList<String>(apiResult.getItems().size());
        for (String item : apiResult.getItems()) {
            items.add(UserSetUtils.buildItemUrl((String)this.getConfiguration().getItemDataEndpoint(), (String)item));
        }
        this.setItems(userSet, items, apiResult.getTotal());
    }

    void setItems(UserSet userSet, List<String> items, int total) {
        userSet.setItems(items);
        userSet.setTotal(total);
    }

    private boolean isUri(String value) {
        return value.startsWith("http://") || value.startsWith("https://");
    }

    public SetPageProfile getProfileForPagination(List<SetPageProfile> profiles) {
        for (SetPageProfile profile : profiles) {
            if (SetPageProfile.FACETS == profile) continue;
            return profile;
        }
        return null;
    }

    protected void validateItems(List<String> items) throws ItemValidationException {
        if (items == null || items.isEmpty()) {
            return;
        }
        ArrayList<String> invalidItems = new ArrayList<String>();
        for (String item : items) {
            try {
                this.validateItemWhole(item);
            }
            catch (ItemValidationException ex) {
                invalidItems.add(item);
            }
        }
        if (!invalidItems.isEmpty()) {
            throw new ItemValidationException("error.userset_item_invalid_format", new String[]{((Object)invalidItems).toString()});
        }
    }

    protected List<String> validateItemsStrings(List<String> items) throws ItemValidationException {
        ArrayList<String> itemsWithFullUrls = new ArrayList<String>();
        if (items == null) {
            return null;
        }
        ArrayList<String> invalidItems = new ArrayList<String>();
        for (String item : items) {
            try {
                this.validateItem(item);
                String fullUrl = item.startsWith(this.getConfiguration().getItemDataEndpoint()) ? item : UserSetUtils.buildItemUrl((String)this.getConfiguration().getItemDataEndpoint(), (String)item);
                if (itemsWithFullUrls.contains(fullUrl)) continue;
                itemsWithFullUrls.add(fullUrl);
            }
            catch (ItemValidationException ex) {
                this.logger.trace("Invalid item: {}", (Object)item);
                invalidItems.add(item);
            }
        }
        if (!invalidItems.isEmpty()) {
            throw new ItemValidationException("error.userset_item_invalid_format", new String[]{((Object)invalidItems).toString()});
        }
        return itemsWithFullUrls;
    }

    private void validateItem(String item) throws ItemValidationException {
        String recordId = item.startsWith(this.getConfiguration().getItemDataEndpoint()) ? this.extractRecordId(item) : item;
        this.validateEuropeanaRecordId(recordId);
    }

    private String extractRecordId(String item) {
        Object itemWithoutBase = item.substring(this.getConfiguration().getItemDataEndpoint().length());
        if ('/' != ((String)itemWithoutBase).charAt(0)) {
            itemWithoutBase = "/" + (String)itemWithoutBase;
        }
        return itemWithoutBase;
    }

    protected void validateItemWhole(String item) throws ItemValidationException {
        if (!item.startsWith(this.getConfiguration().getItemDataEndpoint())) {
            throw new ItemValidationException("error.userset_item_invalid_format", new String[]{item});
        }
        this.validateEuropeanaRecordId(this.extractRecordId(item));
    }

    protected void validateEuropeanaRecordId(String item) throws ItemValidationException {
        if (!UserSetUtils.EUROPEANA_ID.matcher(item).matches()) {
            throw new ItemValidationException("error.userset_item_invalid_format", new String[]{item});
        }
    }

    public void validateWebUserSet(UserSet webUserSet, boolean isAlreadyPublished) throws RequestBodyValidationException, ParamValidationException, SetUniquenessValidationException, ItemValidationException {
        if (webUserSet.getTitle() == null && !webUserSet.isBookmarksFolder()) {
            throw new RequestBodyValidationException("error.userset_validation_mandatory_property", new String[]{"title"});
        }
        if (webUserSet.isOpenSet()) {
            if (webUserSet.getItems() != null) {
                throw new RequestBodyValidationException("error.userset_validation_property_not_allowed", new String[]{"items", "open"});
            }
            if (webUserSet.getIsDefinedBy() == null) {
                throw new RequestBodyValidationException("error.userset_validation_mandatory_property", new String[]{"isDefinedBy"});
            }
        } else if (webUserSet.getIsDefinedBy() != null) {
            throw new RequestBodyValidationException("error.userset_validation_property_not_allowed", new String[]{"isDefinedBy", "closed"});
        }
        if (!isAlreadyPublished && webUserSet.isPublished()) {
            throw new ParamValidationException("error.userset_validation_property_value", "error.userset_validation_property_value", new String[]{"visibility", webUserSet.getVisibility()});
        }
        if (webUserSet.isGallery()) {
            this.validateGallerySize(webUserSet, 0);
        }
        this.validateProvider(webUserSet);
        this.validateBookmarkFolder(webUserSet);
        this.validateControlledValues(webUserSet);
        this.validateAndSanitizeIsDefinedBy(webUserSet);
        this.validateEntityBestItemsSet(webUserSet);
        this.validateItems(webUserSet.getItems());
    }

    public void validateGallerySize(UserSet webUserSet, int newItems) throws ItemValidationException {
        int galleryMaxSize = this.getConfiguration().getGalleryMaxSize();
        if (webUserSet.getItems() != null && webUserSet.getItems().size() + newItems > galleryMaxSize) {
            String messageKey = newItems == 0 ? "error.userset_number_of_items" : "error.userset_items_limit_reached";
            throw new ItemValidationException(messageKey, new String[]{String.valueOf(galleryMaxSize)});
        }
    }

    void validateProvider(UserSet webUserSet) throws RequestBodyValidationException {
        if (webUserSet.getProvider() == null) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)webUserSet.getProvider().getId()) && StringUtils.isBlank((CharSequence)webUserSet.getProvider().getName())) {
            String message = "must contain either an id or a name.";
            throw new RequestBodyValidationException("error.userset_validation_property_value", new String[]{"provider", "must contain either an id or a name."});
        }
        if (!StringUtils.isBlank((CharSequence)webUserSet.getProvider().getId())) {
            boolean isAllowedProviderId;
            String providerId = webUserSet.getProvider().getId();
            boolean bl = isAllowedProviderId = providerId.startsWith("https://pro.europeana.eu/project/") || providerId.startsWith("http://data.europeana.eu/");
            if (!isAllowedProviderId) {
                String message = providerId + " - must be under one of the domains: http://data.europeana.eu/, https://pro.europeana.eu/project/";
                throw new RequestBodyValidationException("error.userset_validation_property_value", new String[]{"provider", message});
            }
        }
    }

    void validateBookmarkFolder(UserSet webUserSet) throws RequestBodyValidationException, ParamValidationException {
        if (!webUserSet.isBookmarksFolder()) {
            return;
        }
        if (!webUserSet.isPrivate()) {
            throw new ParamValidationException("error.userset_validation_property_value", "error.userset_validation_property_value", new String[]{"visibility", webUserSet.getVisibility()});
        }
        if (webUserSet.isOpenSet()) {
            throw new ParamValidationException("error.userset_validation_property_not_allowed", "error.userset_validation_property_not_allowed", new String[]{"isDefinedBy", webUserSet.getType()});
        }
        if (webUserSet.getCreator() == null || webUserSet.getCreator().getHttpUrl() == null) {
            throw new ParamValidationException("error.userset_validation_mandatory_property", "error.userset_validation_mandatory_property", new String[]{"creator"});
        }
        UserSet usersBookmarkFolder = this.getBookmarkFolder(webUserSet.getCreator());
        if (usersBookmarkFolder == null) {
            return;
        }
        if (webUserSet.getIdentifier() == null) {
            throw new RequestBodyValidationException("error.userset_validation_bookmark_folder_exists", new String[]{usersBookmarkFolder.getIdentifier(), usersBookmarkFolder.getCreator().getHttpUrl()});
        }
        if (!webUserSet.getIdentifier().equals(usersBookmarkFolder.getIdentifier())) {
            throw new RequestBodyValidationException("error.userset_validation_bookmark_folder_exists", new String[]{usersBookmarkFolder.getIdentifier(), usersBookmarkFolder.getCreator().getHttpUrl()});
        }
    }

    protected abstract UserSet getBookmarkFolder(Agent var1);

    void validateControlledValues(UserSet webUserSet) throws RequestBodyValidationException {
        if (webUserSet.getVisibility() == null || !VisibilityTypes.isValid((String)webUserSet.getVisibility())) {
            throw new RequestBodyValidationException("error.userset_validation_property_value", new String[]{"visibility", webUserSet.getVisibility()});
        }
        if (webUserSet.getType() == null || !UserSetTypes.isValid((String)webUserSet.getType())) {
            throw new RequestBodyValidationException("error.userset_validation_property_value", new String[]{"type", webUserSet.getType()});
        }
    }

    void validateAndSanitizeIsDefinedBy(UserSet webUserSet) throws ParamValidationException, RequestBodyValidationException {
        if (webUserSet.isOpenSet()) {
            String isDefinedByWithoutApikey = this.removeParam("wskey", webUserSet.getIsDefinedBy());
            webUserSet.setIsDefinedBy(isDefinedByWithoutApikey);
            SearchApiResponse apiResult = this.retrieveTotalForOpenSets(webUserSet);
            if (apiResult.getTotal() <= 0) {
                throw new RequestBodyValidationException("error.userset_validation_property_value", new String[]{"isDefinedBy", "no items returned when calling " + webUserSet.getIsDefinedBy()});
            }
        }
    }

    public SearchApiResponse retrieveTotalForOpenSets(UserSet webUserSet) throws ParamValidationException, RequestBodyValidationException {
        StringBuilder queryUrl;
        String searchUrl = this.getSearchApiUtils().getBaseSearchUrl(this.getConfiguration().getSearchApiUrl());
        if (!searchUrl.equals((queryUrl = new StringBuilder(this.getSearchApiUtils().getBaseSearchUrl(webUserSet.getIsDefinedBy()))).toString())) {
            throw new ParamValidationException("error.userset_validation_property_value", "error.userset_validation_property_value", new String[]{"isDefinedBy", " the access to api endpoint is not allowed: " + String.valueOf(queryUrl)});
        }
        String apiKey = this.getConfiguration().getSearchApiKey();
        try {
            queryUrl.append('?').append("wskey").append('=').append(apiKey);
            SearchApiRequest searchApiRequest = this.getSearchApiUtils().buildSearchApiPostBody(webUserSet, this.getConfiguration().getItemDataEndpoint(), null, null, 0, 0, null);
            String jsonBody = this.serializeSearchApiRequest(searchApiRequest);
            return this.getSearchApiClient().searchItems(queryUrl.toString(), jsonBody, apiKey, false);
        }
        catch (SearchApiClientException e) {
            throw new RequestBodyValidationException("error.userset_validation_property_value", new String[]{"isDefinedBy", "an error occured when calling " + webUserSet.getIsDefinedBy()}, (Throwable)e);
        }
        catch (IOException e) {
            throw new RequestBodyValidationException("error.userset_validation_search_request_not_valid", null, (Throwable)e);
        }
    }

    String serializeSearchApiRequest(SearchApiRequest searchApiRequest) throws IOException {
        UserSetLdSerializer serializer = new UserSetLdSerializer();
        return serializer.serialize(searchApiRequest);
    }

    void validateEntityBestItemsSet(UserSet webUserSet) throws ParamValidationException, RequestBodyValidationException, SetUniquenessValidationException {
        if (!webUserSet.isEntityBestItemsSet()) {
            return;
        }
        if (webUserSet.getCreator() == null || webUserSet.getCreator().getHttpUrl() == null) {
            throw new ParamValidationException("error.userset_validation_mandatory_property", "error.userset_validation_mandatory_property", new String[]{"creator"});
        }
        List subject = webUserSet.getSubject();
        if (subject == null || subject.isEmpty()) {
            throw new ParamValidationException("error.userset_validation_mandatory_property", "error.userset_validation_mandatory_property", new String[]{"subject", String.valueOf(subject)});
        }
        if (subject.size() != 1 || !this.isUri((String)subject.get(0))) {
            throw new RequestBodyValidationException("error.userset_entity_reference_not_valid", new String[]{"subject", String.valueOf(subject)});
        }
        if (StringUtils.startsWith((CharSequence)((CharSequence)subject.get(0)), (CharSequence)"http://data.europeana.eu/") && StringUtils.contains((CharSequence)((CharSequence)subject.get(0)), (CharSequence)"/base")) {
            throw new RequestBodyValidationException("error.userset_entity_uri_invalid", new String[]{"subject", String.valueOf(subject)});
        }
        if (webUserSet.isOpenSet()) {
            throw new ParamValidationException("error.userset_validation_property_not_allowed", "error.userset_validation_property_not_allowed", new String[]{"isDefinedBy", webUserSet.getType()});
        }
        this.checkDuplicateUserSets(webUserSet);
    }

    void checkDuplicateUserSets(UserSet userSet) throws SetUniquenessValidationException {
        List duplicateSetsIds;
        if (UserSetTypes.ENTITYBESTITEMSSET.getJsonValue().equals(userSet.getType()) && (duplicateSetsIds = this.getMongoPersistence().getDuplicateUserSetsIds(userSet)) != null) {
            String[] i18nParamsSetDuplicates = new String[]{String.join((CharSequence)",", duplicateSetsIds)};
            throw new SetUniquenessValidationException("error.userset_duplication", "error.userset_duplication", i18nParamsSetDuplicates);
        }
    }

    PersistentUserSet updateUserSetForPublish(PersistentUserSet userSet, Date issued, Authentication authentication) {
        if (this.isOwner((UserSet)userSet, authentication)) {
            Agent creator = this.buildEuropeanaPublisherUser();
            userSet.setCreator(creator);
        }
        userSet.setVisibility(VisibilityTypes.PUBLISHED.getJsonValue());
        Date now = new Date();
        if (issued == null) {
            issued = now;
        }
        userSet.setIssued(issued);
        userSet.setModified(now);
        return (PersistentUserSet)this.getMongoPersistence().store((NoSqlEntity)userSet);
    }

    private Agent buildEuropeanaPublisherUser() {
        WebUser creator = new WebUser();
        creator.setHttpUrl(UserSetUtils.buildUserUri((String)this.getConfiguration().getUserDataEndpoint(), (String)this.getConfiguration().getEuropeanaPublisherId()));
        creator.setNickname(this.getConfiguration().getEuropeanaPublisherNickname());
        return creator;
    }

    PersistentUserSet updateUserSetForUnpublish(PersistentUserSet userSet, Authentication authentication) {
        if (this.hasPublisherAsOwner(userSet)) {
            Agent creator = this.buildUserFromAuthentication(authentication);
            userSet.setCreator(creator);
        }
        userSet.setVisibility(VisibilityTypes.PUBLIC.getJsonValue());
        userSet.setIssued(null);
        userSet.setModified(new Date());
        return (PersistentUserSet)this.getMongoPersistence().store((NoSqlEntity)userSet);
    }

    private boolean hasPublisherAsOwner(PersistentUserSet userSet) {
        return this.isOwner((UserSet)userSet, this.getConfiguration().getEuropeanaPublisherId());
    }

    private Agent buildUserFromAuthentication(Authentication authentication) {
        WebUser creator = new WebUser();
        creator.setHttpUrl(this.getUserId(authentication));
        creator.setNickname(((ApiCredentials)authentication.getCredentials()).getUserName());
        return creator;
    }

    public boolean isOwner(UserSet userSet, Authentication authentication) {
        if (authentication == null) {
            return false;
        }
        String userIdentifier = (String)authentication.getPrincipal();
        return this.isOwner(userSet, userIdentifier);
    }

    protected boolean isOwner(UserSet userSet, String userIdentifier) {
        if (userSet.getCreator() == null || userSet.getCreator().getHttpUrl() == null) {
            return false;
        }
        String userId = UserSetUtils.buildUserUri((String)this.getConfiguration().getUserDataEndpoint(), (String)userIdentifier);
        return userSet.getCreator().getHttpUrl().equals(userId);
    }

    public WebResource generateDepiction(UserSet userSet) throws SearchApiClientException {
        return null;
    }

    protected int calculatePosition(int position, List<String> items) {
        int positionFinal = items.size();
        if (position >= 0 && position < items.size()) {
            positionFinal = position;
        }
        return positionFinal;
    }

    protected void addPagination(ResultsPage<?> resPage, String collectionUrl, int page, int pageSize, int lastPage, UserSetProfile profile) {
        String currentPageUrl = this.buildPageUrl(collectionUrl, page, pageSize, profile);
        resPage.setCurrentPageUri(currentPageUrl);
        if (page > 1) {
            String prevPage = this.buildPageUrl(collectionUrl, page - 1, pageSize, profile);
            resPage.setPrevPageUri(prevPage);
        }
        if (!this.isLastPage(page, lastPage)) {
            String nextPage = this.buildPageUrl(collectionUrl, page + 1, pageSize, profile);
            resPage.setNextPageUri(nextPage);
        }
    }

    protected String buildSetIdUrl(String identifier) {
        return this.getConfiguration().getSetDataEndpoint() + identifier;
    }

    protected int validateLastPage(long totalInCollection, int pageSize, int pageNr) throws ParamValidationException {
        int lastPage = this.getLastPage(totalInCollection, pageSize);
        if (pageNr > lastPage) {
            throw new ParamValidationException("error.userset_validation_property_value", "error.userset_validation_property_value", new String[]{"page", "value out of range: " + pageNr + ", last page:" + lastPage});
        }
        return lastPage;
    }

    public UserSet verifyOwnerOrAdmin(UserSet userSet, Authentication authentication, boolean includeEntitySetMsg) throws HttpException {
        return this.verifyOwnerOrAdminOrRole(userSet, authentication, null, includeEntitySetMsg);
    }

    protected UserSet verifyOwnerOrAdminOrRole(UserSet userSet, Authentication authentication, String role, boolean includeEntitySetMsg) throws HttpException {
        if (authentication == null) {
            throw new ApplicationAuthenticationException("error.userset_user_not_authorized", "error.userset_user_not_authorized", new String[]{"Access to update operations of private User Sets require user authentication with JwtToken"}, HttpStatus.FORBIDDEN);
        }
        if (this.isOwner(userSet, authentication) || this.hasAdminRights(authentication)) {
            return userSet;
        }
        if (role != null && this.hasRole(authentication, role)) {
            return userSet;
        }
        StringBuilder message = new StringBuilder();
        if (includeEntitySetMsg) {
            message.append("Only the contributors, creator of the entity user set or admins are authorized to perform this operation.");
        } else {
            message.append("Only the creators of the user set or admins are authorized to perform this operation.");
        }
        throw new ApplicationAuthenticationException("error.operation_not_authorized", "error.operation_not_authorized", new String[]{message.toString()}, HttpStatus.FORBIDDEN);
    }

    public void verifyPermissionToUpdate(UserSet existingUserSet, Authentication authentication, boolean includeEntitySetMsg) throws HttpException {
        if (existingUserSet.isEntityBestItemsSet() && this.hasEditorRole(authentication)) {
            return;
        }
        if (existingUserSet.isPublished()) {
            this.verifyOwnerOrAdminOrRole(existingUserSet, authentication, Roles.PUBLISHER.getName(), false);
        } else {
            this.verifyOwnerOrAdmin(existingUserSet, authentication, false);
        }
    }
}

