/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.set.web.service.controller.jsonld;

import com.fasterxml.jackson.core.JsonParseException;
import eu.europeana.api.commons.definitions.exception.DateParsingException;
import eu.europeana.api.commons.definitions.utils.DateUtils;
import eu.europeana.api.commons.web.exception.ApplicationAuthenticationException;
import eu.europeana.api.commons.web.exception.HttpException;
import eu.europeana.api.commons.web.exception.InternalServerException;
import eu.europeana.api.commons.web.exception.ParamValidationException;
import eu.europeana.set.definitions.exception.UserSetAttributeInstantiationException;
import eu.europeana.set.definitions.exception.UserSetInstantiationException;
import eu.europeana.set.definitions.exception.UserSetValidationException;
import eu.europeana.set.definitions.model.UserSet;
import eu.europeana.set.definitions.model.utils.UserSetUtils;
import eu.europeana.set.definitions.model.vocabulary.SetPageProfile;
import eu.europeana.set.definitions.model.vocabulary.SetResourceProfile;
import eu.europeana.set.definitions.model.vocabulary.UserSetProfile;
import eu.europeana.set.mongo.model.internal.PersistentUserSet;
import eu.europeana.set.search.service.SearchApiResponse;
import eu.europeana.set.web.exception.authorization.OperationAuthorizationException;
import eu.europeana.set.web.exception.request.RequestBodyValidationException;
import eu.europeana.set.web.exception.request.RequestValidationException;
import eu.europeana.set.web.exception.response.UserSetNotFoundException;
import eu.europeana.set.web.model.search.CollectionPage;
import eu.europeana.set.web.service.controller.BaseRest;
import eu.europeana.set.web.service.controller.jsonld.WebUserSetRequestUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jettison.json.JSONException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Web User Set API", description="Perform CRUD Operations for User Sets")
public class WebUserSetRest
extends BaseRest {
    private static final String INVALID_RECORD_ID_MESSAGE = "Invalid record identifier. Only alpha-numeric characters and underscore are allowed";

    @PostMapping(value={"/set/"}, produces={"application/ld+json;charset=utf-8", "application/json;charset=utf-8"})
    @Operation(summary="Create user set", description="Please find JSON-LD samples for user set in <a href=\"../jsp/template/jsonld.jsp\" target=\"_blank\">templates</a>. ")
    public ResponseEntity<String> createUserSet(@RequestBody String userSet, HttpServletRequest request) throws HttpException {
        Authentication authentication = this.verifyWriteAccess("create", request);
        return this.createUserSet(userSet, authentication, request);
    }

    protected ResponseEntity<String> createUserSet(String userSetJsonLdStr, Authentication authentication, HttpServletRequest request) throws HttpException {
        try {
            UserSet webUserSet = this.getUserSetService().parseUserSetLd(userSetJsonLdStr);
            if (webUserSet.getItems() != null) {
                webUserSet.setItems(null);
            }
            UserSet storedUserSet = this.getUserSetService().createUserSet(webUserSet, authentication);
            this.doPostRetrieveProcessing(storedUserSet);
            Map<String, String> specificHeaders = Map.of("Cache-Control", "no-cache, no-store, must-revalidate");
            return this.buildResponseEntity(storedUserSet, SetResourceProfile.META, HttpStatus.CREATED, specificHeaders, request);
        }
        catch (JsonParseException | UserSetAttributeInstantiationException | UserSetValidationException e) {
            throw new RequestBodyValidationException("error.userset_cant_parse_body", new String[]{e.getMessage()}, e);
        }
        catch (UserSetInstantiationException e) {
            throw new HttpException(null, "error.userset_invalid_body", null, HttpStatus.BAD_REQUEST, (Throwable)e);
        }
        catch (HttpException e) {
            throw e;
        }
        catch (IOException | RuntimeException e) {
            throw new InternalServerException((Throwable)e);
        }
    }

    @GetMapping(value={"/set/{identifier}", "/set/{identifier}.json", "/set/{identifier}.jsonld"}, produces={"application/ld+json;charset=utf-8", "application/json;charset=utf-8"})
    @Operation(description="Identifier is a number.", summary="Retrieve a user set")
    public ResponseEntity<String> getUserSet(@RequestParam(value="wskey", required=false) String wskey, @PathVariable(value="identifier") String identifier, @RequestParam(value="sort", required=false) String sortField, @RequestParam(value="sortOrder", required=false) String sortOrderField, @RequestParam(value="page", required=false) String page, @RequestParam(value="pageSize", required=false) String pageSize, @RequestParam(value="profile", required=false) String profile, HttpServletRequest request) throws HttpException {
        Authentication authentication = this.verifyReadAccess(request);
        if (this.isSetResourceRequestResponse((Object)page)) {
            return this.processRetrieveSetRequest(identifier, authentication, request);
        }
        return this.processRetrieveSetPageRequest(identifier, sortField, sortOrderField, page, pageSize, profile, authentication, request);
    }

    private ResponseEntity<String> processRetrieveSetPageRequest(String identifier, String sortField, String sortOrderField, String page, String pageSize, String profile, Authentication authentication, HttpServletRequest request) throws HttpException {
        List profiles = this.getProfilesFromRequest(profile, request);
        if (profiles.isEmpty()) {
            profiles.add(SetPageProfile.ITEMS);
        }
        this.validateMultipleProfiles(profiles, profile);
        SetPageProfile searializationProfile = this.getUserSetService().getProfileForPagination(profiles);
        Integer pageNr = WebUserSetRequestUtils.parsePageNumber((String)page, (int)-1);
        int maxPageSize = this.getConfiguration().getMaxPageSize(searializationProfile.getProfileParamValue());
        Integer pageItems = WebUserSetRequestUtils.getPageSizeOrDefault((String)pageSize, (int)maxPageSize, (int)10);
        return this.getUserSetPage(profiles, identifier, sortField, sortOrderField, pageNr, pageItems, authentication, request);
    }

    private ResponseEntity<String> processRetrieveSetRequest(String identifier, Authentication authentication, HttpServletRequest request) throws HttpException {
        try {
            UserSet userSet = this.getSetAndVerifyAccess(identifier, authentication);
            this.doPostRetrieveProcessing(userSet);
            return this.buildResponseEntity(userSet, SetResourceProfile.META, HttpStatus.OK, null, request);
        }
        catch (IOException e) {
            throw new InternalServerException((Throwable)e);
        }
    }

    private void doPostRetrieveProcessing(UserSet userSet) throws ParamValidationException, RequestBodyValidationException {
        if (userSet.isOpenSet()) {
            SearchApiResponse apiResponse = this.getUserSetService().retrieveTotalForOpenSets(userSet);
            userSet.setTotal(apiResponse.getTotal());
        }
    }

    private UserSet getSetAndVerifyAccess(String identifier, Authentication authentication) throws HttpException {
        UserSet userSet = this.getUserSetService().getUserSetById(identifier);
        if (userSet.isPrivate()) {
            this.getUserSetService().verifyOwnerOrAdmin(userSet, authentication, false);
        }
        return userSet;
    }

    private ResponseEntity<String> getUserSetPage(List<SetPageProfile> profiles, String identifier, String sort, String sortOrder, Integer pageNr, Integer pageSize, Authentication authentication, HttpServletRequest request) throws HttpException {
        try {
            UserSet userSet = this.getSetAndVerifyAccess(identifier, authentication);
            SetPageProfile profile = this.getProfileHelper().getProfileForPagination(profiles);
            if (this.mustFetchItems(userSet, profile)) {
                userSet = this.getUserSetService().fetchUserSetItems(userSet, sort, sortOrder, pageNr.intValue(), pageSize.intValue(), profile);
            }
            CollectionPage itemPage = this.getUserSetService().buildCollectionPage(userSet, (UserSetProfile)profile, pageNr.intValue(), pageSize.intValue(), request);
            return this.buildSetPageResponse(itemPage, userSet.getModified(), profile, request);
        }
        catch (HttpException e) {
            throw e;
        }
        catch (IOException | RuntimeException | JSONException e) {
            throw new InternalServerException(e);
        }
    }

    private boolean mustFetchItems(UserSet userSet, SetPageProfile profile) {
        boolean itemDescriptionsProfile = SetPageProfile.ITEMS_META == profile;
        boolean fetchItemsForOpenSet = userSet.isOpenSet() && SetPageProfile.META != profile;
        return itemDescriptionsProfile || fetchItemsForOpenSet;
    }

    @PutMapping(value={"/set/{identifier}"}, produces={"application/ld+json;charset=utf-8", "application/json;charset=utf-8"})
    @Operation(description="Please find JSON-LD samples for user set in <a href=\"../jsp/template/jsonld.jsp\" target=\"_blank\">templates</a>. Please create your JSON update request using selected fields you are going to update. E.g. 'title' and 'description' example:  { \"title\": {\r\n \"en\": \"New Title\"\r\n  }\r\n }", summary="Update an existing user set")
    public ResponseEntity<String> updateUserSet(@PathVariable(value="identifier") String identifier, @RequestBody String userSet, HttpServletRequest request) throws HttpException {
        Authentication authentication = this.verifyWriteAccess("update", request);
        return this.updateUserSet(request, authentication, identifier, userSet);
    }

    protected ResponseEntity<String> updateUserSet(HttpServletRequest request, Authentication authentication, String identifier, String userSetJsonLdStr) throws HttpException {
        try {
            UserSet existingUserSet = this.getUserSetService().getUserSetById(identifier);
            this.getUserSetService().verifyPermissionToUpdate(existingUserSet, authentication, false);
            String eTagOrigin = this.generateETag(existingUserSet.getModified(), "jsonld", this.getApiVersion());
            this.checkIfMatchHeader(eTagOrigin, request);
            UserSet newUserSet = this.getUserSetService().parseUserSetLd(userSetJsonLdStr);
            if (newUserSet.getItems() != null) {
                throw new RequestValidationException("error.userset_validation", new String[]{"Update method is not allowed to update the items list, please use the insert items method (/set/{identifier}/items)"});
            }
            UserSet updatedUserSet = this.getUserSetService().updateUserSet((PersistentUserSet)existingUserSet, newUserSet);
            return this.buildResponseEntity(updatedUserSet, SetResourceProfile.META, HttpStatus.OK, null, request);
        }
        catch (UserSetInstantiationException | UserSetValidationException e) {
            throw new RequestBodyValidationException("error.userset_cant_parse_body", new String[]{e.getMessage()}, e);
        }
        catch (HttpException e) {
            throw e;
        }
        catch (IOException | RuntimeException e) {
            throw new InternalServerException((Throwable)e);
        }
    }

    private void addContributorForEntitySet(UserSet existingUserSet, Authentication authentication) {
        if (existingUserSet.isEntityBestItemsSet() && this.getUserSetService().hasEditorRole(authentication)) {
            String userId = this.getUserSetService().getUserId(authentication);
            if (existingUserSet.getContributor() != null) {
                if (existingUserSet.getContributor().contains(userId)) {
                    existingUserSet.getContributor().remove(userId);
                }
                existingUserSet.getContributor().add(userId);
            } else {
                existingUserSet.setContributor(Collections.singletonList(userId));
            }
        }
    }

    @PutMapping(value={"/set/{identifier}/publish"}, produces={"application/ld+json;charset=utf-8", "application/json;charset=utf-8"})
    @Operation(description="Please create the request for publishing the set using the provided parameters.", summary="Publish an existing user set")
    public ResponseEntity<String> publishUserSet(@PathVariable(value="identifier") String identifier, @RequestParam(value="issued", required=false) String issued, HttpServletRequest request) throws HttpException {
        Authentication authentication = this.verifyWriteAccess("publish", request);
        Date issuedDate = null;
        if (issued != null) {
            try {
                issuedDate = DateUtils.parseToDate((String)issued);
            }
            catch (DateParsingException e) {
                throw new ParamValidationException("error.invalid_param_value", "error.invalid_param_value", new String[]{"issued", issued}, (Throwable)e);
            }
        }
        return this.publishUnpublishUserSet(identifier, authentication, true, issuedDate, request);
    }

    @PutMapping(value={"/set/{identifier}/unpublish"}, produces={"application/ld+json;charset=utf-8", "application/json;charset=utf-8"})
    @Operation(description="Please create the request for publishing the set using the provided parameters.", summary="Unpublish an existing user set")
    public ResponseEntity<String> unpublishUserSet(@PathVariable(value="identifier") String identifier, HttpServletRequest request) throws HttpException {
        Authentication authentication = this.verifyWriteAccess("publish", request);
        return this.publishUnpublishUserSet(identifier, authentication, false, null, request);
    }

    protected ResponseEntity<String> publishUnpublishUserSet(String identifier, Authentication authentication, boolean publish, Date issued, HttpServletRequest request) throws HttpException {
        try {
            UserSet updatedUserSet = this.getUserSetService().publishUnpublishUserSet(identifier, issued, authentication, publish);
            return this.buildResponseEntity(updatedUserSet, SetResourceProfile.META, HttpStatus.OK, null, request);
        }
        catch (HttpException e) {
            throw e;
        }
        catch (IOException | RuntimeException e) {
            throw new InternalServerException((Throwable)e);
        }
    }

    @Deprecated
    @PutMapping(value={"/set/{identifier}/{datasetId}/{localId}"}, produces={"application/ld+json;charset=utf-8", "application/json;charset=utf-8"})
    @Operation(description="Please create your insert item request using selected parameters.", summary="Insert item to an existing user set")
    public ResponseEntity<String> insertItemIntoUserSet(@PathVariable(value="identifier") String identifier, @PathVariable(value="datasetId") @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid record identifier. Only alpha-numeric characters and underscore are allowed") @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid record identifier. Only alpha-numeric characters and underscore are allowed") String datasetId, @PathVariable(value="localId") @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid record identifier. Only alpha-numeric characters and underscore are allowed") @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid record identifier. Only alpha-numeric characters and underscore are allowed") String localId, @RequestParam(value="position", required=false) String position, HttpServletRequest request) throws HttpException {
        Authentication authentication = this.verifyWriteAccess("update", request);
        return this.insertItemIntoUserSet(request, authentication, identifier, datasetId, localId, position);
    }

    @PutMapping(value={"/set/{identifier}/items"}, produces={"application/ld+json;charset=utf-8", "application/json;charset=utf-8"})
    @Operation(description="Please create your insert multiple items request using selected parameters.", summary="Insert multiple items to an existing user set")
    public ResponseEntity<String> insertMultipleItemsIntoUserSet(@PathVariable(value="identifier") String identifier, @RequestParam(value="position", required=false) String position, @RequestBody List<String> items, HttpServletRequest request) throws HttpException {
        Authentication authentication = this.verifyWriteAccess("update", request);
        return this.insertMultipleItemsIntoUserSet(request, authentication, identifier, items, position);
    }

    @Deprecated
    protected ResponseEntity<String> insertItemIntoUserSet(HttpServletRequest request, Authentication authentication, String identifier, String datasetId, String localId, String position) throws HttpException {
        try {
            UserSet existingUserSet = this.getUserSetService().getUserSetById(identifier);
            this.verifyIfClosedSet(existingUserSet);
            if (!existingUserSet.isEntityBestItemsSet() && WebUserSetRequestUtils.isPinPosition((String)position)) {
                throw new RequestValidationException("error.userset_operation_not_allowed", new String[]{"Pinning item ", existingUserSet.getType()});
            }
            this.getUserSetService().verifyPermissionToUpdate(existingUserSet, authentication, true);
            this.addContributorForEntitySet(existingUserSet, authentication);
            String eTagOrigin = this.generateETag(existingUserSet.getModified(), "jsonld", this.getApiVersion());
            this.checkIfMatchHeader(eTagOrigin, request);
            UserSet updatedUserSet = this.getUserSetService().insertItem(datasetId, localId, position, existingUserSet);
            String serializedUserSetJsonLdStr = this.serializeUserSet(SetPageProfile.META, updatedUserSet);
            String etag = this.generateETag(updatedUserSet.getModified(), "jsonld", this.getApiVersion());
            LinkedMultiValueMap headers = new LinkedMultiValueMap();
            headers.add((Object)"Allow", (Object)"POST,PUT,GET,HEAD,DELETE");
            headers.add((Object)"Vary", (Object)"Prefer");
            headers.add((Object)"Preference-Applied", (Object)SetPageProfile.META.getPreferenceApplied());
            headers.add((Object)"ETag", (Object)etag);
            return new ResponseEntity((Object)serializedUserSetJsonLdStr, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (UserSetValidationException e) {
            throw new RequestValidationException("error.userset_validation", new String[]{e.getMessage()}, (Throwable)e);
        }
        catch (HttpException e) {
            throw e;
        }
        catch (IOException | RuntimeException e) {
            throw new InternalServerException((Throwable)e);
        }
    }

    protected ResponseEntity<String> insertMultipleItemsIntoUserSet(HttpServletRequest request, Authentication authentication, String identifier, List<String> items, String position) throws HttpException {
        try {
            UserSet existingUserSet = this.getUserSetService().getUserSetById(identifier);
            this.getUserSetService().verifyPermissionToUpdate(existingUserSet, authentication, true);
            this.addContributorForEntitySet(existingUserSet, authentication);
            this.verifyIfClosedSet(existingUserSet);
            int itemsPosition = this.parseAndValidateItemPosition(position, existingUserSet);
            if (!existingUserSet.isEntityBestItemsSet() && WebUserSetRequestUtils.isPinPosition((String)position)) {
                throw new RequestValidationException("error.userset_operation_not_allowed", new String[]{"Pinning item ", existingUserSet.getType()});
            }
            if (!WebUserSetRequestUtils.isPinPosition((String)position) && itemsPosition > -1 && itemsPosition < existingUserSet.getPinned()) {
                throw new RequestValidationException("error.userset_operation_not_allowed", new String[]{"Position smaller than pinned is not allowed for non pin request!", itemsPosition + " < " + existingUserSet.getPinned()});
            }
            String eTagOrigin = this.generateETag(existingUserSet.getModified(), "jsonld", this.getApiVersion());
            this.checkIfMatchHeader(eTagOrigin, request);
            UserSet updatedUserSet = this.getUserSetService().insertMultipleItems(items, position, itemsPosition, existingUserSet);
            String serializedUserSetJsonLdStr = this.serializeUserSet(SetPageProfile.META, updatedUserSet);
            String etag = this.generateETag(updatedUserSet.getModified(), "jsonld", this.getApiVersion());
            LinkedMultiValueMap headers = new LinkedMultiValueMap();
            headers.add((Object)"Allow", (Object)"POST,PUT,GET,HEAD,DELETE");
            headers.add((Object)"Vary", (Object)"Prefer");
            headers.add((Object)"Preference-Applied", (Object)SetPageProfile.META.getPreferenceApplied());
            headers.add((Object)"ETag", (Object)etag);
            return new ResponseEntity((Object)serializedUserSetJsonLdStr, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (UserSetValidationException e) {
            throw new RequestValidationException("error.userset_validation", new String[]{e.getMessage()}, (Throwable)e);
        }
        catch (HttpException e) {
            throw e;
        }
        catch (IOException | RuntimeException e) {
            throw new InternalServerException((Throwable)e);
        }
    }

    private void verifyIfClosedSet(UserSet existingUserSet) throws RequestValidationException {
        if (existingUserSet.isOpenSet()) {
            throw new RequestValidationException("error.userset_operation_not_allowed", new String[]{"'Insert item to existing user set'", "open"});
        }
    }

    private int parseAndValidateItemPosition(String position, UserSet existingUserSet) throws ParamValidationException, RequestValidationException {
        int itemsPosition = this.parseItemsPosition(position);
        if (!WebUserSetRequestUtils.isPinPosition((String)position) && itemsPosition >= 0 && itemsPosition < existingUserSet.getPinned()) {
            throw new RequestValidationException("error.userset_unpinned_items_position_invalid", null);
        }
        return itemsPosition;
    }

    private int parseItemsPosition(String position) throws ParamValidationException {
        if (WebUserSetRequestUtils.isPinPosition((String)position)) {
            return 0;
        }
        int positionFinal = -1;
        if (position != null) {
            try {
                positionFinal = Integer.parseInt(position);
                if (positionFinal < 0) {
                    throw new ParamValidationException("error.invalid_param_value", "error.invalid_param_value", new String[]{"position", position});
                }
            }
            catch (RuntimeException e) {
                throw new ParamValidationException("error.invalid_param_value", "error.invalid_param_value", new String[]{"position", position}, (Throwable)e);
            }
        }
        return positionFinal;
    }

    @RequestMapping(value={"/set/{identifier}/{datasetId}/{localId}"}, method={RequestMethod.GET}, produces={"application/ld+json;charset=utf-8", "application/json;charset=utf-8"})
    @Operation(description="Check if item is already in a user set", summary="Check if item is member of the Set")
    public ResponseEntity<String> isItemInUserSet(@RequestParam(value="wskey", required=false) String wskey, @PathVariable(value="identifier") String identifier, @PathVariable(value="datasetId") @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid record identifier. Only alpha-numeric characters and underscore are allowed") @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid record identifier. Only alpha-numeric characters and underscore are allowed") String datasetId, @PathVariable(value="localId") @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid record identifier. Only alpha-numeric characters and underscore are allowed") @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid record identifier. Only alpha-numeric characters and underscore are allowed") String localId, HttpServletRequest request) throws HttpException {
        Authentication authentication = this.verifyReadAccess(request);
        return this.isItemInUserSet(wskey, identifier, datasetId, localId, authentication);
    }

    protected ResponseEntity<String> isItemInUserSet(String wsKey, String identifier, String datasetId, String localId, Authentication authentication) throws HttpException {
        try {
            UserSet existingUserSet = this.getUserSetService().getUserSetById(identifier);
            if (existingUserSet.isEntityBestItemsSet()) {
                this.getUserSetService().verifyPermissionToUpdate(existingUserSet, authentication, true);
            } else if (existingUserSet.isPrivate()) {
                this.getUserSetService().verifyOwnerOrAdmin(existingUserSet, authentication, false);
            }
            this.addContributorForEntitySet(existingUserSet, authentication);
            HttpStatus httpStatus = null;
            String newItem = UserSetUtils.buildItemUrl((String)this.getConfiguration().getItemDataEndpoint(), (String)datasetId, (String)localId);
            httpStatus = existingUserSet.getItems() != null && existingUserSet.getItems().contains(newItem) ? HttpStatus.NO_CONTENT : HttpStatus.NOT_FOUND;
            LinkedMultiValueMap headers = new LinkedMultiValueMap(5);
            headers.add((Object)"Allow", (Object)"POST,PUT,GET,HEAD,DELETE");
            return new ResponseEntity((Object)"", (MultiValueMap)headers, httpStatus);
        }
        catch (UserSetInstantiationException | UserSetValidationException e) {
            throw new RequestBodyValidationException("error.userset_cant_parse_body", new String[]{e.getMessage()}, e);
        }
        catch (HttpException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new InternalServerException((Throwable)e);
        }
    }

    @Deprecated(since="EA-3869", forRemoval=true)
    @DeleteMapping(value={"/set/{identifier}/{datasetId}/{localId}"}, produces={"application/ld+json;charset=utf-8", "application/json;charset=utf-8"})
    @Operation(description="Delete a item from the set", summary="Delete a item from the set")
    public ResponseEntity<String> deleteItemFromUserSet(@PathVariable(value="identifier") String identifier, @PathVariable(value="datasetId") @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid record identifier. Only alpha-numeric characters and underscore are allowed") @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid record identifier. Only alpha-numeric characters and underscore are allowed") String datasetId, @PathVariable(value="localId") @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid record identifier. Only alpha-numeric characters and underscore are allowed") @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid record identifier. Only alpha-numeric characters and underscore are allowed") String localId, HttpServletRequest request) throws HttpException {
        Authentication authentication = this.verifyWriteAccess("delete", request);
        return this.deleteItemFromUserSet(authentication, identifier, datasetId, localId);
    }

    protected ResponseEntity<String> deleteItemFromUserSet(Authentication authentication, String identifier, String datasetId, String localId) throws HttpException {
        try {
            boolean hasItem;
            UserSet existingUserSet = this.getUserSetService().getUserSetById(identifier);
            this.getUserSetService().verifyPermissionToUpdate(existingUserSet, authentication, true);
            this.addContributorForEntitySet(existingUserSet, authentication);
            String newItem = UserSetUtils.buildItemUrl((String)this.getConfiguration().getItemDataEndpoint(), (String)datasetId, (String)localId);
            boolean bl = hasItem = existingUserSet.getItems() != null && existingUserSet.getItems().contains(newItem);
            if (!hasItem) {
                throw new UserSetNotFoundException("error.userset_item_not_found", "error.userset_item_not_found", new String[]{datasetId + "/" + localId, identifier});
            }
            UserSet updatedUserSet = this.getUserSetService().deleteItem(newItem, existingUserSet);
            String serializedUserSetJsonLdStr = this.serializeUserSet(SetPageProfile.META, updatedUserSet);
            String etag = this.generateETag(updatedUserSet.getModified(), "jsonld", this.getApiVersion());
            LinkedMultiValueMap headers = new LinkedMultiValueMap(5);
            headers.add((Object)"Allow", (Object)"POST,PUT,GET,HEAD,DELETE");
            headers.add((Object)"Preference-Applied", (Object)SetPageProfile.META.getPreferenceApplied());
            headers.add((Object)"ETag", (Object)etag);
            return new ResponseEntity((Object)serializedUserSetJsonLdStr, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (UserSetInstantiationException | UserSetValidationException e) {
            throw new RequestBodyValidationException("error.userset_cant_parse_body", new String[]{e.getMessage()}, e);
        }
        catch (HttpException e) {
            throw e;
        }
        catch (IOException | RuntimeException e) {
            throw new InternalServerException((Throwable)e);
        }
    }

    @DeleteMapping(value={"/set/{identifier}/items"}, produces={"application/ld+json;charset=utf-8", "application/json;charset=utf-8"})
    @Operation(description="Delete multiple items from the set", summary="Delete multiple items from the set")
    public ResponseEntity<String> deleteMultipleItemsFromUserSet(@PathVariable(value="identifier") String identifier, @RequestBody List<String> items, HttpServletRequest request) throws HttpException {
        Authentication authentication = this.verifyWriteAccess("delete", request);
        return this.deleteMultipleItemsFromUserSet(authentication, identifier, items);
    }

    protected ResponseEntity<String> deleteMultipleItemsFromUserSet(Authentication authentication, String identifier, List<String> items) throws HttpException {
        try {
            UserSet existingUserSet = this.getUserSetService().getUserSetById(identifier);
            this.verifyIfClosedSet(existingUserSet);
            this.getUserSetService().verifyPermissionToUpdate(existingUserSet, authentication, true);
            this.addContributorForEntitySet(existingUserSet, authentication);
            UserSet updatedUserSet = this.getUserSetService().deleteMultipleItems(items, existingUserSet);
            String serializedUserSetJsonLdStr = this.serializeUserSet(SetPageProfile.META, updatedUserSet);
            String etag = this.generateETag(updatedUserSet.getModified(), "jsonld", this.getApiVersion());
            LinkedMultiValueMap headers = new LinkedMultiValueMap(5);
            headers.add((Object)"Allow", (Object)"POST,PUT,GET,HEAD,DELETE");
            headers.add((Object)"Preference-Applied", (Object)SetPageProfile.META.getPreferenceApplied());
            headers.add((Object)"ETag", (Object)etag);
            return new ResponseEntity((Object)serializedUserSetJsonLdStr, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (UserSetInstantiationException | UserSetValidationException e) {
            throw new RequestBodyValidationException("error.userset_cant_parse_body", new String[]{e.getMessage()}, e);
        }
        catch (HttpException e) {
            throw e;
        }
        catch (IOException | RuntimeException e) {
            throw new InternalServerException((Throwable)e);
        }
    }

    @DeleteMapping(value={"/set/{identifier}"})
    @Operation(summary="Delete Set", description="Delete an existing user set")
    public ResponseEntity<String> deleteUserSet(@PathVariable(value="identifier") String identifier, HttpServletRequest request) throws HttpException {
        Authentication authentication = this.verifyWriteAccess("delete", request);
        return this.deleteUserSet(request, identifier, authentication);
    }

    protected ResponseEntity<String> deleteUserSet(HttpServletRequest request, String identifier, Authentication authentication) throws HttpException {
        try {
            UserSet existingUserSet = this.getUserSetService().getUserSetById(identifier);
            this.getUserSetService().verifyOwnerOrAdmin(existingUserSet, authentication, false);
            String eTagOrigin = this.generateETag(existingUserSet.getModified(), "jsonld", this.getApiVersion());
            this.checkIfMatchHeader(eTagOrigin, request);
            HttpStatus httpStatus = null;
            httpStatus = HttpStatus.NO_CONTENT;
            this.getUserSetService().deleteUserSet(existingUserSet.getIdentifier());
            LinkedMultiValueMap headers = new LinkedMultiValueMap(5);
            headers.add((Object)"Link", (Object)"<http://www.w3.org/ns/ldp#BasicContainer>; rel=\"type\"");
            headers.add((Object)"Link", (Object)"<http://www.w3.org/ns/ldp#Resource>; rel=\"type\"");
            headers.add((Object)"Allow", (Object)this.createAllowHeader(request));
            return new ResponseEntity(null, (MultiValueMap)headers, httpStatus);
        }
        catch (HttpException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new InternalServerException((Throwable)e);
        }
    }

    @DeleteMapping(value={"/set/"})
    @Operation(summary="Delete Sets", description="Delete sets associated with user")
    public ResponseEntity<String> deleteUserAssociatedSet(@RequestParam(value="creator", required=false) String creator, HttpServletRequest request) throws HttpException {
        Authentication authentication = this.verifyWriteAccess("delete", request);
        return this.deleteUserAssociatedSets(this.getCreatorId(authentication, creator));
    }

    private String getCreatorId(Authentication authentication, String creatorId) throws RequestValidationException, ApplicationAuthenticationException {
        if (creatorId == null) {
            return this.getUserSetService().getUserId(authentication);
        }
        if (creatorId.isEmpty()) {
            throw new RequestValidationException("error.invalid_param_value", new String[]{"Creator Id is empty"});
        }
        if (!this.getUserSetService().isAdmin(authentication)) {
            throw new ApplicationAuthenticationException("error.operation_not_authorized", "error.operation_not_authorized", new String[]{"Only admins are authorized to perform this operation."}, HttpStatus.FORBIDDEN);
        }
        if (!StringUtils.startsWith((CharSequence)creatorId, (CharSequence)"http")) {
            return UserSetUtils.buildUserUri((String)this.getConfiguration().getUserDataEndpoint(), (String)creatorId);
        }
        return creatorId;
    }

    protected ResponseEntity<String> deleteUserAssociatedSets(String creatorId) throws HttpException {
        try {
            List userSets = this.getUserSetService().getUserSetByCreatorId(creatorId);
            for (UserSet userset : userSets) {
                if (StringUtils.equals((CharSequence)creatorId, (CharSequence)userset.getCreator().getHttpUrl())) continue;
                throw new OperationAuthorizationException("error.operation_not_authorized", "error.operation_not_authorized", new String[]{"Only user associated sets can be deleted"}, HttpStatus.FORBIDDEN);
            }
            HttpStatus httpStatus = null;
            httpStatus = HttpStatus.NO_CONTENT;
            this.getUserSetService().deleteUserSets(creatorId, userSets);
            LinkedMultiValueMap headers = new LinkedMultiValueMap(5);
            headers.add((Object)"Allow", (Object)"POST,GET,DELETE");
            headers.add((Object)"Cache-Control", (Object)"no-cache, no-store, must-revalidate");
            return new ResponseEntity((MultiValueMap)headers, httpStatus);
        }
        catch (HttpException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new InternalServerException((Throwable)e);
        }
    }

    @Deprecated
    private int getDerefItemsCount(UserSet userSet, int pageSize) {
        if (userSet.isOpenSet()) {
            return Math.min(pageSize, this.getConfiguration().getMaxRetrieveDereferencedItems());
        }
        return Math.min(userSet.getTotal(), this.getConfiguration().getMaxRetrieveDereferencedItems());
    }
}

