/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.set.web.service.controller.jsonld;

import eu.europeana.api.commons.definitions.search.ResultSet;
import eu.europeana.api.commons.web.exception.HttpException;
import eu.europeana.api.commons.web.exception.InternalServerException;
import eu.europeana.api.commons.web.exception.ParamValidationException;
import eu.europeana.set.definitions.model.UserSet;
import eu.europeana.set.definitions.model.search.UserSetFacetQuery;
import eu.europeana.set.definitions.model.search.UserSetQuery;
import eu.europeana.set.definitions.model.utils.UserSetUtils;
import eu.europeana.set.definitions.model.vocabulary.SetPageProfile;
import eu.europeana.set.web.exception.request.RequestValidationException;
import eu.europeana.set.web.model.search.BaseUserSetResultPage;
import eu.europeana.set.web.search.UserSetLdSerializer;
import eu.europeana.set.web.search.UserSetQueryBuilder;
import eu.europeana.set.web.service.controller.BaseRest;
import eu.europeana.set.web.service.controller.jsonld.WebUserSetRequestUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="User Set Discovery API")
public class SearchUserSetRest
extends BaseRest {
    UserSetQueryBuilder queryBuilder;

    public synchronized UserSetQueryBuilder getQueryBuilder() {
        if (this.queryBuilder == null) {
            this.queryBuilder = new UserSetQueryBuilder();
        }
        return this.queryBuilder;
    }

    @GetMapping(value={"/set/search", "/set/search.json", "/set/search.jsonld"}, produces={"application/ld+json;charset=utf-8", "application/json;charset=utf-8"})
    @Operation(description="Searching user sets. The criteria for filtering results is provided in form of <field>:<value> pairs, using the query and qf request parameters. Currently supported fields are: type, visibility, creator, item, provider and lang (title language).", summary="Search user sets")
    public ResponseEntity<String> searchUserSet(@RequestParam(value="wskey", required=false) String wskey, @RequestParam(value="query", required=true) String query, @RequestParam(value="qf", required=false) String[] qf, @RequestParam(value="sort", required=false) String sort, @RequestParam(value="page", required=false, defaultValue="1") String page, @RequestParam(value="pageSize", required=false, defaultValue="10") String pageSize, @RequestParam(value="facet", required=false) String facet, @RequestParam(value="facet.limit", required=false, defaultValue="50") int facetLimit, @RequestParam(value="profile", required=false, defaultValue="items.meta") String profileStr, HttpServletRequest request) throws HttpException {
        try {
            Authentication authentication = this.verifyReadAccess(request);
            if (profileStr.contains("standard")) {
                profileStr = profileStr.replace("standard", "items.meta");
            }
            List profiles = this.getProfilesFromRequest(profileStr, request);
            this.validateMultipleProfiles(profiles, profileStr);
            SetPageProfile serializationProfile = this.getUserSetService().getProfileForPagination(profiles);
            if (serializationProfile == null) {
                serializationProfile = SetPageProfile.ITEMS_META;
                profiles.add(serializationProfile);
            }
            UserSetFacetQuery facetQuery = null;
            if (profiles.contains(SetPageProfile.FACETS)) {
                facetQuery = this.getQueryBuilder().buildUserSetFacetQuery(facet, facetLimit);
            }
            Integer pageNr = WebUserSetRequestUtils.parsePageNumber((String)page, (int)-1);
            int maxPageSize = this.getConfiguration().getMaxPageSize(serializationProfile.getProfileParamValue());
            Integer pageItems = WebUserSetRequestUtils.getPageSizeOrDefault((String)pageSize, (int)maxPageSize, (int)10);
            UserSetQuery searchQuery = this.getQueryBuilder().buildUserSetQuery(query, qf, sort, pageNr.intValue(), pageItems.intValue(), this.getConfiguration());
            ResultSet results = this.getUserSetService().search(searchQuery, facetQuery, profiles, authentication);
            String requestURL = request.getRequestURL().toString();
            BaseUserSetResultPage resultsPage = this.getUserSetService().buildResultsPage(searchQuery, results, requestURL, request.getQueryString(), profiles, authentication);
            String jsonLd = this.serializeResultsPage(resultsPage);
            return this.buildSearchResponse(jsonLd);
        }
        catch (HttpException e) {
            throw e;
        }
        catch (IOException | RuntimeException e) {
            throw new InternalServerException((Throwable)e);
        }
    }

    private String serializeResultsPage(BaseUserSetResultPage resultsPage) throws IOException {
        UserSetLdSerializer serializer = new UserSetLdSerializer();
        return serializer.serialize(resultsPage);
    }

    private ResponseEntity<String> buildSearchResponse(String jsonLd) {
        LinkedMultiValueMap headers = new LinkedMultiValueMap(5);
        headers.add((Object)"Vary", (Object)"Accept");
        headers.add((Object)"Vary", (Object)"Prefer");
        headers.add((Object)"Allow", (Object)"GET");
        return new ResponseEntity((Object)jsonLd, (MultiValueMap)headers, HttpStatus.OK);
    }

    @GetMapping(value={"/set/{identifier}/search", "/set/{identifier}/search.json", "/set/{identifier}/search.jsonld"}, produces={"application/ld+json;charset=utf-8", "application/json;charset=utf-8"})
    @Operation(description="Searching items within a set indicated by identifier parameter. Use the use * for query and item:<itemId> filter in qf parameter. (Multiple item filters are build an OR search criteria)", summary="Search items in set")
    public ResponseEntity<String> searchItemsInSet(@PathVariable(value="identifier") String identifier, @RequestParam(value="wskey", required=false) String wskey, @RequestParam(value="query", required=true, defaultValue="*") String query, @RequestParam(value="qf", required=false) String[] qf, @RequestParam(value="page", required=false, defaultValue="1") String page, @RequestParam(value="pageSize", required=false, defaultValue="10") String pageSize, @RequestParam(value="profile", required=false, defaultValue="items") String profileStr, HttpServletRequest request) throws HttpException {
        try {
            List filtered;
            Authentication authentication = this.verifyReadAccess(request);
            if (!UserSetQueryBuilder.isSearchAllQuery((String)query)) {
                throw new ParamValidationException("error.userset_validation_property_value", "error.userset_validation_property_value", new String[]{"query", query + " Currently only * is supported as query, use qf for provinding the items list."});
            }
            List profiles = this.getProfilesFromRequest(profileStr, request);
            this.validateMultipleProfiles(profiles, profileStr);
            SetPageProfile profile = this.getUserSetService().getProfileForPagination(profiles);
            if (profile == null) {
                profile = SetPageProfile.ITEMS;
                profiles.add(profile);
            }
            List itemIds = this.buildItemIdsList(qf);
            UserSet existingUserSet = this.getUserSetService().getUserSetById(identifier);
            if (existingUserSet.isOpenSet()) {
                throw new RequestValidationException("error.userset_operation_not_allowed", new String[]{"Search item in set", "open"});
            }
            if (existingUserSet.isPrivate()) {
                this.getUserSetService().verifyOwnerOrAdmin(existingUserSet, authentication, false);
            }
            if (itemIds != null && !itemIds.isEmpty()) {
                filtered = new ArrayList(existingUserSet.getItems());
                filtered.retainAll(itemIds);
            } else {
                filtered = Collections.emptyList();
            }
            Integer pageNr = WebUserSetRequestUtils.parsePageNumber((String)page, (int)-1);
            int maxPageSize = this.getConfiguration().getMaxPageSize(profile.getProfileParamValue());
            Integer pageItems = WebUserSetRequestUtils.getPageSizeOrDefault((String)pageSize, (int)maxPageSize, (int)10);
            BaseUserSetResultPage resultPage = this.getUserSetService().buildRecodsResultsPage(identifier, filtered, pageNr.intValue(), pageItems.intValue(), profile, request);
            UserSetLdSerializer serializer = new UserSetLdSerializer();
            String jsonLd = serializer.serialize(resultPage);
            LinkedMultiValueMap headers = new LinkedMultiValueMap(5);
            headers.add((Object)"Link", (Object)"<http://www.w3.org/ns/ldp#BasicContainer>; rel=\"type\"");
            headers.add((Object)"Link", (Object)"<http://www.w3.org/ns/ldp#Resource>; rel=\"type\"");
            headers.add((Object)"Allow", (Object)"GET");
            return new ResponseEntity((Object)jsonLd, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (HttpException e) {
            throw e;
        }
        catch (IOException | RuntimeException e) {
            throw new InternalServerException((Throwable)e);
        }
    }

    private List<String> buildItemIdsList(String[] qf) throws ParamValidationException {
        if (qf == null || qf.length == 0) {
            return null;
        }
        String ITEM_PREFIX = "item:";
        ArrayList<String> itemIds = new ArrayList<String>(qf.length);
        for (int i = 0; i < qf.length; ++i) {
            if (!qf[i].contains("item:")) {
                throw new ParamValidationException("error.userset_validation_property_value", "error.userset_validation_property_value", new String[]{"qf", qf[i]});
            }
            String recordId = qf[i].replace("item:", "").trim();
            itemIds.add(UserSetUtils.buildItemUrl((String)this.getConfiguration().getItemDataEndpoint(), (String)recordId));
        }
        return itemIds;
    }
}

