/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.set.web.service.controller.jsonld;

import eu.europeana.api.commons.definitions.statistics.set.SetMetric;
import eu.europeana.api.commons.web.exception.ApplicationAuthenticationException;
import eu.europeana.api.commons.web.exception.HttpException;
import eu.europeana.api.commons.web.exception.InternalServerException;
import eu.europeana.set.definitions.exception.UserSetServiceException;
import eu.europeana.set.definitions.model.UserSet;
import eu.europeana.set.definitions.model.utils.UserSetUtils;
import eu.europeana.set.definitions.model.vocabulary.UserSetTypes;
import eu.europeana.set.mongo.model.internal.PersistentUserSet;
import eu.europeana.set.web.exception.response.UserSetNotFoundException;
import eu.europeana.set.web.model.elevation.Doc;
import eu.europeana.set.web.model.elevation.Elevation;
import eu.europeana.set.web.model.elevation.Query;
import eu.europeana.set.web.search.UserSetLdSerializer;
import eu.europeana.set.web.service.controller.BaseRest;
import eu.europeana.set.web.utils.UserSetXMLSerializer;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Auxiliary Methods")
public class AuxiliaryMethodsRest
extends BaseRest {
    @GetMapping(value={"/set/elevation"}, produces={"application/xml"})
    @Operation(description="Generate Elevation file for best bets", summary="Generate elevation file")
    public ResponseEntity<String> generateElevationFile(@RequestParam(value="wskey", required=false) String wsKey, HttpServletRequest request) throws HttpException {
        this.verifyReadAccess(request);
        return this.generateElevation();
    }

    @GetMapping(value={"/set/stats"}, produces={"application/json;charset=utf-8"})
    @Operation(description="Generating set API usage statistics. Pushing metrics to Databox ", summary="Generate usage statistics")
    public ResponseEntity<String> generateUsageStats(@RequestParam(value="wskey", required=true) String wsKey, HttpServletRequest request) throws IOException, ApplicationAuthenticationException, UserSetServiceException {
        return this.getUsageStats(request);
    }

    private ResponseEntity<String> generateElevation() throws HttpException {
        try {
            List usersets = this.getUserSetService().getEntitySetBestBetsItems(this.getUsageStatsService().buildUserSetQuery(null, UserSetTypes.ENTITYBESTITEMSSET.getJsonValue(), null));
            Elevation elevation = this.buildElevation(usersets);
            if (elevation != null) {
                UserSetXMLSerializer xmlSerializer = new UserSetXMLSerializer();
                String xml = xmlSerializer.serialize(elevation);
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).header("Content-Type", new String[]{"application/xml;charset=UTF-8"})).body((Object)xml);
            }
            throw new UserSetNotFoundException("error.no_elevation_generated", "error.no_elevation_generated", null);
        }
        catch (IOException e) {
            throw new InternalServerException((Throwable)e);
        }
    }

    private Elevation buildElevation(List<PersistentUserSet> userSets) throws UserSetNotFoundException {
        if (userSets.isEmpty()) {
            throw new UserSetNotFoundException("error.no_entity_userset_found", "error.no_entity_userset_found", null);
        }
        Elevation elevation = new Elevation();
        ArrayList<Query> queries = new ArrayList<Query>();
        for (UserSet userSet : userSets) {
            String text = this.generateQueryText(userSet.getSubject());
            ArrayList<Doc> docList = new ArrayList<Doc>();
            if (userSet.getItems() != null) {
                for (String item : userSet.getItems()) {
                    docList.add(new Doc(UserSetUtils.extractItemIdentifier((String)item, (String)this.getConfiguration().getItemDataEndpoint())));
                }
            }
            if (text.isEmpty() || docList.isEmpty()) continue;
            queries.add(new Query(text, docList));
        }
        if (!queries.isEmpty()) {
            elevation.setQuery(queries);
            return elevation;
        }
        return null;
    }

    private String generateQueryText(List<String> subject) {
        StringBuilder text = new StringBuilder();
        String s = subject.get(0);
        if (s.contains("agent")) {
            text.append("edm_agent:");
        } else if (s.contains("concept")) {
            text.append("skos_concept:");
        } else if (s.contains("timespan")) {
            text.append("edm_timespan:");
        } else if (s.contains("organization")) {
            text.append("foaf_organization:");
        } else {
            return "";
        }
        text.append('\"').append(s).append('\"');
        return text.toString();
    }

    public static void writeElevation(String directoryLocation, String xml) throws InternalServerException {
        if (!directoryLocation.isEmpty()) {
            try {
                File elevationFile = new File(directoryLocation, FilenameUtils.getName((String)"elevate.xml"));
                elevationFile.mkdirs();
                FileUtils.write((File)elevationFile, (CharSequence)xml, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new InternalServerException("Error creating the elevate.xml file", (Throwable)e);
            }
        }
    }

    private ResponseEntity<String> getUsageStats(HttpServletRequest request) throws IOException, ApplicationAuthenticationException, UserSetServiceException {
        this.verifyReadAccess(request);
        SetMetric metric = new SetMetric();
        metric.setType("OverallTotal");
        this.getUsageStatsService().getPublicPrivateSetsCount(metric);
        this.getUsageStatsService().getTotalItemsLiked(metric);
        this.getUsageStatsService().getAverageSetsPerUser(metric);
        this.getUsageStatsService().getNumberOfUsersWithLike(metric);
        this.getUsageStatsService().getNumberOfEntitySets(metric);
        this.getUsageStatsService().getNumberOfItemsInEntitySets(metric);
        metric.setTimestamp(new Date());
        String json = this.serializeMetricView(metric);
        return this.buildUsageStatsResponse(json);
    }

    private ResponseEntity<String> buildUsageStatsResponse(String json) {
        LinkedMultiValueMap headers = new LinkedMultiValueMap(5);
        headers.add((Object)"Cache-Control", (Object)"no-cache, no-store, must-revalidate");
        headers.add((Object)"Allow", (Object)"GET");
        return new ResponseEntity((Object)json, (MultiValueMap)headers, HttpStatus.OK);
    }

    private String serializeMetricView(SetMetric metricData) throws IOException {
        UserSetLdSerializer serializer = new UserSetLdSerializer();
        return serializer.serialize(metricData);
    }
}

