/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.set.web.service.controller.jsonld;

import eu.europeana.api.commons.definitions.exception.ApiWriteLockException;
import eu.europeana.api.commons.nosql.entity.ApiWriteLock;
import eu.europeana.api.commons.nosql.service.ApiWriteLockService;
import eu.europeana.api.commons.web.exception.HttpException;
import eu.europeana.api2.utils.JsonWebUtils;
import eu.europeana.set.web.exception.request.RequestValidationException;
import eu.europeana.set.web.model.SetOperationResponse;
import eu.europeana.set.web.service.controller.BaseRest;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Hidden
@Tag(name="Set Admin Rest")
public class AdminRest
extends BaseRest {
    Logger adminLogger = LogManager.getLogger(this.getClass());
    @Resource(name="set_db_apilockService")
    private ApiWriteLockService writeLockService;

    public ApiWriteLockService getApiWriteLockService() {
        return this.writeLockService;
    }

    @PostMapping(value={"/set/admin/lock"}, produces={"application/json;charset=utf-8", "application/ld+json;charset=utf-8"})
    @Operation(description="Lock write operations. Authorization required.", summary="Lock Write Operations")
    public ResponseEntity<String> lockWriteOperations(HttpServletRequest request) throws HttpException, ApiWriteLockException {
        this.verifyWriteAccess("write_lock", request);
        ApiWriteLock activeLock = this.getApiWriteLockService().lock("lockWriteOperations");
        boolean isLocked = this.isLocked(activeLock);
        SetOperationResponse response = new SetOperationResponse("admin", "/set/admin/lock");
        response.setStatus(isLocked ? "Server is now locked for changes" : "Unable to set lock");
        response.success = isLocked;
        if (activeLock != null) {
            response.setSince(activeLock.getStarted());
        }
        if (this.adminLogger.isInfoEnabled()) {
            this.adminLogger.info("Lock write operations result: {}", (Object)response.getStatus());
        }
        String jsonStr = JsonWebUtils.toJson((Object)response);
        HttpStatus httpStatus = response.success ? HttpStatus.OK : HttpStatus.INTERNAL_SERVER_ERROR;
        return this.buildResponse(jsonStr, httpStatus);
    }

    private boolean isLocked(ApiWriteLock activeLock) {
        return activeLock != null && activeLock.getStarted() != null && activeLock.getEnded() == null;
    }

    @DeleteMapping(value={"/set/admin/lock"}, produces={"application/json;charset=utf-8", "application/ld+json;charset=utf-8"})
    @Operation(summary="Unlock write operations")
    public ResponseEntity<String> unlockWriteOperations(HttpServletRequest request) throws HttpException, ApiWriteLockException {
        this.verifyWriteAccess("write_unlock", request);
        SetOperationResponse response = new SetOperationResponse("admin", "/set/admin/lock");
        ApiWriteLock activeLock = this.getApiWriteLockService().getLastActiveLock("lockWriteOperations");
        if (activeLock != null && activeLock.getEnded() == null && "lockWriteOperations".equals(activeLock.getName())) {
            this.getApiWriteLockService().unlock(activeLock);
            ApiWriteLock lock = this.getApiWriteLockService().getLastActiveLock("lockWriteOperations");
            if (lock == null) {
                response.setStatus("Server is now unlocked for changes");
                response.success = true;
                response.setSince(activeLock.getStarted());
                response.setEnd(activeLock.getEnded());
            } else {
                response.setStatus("Unlocking write operations failed");
                response.success = false;
            }
        } else {
            throw new RequestValidationException("error.userset_lock_not_in_effect", new String[0]);
        }
        if (this.adminLogger.isInfoEnabled()) {
            this.adminLogger.info("Unlock write operations result: {}", (Object)response.getStatus());
        }
        String jsonStr = JsonWebUtils.toJson((Object)response);
        HttpStatus httpStatus = response.success ? HttpStatus.OK : HttpStatus.INTERNAL_SERVER_ERROR;
        return this.buildResponse(jsonStr, httpStatus);
    }
}

