/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.set.web.service.controller.exception;

import eu.europeana.api.commons.config.i18n.I18nService;
import eu.europeana.api.commons.error.EuropeanaApiErrorResponse;
import eu.europeana.api.commons.web.exception.EuropeanaGlobalExceptionHandler;
import eu.europeana.set.web.service.RequestPathMethodService;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class GlobalExceptionHandler
extends EuropeanaGlobalExceptionHandler {
    I18nService i18nService;

    @Autowired
    public GlobalExceptionHandler(RequestPathMethodService requestPathMethodService, @Qualifier(value="i18nService") I18nService i18nService) {
        this.requestPathMethodService = requestPathMethodService;
        this.i18nService = i18nService;
    }

    protected I18nService getI18nService() {
        return this.i18nService;
    }

    @ExceptionHandler
    public ResponseEntity<EuropeanaApiErrorResponse> handleRequestBodyNotParsableError(HttpMessageNotReadableException e, HttpServletRequest httpRequest) {
        HttpStatus responseStatus = HttpStatus.BAD_REQUEST;
        EuropeanaApiErrorResponse response = new EuropeanaApiErrorResponse.Builder(httpRequest, (Exception)e, this.stackTraceEnabled()).setStatus(responseStatus.value()).setError(responseStatus.getReasonPhrase()).setMessage("Invalid request body: " + e.getMessage()).setSeeAlso(this.getSeeAlso()).build();
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)responseStatus).headers(this.createHttpHeaders(httpRequest))).body((Object)response);
    }
}

