/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.set.web.service.controller;

import eu.europeana.api.commons.exception.AuthorizationExtractionException;
import eu.europeana.api.commons.web.controller.BaseRestController;
import eu.europeana.api.commons.web.exception.ApplicationAuthenticationException;
import eu.europeana.api.commons.web.exception.HttpException;
import eu.europeana.api.commons.web.exception.ParamValidationException;
import eu.europeana.set.definitions.config.UserSetConfiguration;
import eu.europeana.set.definitions.exception.UserSetProfileValidationException;
import eu.europeana.set.definitions.model.UserSet;
import eu.europeana.set.definitions.model.vocabulary.SetPageProfile;
import eu.europeana.set.definitions.model.vocabulary.SetProfileHelper;
import eu.europeana.set.definitions.model.vocabulary.SetResourceProfile;
import eu.europeana.set.stats.service.UsageStatsService;
import eu.europeana.set.web.model.search.CollectionPage;
import eu.europeana.set.web.search.UserSetLdSerializer;
import eu.europeana.set.web.service.RequestPathMethodService;
import eu.europeana.set.web.service.UserSetService;
import eu.europeana.set.web.service.authorization.UserSetAuthorizationService;
import eu.europeana.set.web.service.authorization.UserSetAuthorizationServiceImpl;
import eu.europeana.set.web.service.authorization.UserSetAuthorizationUtils;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.info.BuildProperties;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class BaseRest
extends BaseRestController {
    @Resource
    UserSetConfiguration configuration;
    @Resource
    private UserSetService userSetService;
    @Resource
    UserSetAuthorizationService authorizationService;
    @Resource
    UsageStatsService usageStatsService;
    @Resource
    protected BuildProperties buildInfo;
    @Resource
    private RequestPathMethodService requestMethodService;
    SetProfileHelper profileHelper = new SetProfileHelper();
    Logger logger = LogManager.getLogger(this.getClass());

    @PostConstruct
    void started() {
        TimeZone.setDefault(TimeZone.getTimeZone("Etc/UTC"));
    }

    public Logger getLogger() {
        return this.logger;
    }

    protected UserSetConfiguration getConfiguration() {
        return this.configuration;
    }

    protected UserSetService getUserSetService() {
        return this.userSetService;
    }

    public void setUserSetService(UserSetService userSetService) {
        this.userSetService = userSetService;
    }

    public void setConfiguration(UserSetConfiguration configuration) {
        this.configuration = configuration;
    }

    public UserSetAuthorizationService getAuthorizationService() {
        return this.authorizationService;
    }

    protected UsageStatsService getUsageStatsService() {
        return this.usageStatsService;
    }

    public void setAuthorizationService(UserSetAuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    public String toResourceId(String collection, String object) {
        return "/" + collection + "/" + object;
    }

    protected List<SetPageProfile> getProfilesFromRequest(String profile, HttpServletRequest request) throws ParamValidationException {
        String preferHeader = request.getHeader("Prefer");
        if (preferHeader != null && this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("'Prefer' header value: {} ", (Object)preferHeader);
        }
        List profiles = null;
        try {
            profiles = this.getProfileHelper().getSetPageProfiles(profile, preferHeader);
        }
        catch (UserSetProfileValidationException e) {
            if (StringUtils.isNotEmpty((CharSequence)preferHeader)) {
                throw new ParamValidationException("error.userset_invalid_header_value", "error.userset_invalid_header_value", new String[]{"Prefer", preferHeader}, (Throwable)e);
            }
            throw new ParamValidationException("error.invalid_param_value", "error.invalid_param_value", new String[]{"profile", profile}, (Throwable)e);
        }
        return profiles;
    }

    protected void validateMultipleProfiles(List<SetPageProfile> profiles, String profileStr) throws HttpException {
        if (profiles.size() > 2) {
            throw new ParamValidationException("error.invalid_param_value", "error.invalid_param_value", new String[]{"Only one of these should be provided ", StringUtils.remove((String)profileStr, (String)SetPageProfile.FACETS.getProfileParamValue())});
        }
        if (profiles.size() == 2 && !profiles.contains(SetPageProfile.FACETS)) {
            throw new ParamValidationException("error.invalid_param_value", "error.invalid_param_value", new String[]{"These profiles are not supported together ", profileStr});
        }
    }

    protected String serializeUserSet(SetPageProfile profile, UserSet storedUserSet) throws IOException {
        this.getUserSetService().applyProfile(storedUserSet, profile);
        UserSetLdSerializer serializer = new UserSetLdSerializer();
        return serializer.serialize(storedUserSet);
    }

    protected String serializeUserSet(SetResourceProfile profile, UserSet storedUserSet) throws IOException {
        this.getUserSetService().applyProfile(storedUserSet, profile);
        UserSetLdSerializer serializer = new UserSetLdSerializer();
        return serializer.serialize(storedUserSet);
    }

    protected String serializeCollectionPage(CollectionPage itemPage) throws IOException {
        UserSetLdSerializer serializer = new UserSetLdSerializer();
        return serializer.serialize(itemPage);
    }

    public Map<String, String> parsePreferHeader(String preferHeader) {
        String[] headerParts = null;
        String[] contentParts = null;
        int keyPos = 0;
        int valuePos = 1;
        HashMap<String, String> resMap = new HashMap<String, String>(3);
        for (String headerPart : headerParts = preferHeader.split(";")) {
            contentParts = headerPart.split("=");
            if (contentParts.length != 2) continue;
            resMap.put(contentParts[keyPos], contentParts[valuePos]);
        }
        return resMap;
    }

    public String getApiVersion() {
        return this.buildInfo.getVersion();
    }

    protected ResponseEntity<String> buildResponseEntity(UserSet storedUserSet, SetResourceProfile profile, HttpStatus responseStatus, Map<String, String> additionalHeaders, HttpServletRequest request) throws IOException {
        String serializedUserSetJsonLdStr = this.serializeUserSet(profile, storedUserSet);
        String etag = this.generateETag(storedUserSet.getModified(), "jsonld", this.getApiVersion());
        LinkedMultiValueMap headers = new LinkedMultiValueMap(5);
        headers.add((Object)"Link", (Object)"<http://www.w3.org/ns/ldp#BasicContainer>; rel=\"type\"");
        headers.add((Object)"Link", (Object)"<http://www.w3.org/ns/ldp#Resource>; rel=\"type\"");
        headers.add((Object)"Allow", (Object)this.createAllowHeader(request));
        if (additionalHeaders != null) {
            for (Map.Entry<String, String> entry : additionalHeaders.entrySet()) {
                headers.add((Object)entry.getKey(), (Object)entry.getValue());
            }
        }
        headers.add((Object)"ETag", (Object)etag);
        return new ResponseEntity((Object)serializedUserSetJsonLdStr, (MultiValueMap)headers, responseStatus);
    }

    protected ResponseEntity<String> buildSetPageResponse(CollectionPage setPage, Date modified, SetPageProfile profile, HttpServletRequest request) throws IOException, HttpException {
        String jsonBody = "";
        jsonBody = this.serializeCollectionPage(setPage);
        String etag = this.generateETag(modified, "jsonld", this.getApiVersion());
        LinkedMultiValueMap headers = new LinkedMultiValueMap(7);
        headers.add((Object)"Link", (Object)"<http://www.w3.org/ns/ldp#BasicContainer>; rel=\"type\"");
        headers.add((Object)"Link", (Object)"<http://www.w3.org/ns/ldp#Resource>; rel=\"type\"");
        headers.add((Object)"Allow", (Object)this.createAllowHeader(request));
        headers.add((Object)"Vary", (Object)"Prefer");
        headers.add((Object)"Preference-Applied", (Object)profile.getPreferenceApplied());
        headers.add((Object)"ETag", (Object)etag);
        return new ResponseEntity((Object)jsonBody, (MultiValueMap)headers, HttpStatus.OK);
    }

    protected boolean isSetResourceRequestResponse(Object pageNr) {
        return pageNr == null;
    }

    public Authentication verifyWriteAccess(String operation, HttpServletRequest request) throws ApplicationAuthenticationException {
        this.getAuthorizationService().checkWriteLockInEffect(operation);
        Authentication auth = null;
        auth = this.getConfiguration().isAuthEnabled() ? super.verifyWriteAccess(operation, request) : this.authorizeByPlainTextToken(operation, request);
        return auth;
    }

    private Authentication authorizeByPlainTextToken(String operation, HttpServletRequest request) throws ApplicationAuthenticationException {
        Authentication auth = null;
        try {
            auth = UserSetAuthorizationUtils.createAuthentication((String)request.getHeader("Authorization"));
            auth = ((UserSetAuthorizationServiceImpl)this.getAuthorizationService()).checkPermissions(auth, operation);
        }
        catch (AuthorizationExtractionException e) {
            throw new ApplicationAuthenticationException("Authentication error: " + e.getMessage(), "error.operation_not_authorized", new String[]{operation}, HttpStatus.UNAUTHORIZED, (Throwable)e);
        }
        return auth;
    }

    public Authentication verifyReadAccess(HttpServletRequest request) throws ApplicationAuthenticationException {
        boolean hasToken;
        boolean bl = hasToken = request.getHeader("Authorization") != null;
        if (this.getConfiguration().isAuthEnabled() || !hasToken) {
            return super.verifyReadAccess(request);
        }
        return this.authorizeByPlainTextToken("retrieve", request);
    }

    protected ResponseEntity<String> buildResponse(String jsonStr, HttpStatus httpStatus) {
        LinkedMultiValueMap headers = new LinkedMultiValueMap(5);
        headers.add((Object)"Vary", (Object)"Accept");
        headers.add((Object)"ETag", (Object)Integer.toString(this.hashCode()));
        headers.add((Object)"Allow", (Object)"POST,DELETE");
        return new ResponseEntity((Object)jsonStr, (MultiValueMap)headers, httpStatus);
    }

    protected String createAllowHeader(HttpServletRequest request) {
        String allowHeaderValue;
        Optional methodsForRequestPattern = this.requestMethodService.getMethodsForRequestPattern(request);
        if (methodsForRequestPattern.isEmpty()) {
            this.logger.warn("Could not find other matching methods for {}. Using current request method in Allow header", (Object)request.getRequestURL());
            allowHeaderValue = request.getMethod();
        } else {
            allowHeaderValue = (String)methodsForRequestPattern.get();
        }
        return allowHeaderValue;
    }

    protected SetProfileHelper getProfileHelper() {
        return this.profileHelper;
    }
}

