/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.set.web.service;

import eu.europeana.api.commons.definitions.search.ResultSet;
import eu.europeana.api.commons.web.exception.ApplicationAuthenticationException;
import eu.europeana.api.commons.web.exception.HttpException;
import eu.europeana.api.commons.web.exception.ParamValidationException;
import eu.europeana.set.definitions.model.UserSet;
import eu.europeana.set.definitions.model.search.UserSetFacetQuery;
import eu.europeana.set.definitions.model.search.UserSetQuery;
import eu.europeana.set.definitions.model.vocabulary.SetPageProfile;
import eu.europeana.set.definitions.model.vocabulary.SetResourceProfile;
import eu.europeana.set.definitions.model.vocabulary.UserSetProfile;
import eu.europeana.set.mongo.model.internal.PersistentUserSet;
import eu.europeana.set.search.exception.SearchApiClientException;
import eu.europeana.set.search.service.SearchApiResponse;
import eu.europeana.set.web.exception.request.ItemValidationException;
import eu.europeana.set.web.exception.request.RequestBodyValidationException;
import eu.europeana.set.web.exception.response.UserSetNotFoundException;
import eu.europeana.set.web.model.WebResource;
import eu.europeana.set.web.model.search.BaseUserSetResultPage;
import eu.europeana.set.web.model.search.CollectionPage;
import eu.europeana.set.web.service.controller.exception.SetUniquenessValidationException;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.codehaus.jettison.json.JSONException;
import org.springframework.security.core.Authentication;

public interface UserSetService {
    public UserSet createUserSet(UserSet var1, Authentication var2) throws HttpException, IOException;

    public UserSet fetchUserSetItems(UserSet var1, String var2, String var3, int var4, int var5, SetPageProfile var6) throws HttpException, JSONException;

    public UserSet updateUserSet(PersistentUserSet var1, UserSet var2) throws HttpException;

    public UserSet getUserSetById(String var1) throws UserSetNotFoundException;

    public List<PersistentUserSet> getUserSetByCreatorId(String var1) throws UserSetNotFoundException;

    public UserSet parseUserSetLd(String var1) throws HttpException;

    public void validateWebUserSet(UserSet var1, boolean var2) throws RequestBodyValidationException, ParamValidationException, SetUniquenessValidationException, ItemValidationException;

    public void deleteUserSet(String var1) throws UserSetNotFoundException;

    public void deleteUserSets(String var1, List<PersistentUserSet> var2);

    public void removeItemDuplicates(UserSet var1);

    public UserSet insertItem(String var1, String var2, String var3, UserSet var4) throws ApplicationAuthenticationException, ItemValidationException;

    public UserSet insertMultipleItems(List<String> var1, String var2, int var3, UserSet var4) throws ItemValidationException;

    public UserSet deleteItem(String var1, UserSet var2);

    public UserSet deleteMultipleItems(List<String> var1, UserSet var2) throws ItemValidationException;

    public ResultSet<? extends UserSet> search(UserSetQuery var1, UserSetFacetQuery var2, List<SetPageProfile> var3, Authentication var4);

    public BaseUserSetResultPage<?> buildResultsPage(UserSetQuery var1, ResultSet<? extends UserSet> var2, String var3, String var4, List<SetPageProfile> var5, Authentication var6) throws HttpException;

    public BaseUserSetResultPage<String> buildRecodsResultsPage(String var1, List<String> var2, int var3, int var4, SetPageProfile var5, HttpServletRequest var6) throws HttpException;

    public CollectionPage buildCollectionPage(UserSet var1, UserSetProfile var2, int var3, int var4, HttpServletRequest var5) throws HttpException;

    public UserSet verifyOwnerOrAdmin(UserSet var1, Authentication var2, boolean var3) throws HttpException;

    public boolean isAdmin(Authentication var1);

    public boolean hasEditorRole(Authentication var1);

    public void verifyPermissionToUpdate(UserSet var1, Authentication var2, boolean var3) throws HttpException;

    public String getUserId(Authentication var1);

    public void applyProfile(UserSet var1, SetResourceProfile var2);

    public void applyProfile(UserSet var1, SetPageProfile var2);

    public SetPageProfile getProfileForPagination(List<SetPageProfile> var1);

    public List<PersistentUserSet> getEntitySetBestBetsItems(UserSetQuery var1);

    public String buildPageUrl(String var1, int var2, int var3, UserSetProfile var4);

    public UserSet publishUnpublishUserSet(String var1, Date var2, Authentication var3, boolean var4) throws HttpException;

    public void validateGallerySize(UserSet var1, int var2) throws ItemValidationException;

    public WebResource generateDepiction(UserSet var1) throws SearchApiClientException;

    public SearchApiResponse retrieveTotalForOpenSets(UserSet var1) throws ParamValidationException, RequestBodyValidationException;
}

