/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.set.web.search;

import eu.europeana.api.commons.definitions.utils.LanguageUtils;
import eu.europeana.api.commons.search.util.QueryBuilder;
import eu.europeana.api.commons.web.exception.ParamValidationException;
import eu.europeana.set.definitions.config.UserSetConfiguration;
import eu.europeana.set.definitions.model.search.UserSetFacetQuery;
import eu.europeana.set.definitions.model.search.UserSetQuery;
import eu.europeana.set.definitions.model.search.UserSetQueryImpl;
import eu.europeana.set.definitions.model.utils.UserSetUtils;
import eu.europeana.set.definitions.model.vocabulary.UserSetTypes;
import eu.europeana.set.definitions.model.vocabulary.VisibilityTypes;
import eu.europeana.set.web.exception.request.RequestValidationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class UserSetQueryBuilder
extends QueryBuilder {
    public static final String SEARCH_ALL = "*";
    public static final String SEARCH_ALL_ALL = "*:*";
    public static final String PREFIX_HTTP = "http";
    static Set<String> arrayFields = Set.of("item", "contributor", "subject", "creator", "visibility", "type", "collectionType", "set_id", "provider");
    static Set<String> nonArrayFields = Set.of("lang");
    static Set<String> facetsFields = Set.of("visibility", "item");
    static Set<String> suportedFields = new HashSet();

    private UserSetQuery buildSearchQuery(Map<String, Object> searchCriteria, String sort, int page, int pageSize, UserSetConfiguration config) throws ParamValidationException {
        UserSetQueryImpl searchQuery = new UserSetQueryImpl();
        searchQuery.setQuery(searchCriteria.toString());
        this.addVisibilityCriterion(searchCriteria, (UserSetQuery)searchQuery);
        this.addTypeCriterion(searchCriteria, (UserSetQuery)searchQuery);
        this.addCollectionTypeCriterion(searchCriteria, (UserSetQuery)searchQuery);
        this.addCreatorCriterion(searchCriteria, (UserSetQuery)searchQuery, config.getUserDataEndpoint());
        this.addContributorCriterion(searchCriteria, (UserSetQuery)searchQuery, config.getUserDataEndpoint());
        this.addProviderCriterion(searchCriteria, (UserSetQuery)searchQuery);
        this.addSubjectCriterion(searchCriteria, (UserSetQuery)searchQuery);
        this.addItemCriterion(searchCriteria, (UserSetQuery)searchQuery, config.getItemDataEndpoint());
        this.addSetIdCriterion(searchCriteria, (UserSetQuery)searchQuery);
        this.addFullTextCriterion(searchCriteria, (UserSetQuery)searchQuery);
        this.addTitleLangCriterion(searchCriteria, (UserSetQuery)searchQuery);
        this.addSortCriterion(searchCriteria, (UserSetQuery)searchQuery, sort);
        searchQuery.setPageSize(pageSize);
        searchQuery.setPageNr(page);
        return searchQuery;
    }

    private void addSortCriterion(Map<String, Object> searchCriteria, UserSetQuery searchQuery, String sort) throws ParamValidationException {
        if (sort != null && sort.contains("score") && !searchCriteria.containsKey("text")) {
            throw new ParamValidationException("error.invalid_param_value", "error.invalid_param_value", new String[]{"invalid value for the sort field, it cannot contain 'score' if the search is not on the text field", sort});
        }
        String[] sortCriteria = this.toArray(sort);
        if (sortCriteria != null) {
            for (String sortCriterion : sortCriteria) {
                if (!sortCriterion.contains("score") || !sortCriterion.contains("asc")) continue;
                throw new ParamValidationException("error.invalid_param_value", "error.invalid_param_value", new String[]{"invalid value for the sort field, it cannot contain 'score asc' since only the descending order is supported", sort});
            }
        }
        searchQuery.setSortCriteria(sortCriteria);
    }

    private void addTitleLangCriterion(Map<String, Object> searchCriteria, UserSetQuery searchQuery) throws ParamValidationException {
        if (searchCriteria.containsKey("lang")) {
            String lang = ((String)searchCriteria.get("lang")).toLowerCase(Locale.ENGLISH);
            if (!LanguageUtils.isIsoLanguage((String)lang)) {
                throw new ParamValidationException("error.invalid_param_value", "error.invalid_param_value", new String[]{"invalid value for search value for lang: field, language must be a 2-letter ISO Code", lang});
            }
            searchQuery.setTitleLang(lang);
        }
    }

    private void addFullTextCriterion(Map<String, Object> searchCriteria, UserSetQuery searchQuery) {
        if (searchCriteria.containsKey("text")) {
            String text = (String)searchCriteria.get("text");
            searchQuery.setText(text);
        }
    }

    private void addSetIdCriterion(Map<String, Object> searchCriteria, UserSetQuery searchQuery) throws ParamValidationException {
        if (searchCriteria.containsKey("set_id")) {
            List setId = (List)searchCriteria.get("set_id");
            for (String id : setId) {
                if (UserSetUtils.isInteger((String)id)) continue;
                throw new ParamValidationException("error.invalid_param_value", "error.invalid_param_value", new String[]{"set_id", id});
            }
            searchQuery.setSetId(setId);
        }
    }

    private void addItemCriterion(Map<String, Object> searchCriteria, UserSetQuery searchQuery, String itemDataEndpoint) {
        if (searchCriteria.containsKey("item")) {
            List items = (List)searchCriteria.get("item");
            for (int i = 0; i < items.size(); ++i) {
                if (((String)items.get(i)).startsWith("http")) continue;
                items.set(i, UserSetUtils.buildItemUrl((String)itemDataEndpoint, (String)((String)items.get(i))));
            }
            searchQuery.setItem(items);
        }
    }

    private void addSubjectCriterion(Map<String, Object> searchCriteria, UserSetQuery searchQuery) throws ParamValidationException {
        if (searchCriteria.containsKey("subject")) {
            List subjects = (List)searchCriteria.get("subject");
            for (String subj : subjects) {
                if (subj.startsWith("http")) continue;
                throw new ParamValidationException("error.invalid_param_value", "error.invalid_param_value", new String[]{"invalid value for search field, subject must be a URI", subj});
            }
            searchQuery.setSubject(subjects);
        }
    }

    private void addContributorCriterion(Map<String, Object> searchCriteria, UserSetQuery searchQuery, String userDataEndpoint) {
        if (searchCriteria.containsKey("contributor")) {
            List contributorId = (List)searchCriteria.get("contributor");
            for (int i = 0; i < contributorId.size(); ++i) {
                if (((String)contributorId.get(i)).startsWith("http")) continue;
                contributorId.set(i, UserSetUtils.buildUserUri((String)userDataEndpoint, (String)((String)contributorId.get(i))));
            }
            searchQuery.setContributor(contributorId);
        }
    }

    private void addCreatorCriterion(Map<String, Object> searchCriteria, UserSetQuery searchQuery, String userDataEndpoint) {
        if (searchCriteria.containsKey("creator")) {
            List creatorId = (List)searchCriteria.get("creator");
            for (int i = 0; i < creatorId.size(); ++i) {
                if (((String)creatorId.get(i)).startsWith("http")) continue;
                creatorId.set(i, UserSetUtils.buildUserUri((String)userDataEndpoint, (String)((String)creatorId.get(i))));
            }
            searchQuery.setCreator(creatorId);
        }
    }

    private void addProviderCriterion(Map<String, Object> searchCriteria, UserSetQuery searchQuery) throws ParamValidationException {
        if (searchCriteria.containsKey("provider")) {
            List providerId = (List)searchCriteria.get("provider");
            for (String prov : providerId) {
                if (prov.startsWith("http")) continue;
                throw new ParamValidationException("error.invalid_param_value", "error.invalid_param_value", new String[]{"invalid value for search field, provider (id) must be a URI", prov});
            }
            searchQuery.setProvider(providerId);
        }
    }

    private void addTypeCriterion(Map<String, Object> searchCriteria, UserSetQuery searchQuery) throws ParamValidationException {
        if (searchCriteria.containsKey("type")) {
            List type = (List)searchCriteria.get("type");
            for (String el : type) {
                if (UserSetTypes.isValid((String)el)) continue;
                throw new ParamValidationException("error.invalid_param_value", "error.invalid_param_value", new String[]{"invalid value for the type field: ", el});
            }
            searchQuery.setType(type);
        }
    }

    private void addCollectionTypeCriterion(Map<String, Object> searchCriteria, UserSetQuery searchQuery) throws ParamValidationException {
        if (searchCriteria.containsKey("collectionType")) {
            List collectionType = (List)searchCriteria.get("collectionType");
            for (String el : collectionType) {
                if ("Gallery".equals(el)) continue;
                throw new ParamValidationException("error.invalid_param_value", "error.invalid_param_value", new String[]{"invalid value for the collectionType field: ", el});
            }
            searchQuery.setCollectionType(collectionType);
        }
    }

    private void addVisibilityCriterion(Map<String, Object> searchCriteria, UserSetQuery searchQuery) throws ParamValidationException {
        if (searchCriteria.containsKey("visibility")) {
            List visibility = (List)searchCriteria.get("visibility");
            for (String visib : visibility) {
                if (VisibilityTypes.isValid((String)visib)) continue;
                throw new ParamValidationException("error.invalid_param_value", "error.invalid_param_value", new String[]{"invalid value for the visibility field: ", visib});
            }
            searchQuery.setVisibility(visibility);
        }
    }

    public UserSetQuery buildUserSetQuery(String query, String[] qf, String sort, int page, int pageSize, UserSetConfiguration config) throws ParamValidationException {
        HashMap criteria = new HashMap();
        this.parseSearchCriteria(criteria, query, qf);
        return this.buildSearchQuery(criteria, sort, page, pageSize, config);
    }

    private void parseSearchCriteria(Map<String, Object> criteria, String query, String[] qf) throws ParamValidationException {
        boolean searchAllQuery = UserSetQueryBuilder.isSearchAllQuery((String)query);
        if (!searchAllQuery) {
            this.parseCriterion(criteria, query);
        }
        if (qf != null) {
            for (String criterion : qf) {
                this.parseCriterion(criteria, criterion);
            }
        }
    }

    public static boolean isSearchAllQuery(String query) {
        return "*".equals(query) || "*:*".equals(query);
    }

    private void parseCriterion(Map<String, Object> criteria, String criterion) throws ParamValidationException {
        String toParse = criterion;
        String separator = ":";
        String space = " ";
        if (!toParse.isEmpty() && !toParse.contains(separator)) {
            criteria.put("text", toParse);
        }
        while (toParse.contains(separator)) {
            String value;
            String field = StringUtils.substringBefore((String)toParse, (String)separator).trim();
            toParse = StringUtils.substringAfter((String)toParse, (String)separator).trim();
            if (!suportedFields.contains(field)) {
                throw new ParamValidationException("error.invalid_param_value", "error.invalid_param_value", new String[]{"invalid field name in search query", field});
            }
            if (!toParse.contains(separator) || toParse.startsWith("http")) {
                value = toParse;
                toParse = "";
            } else {
                value = StringUtils.substringBefore((String)toParse, (String)separator).trim();
                if (!value.contains(space)) {
                    throw new ParamValidationException("error.invalid_param_value", "error.invalid_param_value", new String[]{"invalid formatting of search query for field " + field, value});
                }
                value = StringUtils.substringBeforeLast((String)toParse, (String)space);
                toParse = StringUtils.removeStart((String)toParse, (String)value);
            }
            if (StringUtils.isBlank((CharSequence)value) || !value.startsWith("http") && value.contains(separator)) {
                throw new ParamValidationException("error.invalid_param_value", "error.invalid_param_value", new String[]{"invalid formatting of search query for field " + field, value});
            }
            this.addCriterionToOthers(field, value, criteria);
        }
    }

    private void addCriterionToOthers(String field, String value, Map<String, Object> criteria) {
        if (arrayFields.contains(field)) {
            if (criteria.containsKey(field)) {
                List val = (List)criteria.get(field);
                val.add(value);
            } else {
                ArrayList<String> val = new ArrayList<String>();
                val.add(value);
                criteria.put(field, val);
            }
        } else {
            criteria.put(field, value);
        }
    }

    public UserSetFacetQuery buildUserSetFacetQuery(String facet, int facetLimit) throws RequestValidationException, ParamValidationException {
        if (facet == null || facet.isEmpty()) {
            throw new RequestValidationException("error.userset_validation_mandatory_property", new String[]{"facet (for facets profile)"});
        }
        this.validateFacetAndLimit(facet, facetLimit);
        return this.buildFacetQuery(facet, facetLimit);
    }

    private void validateFacetAndLimit(String facet, int facetLimit) throws ParamValidationException {
        if (facet.contains(",")) {
            throw new ParamValidationException("error.invalid_param_value", "error.invalid_param_value", new String[]{"multiple facet value is not supported ", facet});
        }
        if (!facetsFields.contains(facet)) {
            throw new ParamValidationException("error.invalid_param_value", "error.invalid_param_value", new String[]{"parameter value not supported in facets query ", facet});
        }
        if (facetLimit <= 0) {
            throw new ParamValidationException("error.invalid_param_value", "error.invalid_param_value", new String[]{"facet limit value needs to be positive ", String.valueOf(facetLimit)});
        }
    }

    private UserSetFacetQuery buildFacetQuery(String facet, int facetLimit) {
        if ("item".equals(facet)) {
            return new UserSetFacetQuery(facet, "type", UserSetTypes.BOOKMARKSFOLDER.getJsonValue(), true, "$items", facetLimit);
        }
        if ("visibility".equals(facet)) {
            return new UserSetFacetQuery(facet, null, null, false, "$visibility", facetLimit);
        }
        return null;
    }

    static {
        suportedFields.addAll(arrayFields);
        suportedFields.addAll(nonArrayFields);
    }
}

