/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.set.web.search;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.europeana.api.commons.definitions.statistics.set.SetMetric;
import eu.europeana.set.definitions.model.UserSet;
import eu.europeana.set.definitions.model.utils.UserSetUtils;
import eu.europeana.set.search.SearchApiRequest;
import eu.europeana.set.web.model.search.BaseUserSetResultPage;
import eu.europeana.set.web.model.search.CollectionPage;
import ioinformarics.oss.jackson.module.jsonld.JsonldModule;
import ioinformarics.oss.jackson.module.jsonld.JsonldResource;
import ioinformarics.oss.jackson.module.jsonld.JsonldResourceBuilder;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class UserSetLdSerializer {
    UserSetUtils userSetUtils = new UserSetUtils();
    ObjectMapper mapper = new ObjectMapper();
    JsonldResourceBuilder<UserSet> userSetResourceBuilder;
    JsonldResourceBuilder<BaseUserSetResultPage<?>> resultPageResourceBuilder;
    JsonldResourceBuilder<CollectionPage> collectionPageResourceBuilder;

    public UserSetUtils getUserSetUtils() {
        return this.userSetUtils;
    }

    public UserSetLdSerializer() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ENGLISH);
        this.mapper.setDateFormat((DateFormat)df);
    }

    public String serialize(UserSet userSet) throws IOException {
        this.mapper.registerModule((Module)new JsonldModule());
        return this.mapper.writer().writeValueAsString((Object)this.getUserSetResourceBuilder().build((Object)userSet));
    }

    public String serialize(BaseUserSetResultPage<?> resultsPage) throws IOException {
        this.mapper.registerModule((Module)new JsonldModule());
        return this.mapper.writer().writeValueAsString((Object)this.getResultPageResourceBuilder().build(resultsPage));
    }

    public String serialize(SetMetric metricData) throws IOException {
        this.mapper.registerModule((Module)new JsonldModule());
        return this.mapper.writer().writeValueAsString((Object)metricData);
    }

    public String serialize(SearchApiRequest searchApiRequest) throws IOException {
        this.mapper.registerModule((Module)new JsonldModule());
        return this.mapper.writer().writeValueAsString((Object)searchApiRequest);
    }

    public String serialize(CollectionPage itemPage) throws IOException {
        this.mapper.registerModule((Module)new JsonldModule());
        return this.mapper.writer().writeValueAsString((Object)this.getCollectionPageResourceBuilder().build((Object)itemPage));
    }

    private JsonldResourceBuilder<CollectionPage> getCollectionPageResourceBuilder() {
        if (this.collectionPageResourceBuilder == null) {
            this.collectionPageResourceBuilder = JsonldResource.Builder.create();
            this.collectionPageResourceBuilder.context("https://api.europeana.eu/schema/context/set.jsonld");
        }
        return this.collectionPageResourceBuilder;
    }

    public JsonldResourceBuilder<UserSet> getUserSetResourceBuilder() {
        if (this.userSetResourceBuilder == null) {
            this.userSetResourceBuilder = JsonldResource.Builder.create();
            this.userSetResourceBuilder.context("https://api.europeana.eu/schema/context/set.jsonld");
        }
        return this.userSetResourceBuilder;
    }

    public JsonldResourceBuilder<BaseUserSetResultPage<?>> getResultPageResourceBuilder() {
        if (this.resultPageResourceBuilder == null) {
            this.resultPageResourceBuilder = JsonldResource.Builder.create();
            this.resultPageResourceBuilder.context("https://api.europeana.eu/schema/context/set.jsonld");
        }
        return this.resultPageResourceBuilder;
    }
}

