/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.set.web.model.search;

import eu.europeana.set.definitions.model.UserSet;
import eu.europeana.set.definitions.model.utils.UserSetUtils;
import eu.europeana.set.search.SearchApiRequest;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
public class SearchApiUtils {
    private static final SearchApiUtils instance = new SearchApiUtils();

    private SearchApiUtils() {
    }

    public static SearchApiUtils getInstance() {
        return instance;
    }

    public String buildSearchApiUrl(UserSet userSet, String apiKey, String searchUrl, String profile) {
        StringBuilder url = new StringBuilder();
        if (!userSet.isOpenSet()) {
            url.append(this.getBaseSearchUrl(searchUrl));
        } else {
            url.append(StringUtils.substringBefore((String)userSet.getIsDefinedBy(), (String)"?"));
        }
        url.append('?').append("wskey").append('=').append(apiKey);
        if (profile != null) {
            url.append('&').append("profile").append('=').append(profile);
        }
        return url.toString();
    }

    public String buildSearchApiUrlForItem(String baseSearchApiUrl, String baseItemUrl, String itemId, String apiKey, String profile) {
        StringBuilder url = new StringBuilder();
        url.append(this.getBaseSearchUrl(baseSearchApiUrl));
        url.append('?').append("wskey").append('=').append(apiKey);
        if (profile != null) {
            url.append('&').append("profile").append('=').append(profile);
        }
        String europeanaId = itemId.startsWith(baseItemUrl) ? UserSetUtils.extractItemIdentifier((String)itemId) : itemId;
        String searchQuery = "europeana_id:\"" + europeanaId + "\"";
        url.append("&query=").append(URLEncoder.encode(searchQuery, StandardCharsets.UTF_8));
        return url.toString();
    }

    public SearchApiRequest buildSearchApiPostBody(UserSet userSet, String itemDataEndpoint, String sort, String sortOrder, int pageNr, int pageSize, String profile) {
        if (userSet.isOpenSet()) {
            return this.buildSearchApiPostBodyForOpenSets(userSet, pageNr, pageSize, profile);
        }
        return this.buildSearchApiPostBodyForClosedSets(userSet, itemDataEndpoint, pageNr, pageSize, profile);
    }

    private SearchApiRequest buildSearchApiPostBodyForOpenSets(UserSet userSet, int pageNr, int pageSize, String profile) {
        SearchApiRequest searchApiRequest = new SearchApiRequest();
        Integer start = (pageNr - 1) * pageSize + 1;
        searchApiRequest.setStart(start.intValue());
        searchApiRequest.setRows(pageSize);
        MultiValueMap queryParams = SearchApiUtils.getQueryParamsFromUrl((String)userSet.getIsDefinedBy());
        searchApiRequest.setQuery((String)queryParams.getFirst((Object)"query"));
        List qf = (List)queryParams.get((Object)"qf");
        searchApiRequest.setQf(qf);
        searchApiRequest.setReusability((List)queryParams.get((Object)"reusability"));
        List sort = (List)queryParams.get((Object)"sort");
        searchApiRequest.setSort(sort);
        this.setProfile(searchApiRequest, profile);
        return searchApiRequest;
    }

    SearchApiRequest buildSearchApiPostBodyForClosedSets(UserSet userSet, String itemDataEndpoint, int pageNr, int pageSize, String profile) {
        List items = userSet.getItems();
        return this.buildSearchApiPostBodyForItemIds(items, itemDataEndpoint, pageNr, pageSize, profile);
    }

    public SearchApiRequest buildSearchApiPostBodyForItemIds(List<String> items, String itemDataEndpoint, int pageNr, int pageSize, String profile) {
        SearchApiRequest searchApiRequest = new SearchApiRequest();
        Integer start = (pageNr - 1) * pageSize;
        Integer end = Math.min(start + pageSize, items.size());
        StringBuilder query = new StringBuilder(100);
        query.append("europeana_id:(");
        for (int i = start.intValue(); i < end; ++i) {
            String fullId = items.get(i);
            if (i != start) {
                query.append(" OR ");
            }
            String id = fullId.replace(itemDataEndpoint, "");
            query.append('\"').append('/').append(id).append('\"');
        }
        query.append(')');
        searchApiRequest.setQuery(query.toString());
        searchApiRequest.setRows(pageSize);
        this.setProfile(searchApiRequest, profile);
        return searchApiRequest;
    }

    private void setProfile(SearchApiRequest searchApiRequest, String profile) {
        if (!StringUtils.isEmpty((CharSequence)profile)) {
            String[] searchApiProfile = profile.split(",");
            searchApiRequest.setProfile(List.of(searchApiProfile));
        }
    }

    public String getBaseSearchUrl(String searchUrl) {
        String res = searchUrl;
        int endPos = searchUrl.indexOf(63);
        if (endPos >= 0) {
            res = searchUrl.substring(0, endPos);
        }
        return res;
    }

    public static MultiValueMap<String, String> getQueryParamsFromUrl(String url) {
        String decodedUrl = URLDecoder.decode(url, StandardCharsets.UTF_8);
        return UriComponentsBuilder.fromUriString((String)decodedUrl).build().getQueryParams();
    }
}

