/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.set.web.model.search;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import eu.europeana.api.commons.definitions.search.FacetFieldView;
import eu.europeana.set.web.model.search.FacetValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@JsonPropertyOrder(value={"type", "field", "values"})
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class FacetFieldViewImpl
implements FacetFieldView {
    private String type = "facet";
    private String field;
    @JsonIgnore
    private Map<String, Long> valueCountMap;
    private List<FacetValue> facetValues;

    public FacetFieldViewImpl(String field, Map<String, Long> valueCountMap) {
        this.field = field;
        this.valueCountMap = valueCountMap;
        if (valueCountMap != null && !valueCountMap.isEmpty()) {
            this.facetValues = new ArrayList(valueCountMap.size());
            for (Map.Entry<String, Long> entry : valueCountMap.entrySet()) {
                this.facetValues.add(new FacetValue(entry.getKey(), entry.getValue().longValue()));
            }
        }
    }

    @JsonGetter(value="field")
    public String getName() {
        return this.field;
    }

    public Map<String, Long> getValueCountMap() {
        return this.valueCountMap;
    }

    @JsonGetter(value="type")
    String getType() {
        return this.type;
    }

    @JsonGetter(value="values")
    public List<FacetValue> facetValues() {
        return this.facetValues;
    }
}

