/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.set.web.config;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class WebMvcConfig
implements WebMvcConfigurer {
    private static final long MAX_AGE = 600L;
    List<MediaType> supportedMediaTypes = new ArrayList();
    Map<String, MediaType> mediaTypesMaping = new HashMap();
    private static final MediaType APPLICATION_JSONLD = new MediaType("application", "ld+json");
    private static final String EXTENSION_JSONLD = "jsonld";
    private static final String EXTENSION_JSON = "json";

    public void addCorsMappings(CorsRegistry registry) {
        String get = "GET";
        String post = "POST";
        String delete = "DELETE";
        String put = "PUT";
        registry.addMapping("/v3/api-docs").allowedOrigins(new String[]{"*"}).allowedMethods(new String[]{"GET"}).exposedHeaders(new String[]{"Access-Control-Allow-Origin", "Access-Control-Allow-Headers"}).allowCredentials(false).maxAge(600L);
        registry.addMapping("/v3/api-docs/**").allowedOrigins(new String[]{"*"}).allowedMethods(new String[]{"GET"}).exposedHeaders(new String[]{"Access-Control-Allow-Origin", "Access-Control-Allow-Headers"}).allowCredentials(false).maxAge(600L);
        registry.addMapping("/actuator/**").allowedOrigins(new String[]{"*"}).allowedMethods(new String[]{"GET"}).exposedHeaders(new String[]{"Access-Control-Allow-Origin", "Access-Control-Allow-Headers"}).allowCredentials(false).maxAge(600L);
        registry.addMapping("/set/").allowedOrigins(new String[]{"*"}).allowedMethods(new String[]{"POST", "DELETE"}).exposedHeaders(new String[]{"Access-Control-Allow-Headers", "Access-Control-Allow-Origin", "Allow", "Link", "ETag", "Vary", "Cache-Control", "Preference-Applied"}).allowCredentials(false).maxAge(600L);
        registry.addMapping("/set/*").allowedOrigins(new String[]{"*"}).allowedMethods(new String[]{"GET", "PUT", "DELETE"}).exposedHeaders(new String[]{"Access-Control-Allow-Origin", "Access-Control-Allow-Headers", "Allow", "Link", "ETag", "Vary", "Preference-Applied"}).allowCredentials(false).maxAge(600L);
        registry.addMapping("/set/admin/lock").allowedOrigins(new String[]{"*"}).allowedMethods(new String[]{"POST", "DELETE"}).exposedHeaders(new String[]{"Access-Control-Allow-Origin", "Access-Control-Allow-Headers", "Allow"}).allowCredentials(false).maxAge(600L);
        registry.addMapping("/set/*/items").allowedOrigins(new String[]{"*"}).allowedMethods(new String[]{"PUT", "DELETE"}).exposedHeaders(new String[]{"Access-Control-Allow-Origin", "Access-Control-Allow-Headers", "Allow", "ETag", "Vary", "Preference-Applied"}).allowCredentials(false).maxAge(600L);
        registry.addMapping("/set/*/search").allowedOrigins(new String[]{"*"}).allowedMethods(new String[]{"GET"}).exposedHeaders(new String[]{"Access-Control-Allow-Origin", "Access-Control-Allow-Headers", "Allow", "ETag", "Vary", "Preference-Applied"}).allowCredentials(false).maxAge(600L);
        registry.addMapping("/set/*/*").allowedOrigins(new String[]{"*"}).allowedMethods(new String[]{"PUT"}).exposedHeaders(new String[]{"Access-Control-Allow-Origin", "Access-Control-Allow-Headers", "Allow", "ETag", "Vary", "Preference-Applied"}).allowCredentials(false).maxAge(600L);
        registry.addMapping("/set/*/*/*").allowedOrigins(new String[]{"*"}).allowedMethods(new String[]{"GET", "HEAD", "PUT", "DELETE"}).exposedHeaders(new String[]{"Access-Control-Allow-Origin", "Access-Control-Allow-Headers", "Allow", "Preference-Applied"}).allowCredentials(false).maxAge(600L);
    }

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        configurer.favorPathExtension(true);
        configurer.useRegisteredExtensionsOnly(true);
        configurer.mediaTypes(this.getMediaTypesMapping());
        configurer.defaultContentType(new MediaType[]{APPLICATION_JSONLD, MediaType.APPLICATION_JSON});
    }

    private Map<String, MediaType> getMediaTypesMapping() {
        if (this.mediaTypesMaping.isEmpty()) {
            for (MediaType mediaType : this.getSupportedMediaTypes()) {
                if (APPLICATION_JSONLD.equals((Object)mediaType)) {
                    this.mediaTypesMaping.put(EXTENSION_JSONLD, mediaType);
                    this.mediaTypesMaping.put(EXTENSION_JSON, mediaType);
                    continue;
                }
                if (MediaType.APPLICATION_JSON.equals((Object)mediaType)) continue;
                this.mediaTypesMaping.put(mediaType.getSubtype(), mediaType);
            }
        }
        return this.mediaTypesMaping;
    }

    @Bean
    public HttpMessageConverter<String> getStringHttpMessageConverter() {
        StringHttpMessageConverter stringConverter = new StringHttpMessageConverter(StandardCharsets.UTF_8);
        stringConverter.setWriteAcceptCharset(false);
        stringConverter.setSupportedMediaTypes(this.getSupportedMediaTypes());
        return stringConverter;
    }

    private List<MediaType> getSupportedMediaTypes() {
        if (this.supportedMediaTypes.isEmpty()) {
            this.supportedMediaTypes.add(APPLICATION_JSONLD);
            this.supportedMediaTypes.add(MediaType.APPLICATION_JSON);
            this.supportedMediaTypes.add(MediaType.APPLICATION_XML);
            this.supportedMediaTypes.add(MediaType.TEXT_PLAIN);
            this.supportedMediaTypes.add(MediaType.TEXT_HTML);
        }
        return this.supportedMediaTypes;
    }
}

