/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.set.web.config;

import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.servers.Server;
import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import org.springframework.boot.info.BuildProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@OpenAPIDefinition(servers={@Server(url="/", description="Default Server URL")})
public class SpringDocConfig {
    private final BuildProperties buildProperties;

    public SpringDocConfig(BuildProperties buildProperties) {
        this.buildProperties = buildProperties;
    }

    @Bean
    public OpenAPI userServiceOpenAPI() {
        return new OpenAPI().info(new Info().title(this.buildProperties.getName()).description(this.buildProperties.get("build.project.description")).version(this.buildProperties.get("build.version")).contact(new Contact().name("API team").url("https://api.europeana.eu").email("api@europeana.eu")).termsOfService("https://www.europeana.eu/en/rights/api-terms-of-use").license(new License().name("EUPL 1.2").url("https://www.eupl.eu"))).externalDocs(new ExternalDocumentation().description("Documentation").url("https://pro.europeana.eu/page/intro#general"));
    }
}

