/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.set.web.config;

import com.mongodb.WriteConcern;
import dev.morphia.Datastore;
import eu.europeana.api.commons.nosql.entity.ApiWriteLockImpl;
import eu.europeana.corelib.db.wrapper.ApiMongoConnector;
import eu.europeana.set.mongo.model.PersistentUserSetImpl;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@EnableCaching
@PropertySource(value={"classpath:set.common.properties", "classpath:set.user.properties"}, ignoreResourceNotFound=true)
public class MongoConfig {
    @Value(value="${mongodb.set.connectionUrl:''}")
    private String mongoConnectionUrl;
    @Value(value="${mongodb.set.truststore:''}")
    private String mongoTrustStore;
    @Value(value="${mongodb.set.truststorepass:''}")
    private String mongoTrustStorePass;
    private static final String[] MODEL_PACKAGES = new String[]{PersistentUserSetImpl.class.getPackageName(), ApiWriteLockImpl.class.getPackageName()};
    private ApiMongoConnector mongoConnector;

    @Bean(value={"set_db_morphia_datastore_set"})
    public Datastore createDataStore() {
        Datastore ds = this.getMongoConnector().createDatastore(this.mongoConnectionUrl, this.mongoTrustStore, this.mongoTrustStorePass, -1, MODEL_PACKAGES);
        if (WriteConcern.MAJORITY != ds.getDefaultWriteConcern()) {
            ds.setDefaultWriteConcern(WriteConcern.MAJORITY);
        }
        return ds;
    }

    @Bean(value={"annotationMongoConnector"})
    protected ApiMongoConnector getMongoConnector() {
        if (this.mongoConnector == null) {
            this.mongoConnector = new ApiMongoConnector();
        }
        return this.mongoConnector;
    }
}

