/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.set.search.service.impl;

import eu.europeana.set.common.http.HttpConnection;
import eu.europeana.set.search.exception.SearchApiClientException;
import eu.europeana.set.search.service.SearchApiClient;
import eu.europeana.set.search.service.SearchApiResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class SearchApiClientImpl
implements SearchApiClient {
    Logger logger = LogManager.getLogger((String)this.getClass().getName());

    public HttpConnection createHttpConnection() {
        return new HttpConnection();
    }

    @Override
    public SearchApiResponse searchItems(String uri, String apiKey, boolean descriptions) throws SearchApiClientException {
        SearchApiResponse searchApiResponse = new SearchApiResponse(apiKey, null);
        JSONObject jo = this.searchItems(uri = this.appendApiKey(uri, apiKey));
        if (this.isSuccessfull(jo)) {
            List<String> res = descriptions ? this.extractItemDescriptions(jo) : this.extractItemIds(jo);
            int total = this.extractTotalResults(jo);
            searchApiResponse.setItems(res);
            searchApiResponse.setTotal(total);
        }
        return searchApiResponse;
    }

    private boolean isSuccessfull(JSONObject jo) {
        String keySuccess = "success";
        try {
            return jo.has(keySuccess) && jo.getBoolean(keySuccess);
        }
        catch (JSONException e) {
            this.logger.trace("Invalid Json Object", (Throwable)e);
            return false;
        }
    }

    private int extractTotalResults(JSONObject jo) throws SearchApiClientException {
        int total = -1;
        String key = "totalResults";
        try {
            if (jo.has(key)) {
                total = jo.getInt(key);
            }
        }
        catch (JSONException e) {
            throw new SearchApiClientException("Cannot extract total number of results!", e);
        }
        return total;
    }

    private String appendApiKey(String uri, String apiKey) {
        if (!((String)uri).contains("wskey=")) {
            uri = (String)uri + "&wskey=" + apiKey;
        }
        return uri;
    }

    protected List<String> extractItemIds(JSONObject jo) throws SearchApiClientException {
        try {
            JSONArray itemsArray = jo.getJSONArray("items");
            return this.extractItemsFromSearchResponse(itemsArray, "id");
        }
        catch (JSONException e) {
            throw new SearchApiClientException("Cannot parse search API response." + e.getMessage(), e);
        }
    }

    protected List<String> extractItemDescriptions(JSONObject jo) throws SearchApiClientException {
        ArrayList<String> list = new ArrayList<String>();
        if (jo == null) {
            return list;
        }
        try {
            JSONArray itemsArray = jo.getJSONArray("items");
            for (int i = 0; i < itemsArray.length(); ++i) {
                JSONObject itemAsJson = itemsArray.getJSONObject(i);
                list.add(itemAsJson.toString(4));
            }
            return list;
        }
        catch (JSONException e) {
            throw new SearchApiClientException("Cannot parse search API response." + e.getMessage(), e);
        }
    }

    protected List<String> extractItemsFromSearchResponse(JSONArray valueObject, String fieldName) throws SearchApiClientException {
        ArrayList<String> list = new ArrayList<String>();
        if (valueObject == null) {
            return list;
        }
        try {
            for (int i = 0; i < valueObject.length(); ++i) {
                JSONObject guidJson = valueObject.getJSONObject(i);
                String value = guidJson.getString(fieldName);
                if (list.contains(value)) continue;
                list.add(value);
            }
            return list;
        }
        catch (JSONException e) {
            throw new SearchApiClientException("Cannot parse search API response." + e.getMessage(), e);
        }
    }

    JSONObject searchItems(String uri) throws SearchApiClientException {
        try {
            String jsonResponse = this.createHttpConnection().getJsonResponse(uri);
            if (jsonResponse == null) {
                throw new SearchApiClientException("An error occured when retrieving items through search API. isDefinedBy might not be a valid API URL.", null);
            }
            return new JSONObject(jsonResponse);
        }
        catch (IOException e) {
            throw new SearchApiClientException("Cannot access search API to retrieve items of open set." + e.getMessage(), e);
        }
        catch (JSONException e) {
            throw new SearchApiClientException("Cannot parse search API response." + e.getMessage(), e);
        }
        catch (RuntimeException e) {
            throw new SearchApiClientException("Cannot retrieve items of open set." + e.getMessage(), e);
        }
    }

    @Override
    public SearchApiResponse searchItemDescriptions(String uri, String apiKey) throws SearchApiClientException {
        return this.searchItems(uri, apiKey, true);
    }
}

