/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.set.search.service.impl;

import eu.europeana.set.common.http.HttpConnection;
import eu.europeana.set.common.http.HttpResponseHandler;
import eu.europeana.set.definitions.model.BaseWebResource;
import eu.europeana.set.definitions.model.utils.UserSetUtils;
import eu.europeana.set.search.exception.SearchApiClientException;
import eu.europeana.set.search.service.SearchApiClient;
import eu.europeana.set.search.service.SearchApiResponse;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class SearchApiClientImpl
implements SearchApiClient {
    Logger logger = LogManager.getLogger((String)this.getClass().getName());

    public HttpConnection createHttpConnection() {
        return new HttpConnection();
    }

    @Override
    public SearchApiResponse searchItems(String uri, String serachPostBody, String apiKey, boolean descriptions) throws SearchApiClientException {
        SearchApiResponse searchApiResponse = new SearchApiResponse(apiKey, null);
        JSONObject jo = this.searchItems(uri = this.appendApiKey(uri, apiKey), serachPostBody);
        if (this.isSuccessfull(jo)) {
            List<String> res = descriptions ? this.extractItemDescriptions(jo) : this.extractItemIds(jo);
            int total = this.extractTotalResults(jo);
            searchApiResponse.setItems(res);
            searchApiResponse.setTotal(total);
        }
        return searchApiResponse;
    }

    private boolean isSuccessfull(JSONObject jo) {
        String keySuccess = "success";
        try {
            return jo.has(keySuccess) && jo.getBoolean(keySuccess);
        }
        catch (JSONException e) {
            this.logger.trace("Invalid Json Object", (Throwable)e);
            return false;
        }
    }

    private int extractTotalResults(JSONObject jo) throws SearchApiClientException {
        int total = -1;
        String key = "totalResults";
        try {
            if (jo.has(key)) {
                total = jo.getInt(key);
            }
        }
        catch (JSONException e) {
            throw new SearchApiClientException("Cannot extract total number of results!", e);
        }
        return total;
    }

    private String appendApiKey(String uri, String apiKey) {
        if (!((String)uri).contains("wskey=")) {
            uri = (String)uri + "&wskey=" + apiKey;
        }
        return uri;
    }

    protected List<String> extractItemIds(JSONObject jo) throws SearchApiClientException {
        try {
            JSONArray itemsArray = jo.getJSONArray("items");
            return this.extractItemsFromSearchResponse(itemsArray, "id");
        }
        catch (JSONException e) {
            throw new SearchApiClientException("Cannot parse search API response." + e.getMessage(), e);
        }
    }

    protected List<String> extractItemDescriptions(JSONObject jo) throws SearchApiClientException {
        ArrayList<String> list = new ArrayList<String>();
        if (jo == null) {
            return list;
        }
        try {
            JSONArray itemsArray = jo.getJSONArray("items");
            for (int i = 0; i < itemsArray.length(); ++i) {
                JSONObject itemAsJson = itemsArray.getJSONObject(i);
                list.add(itemAsJson.toString(4));
            }
            return list;
        }
        catch (JSONException e) {
            throw new SearchApiClientException("Cannot parse search API response." + e.getMessage(), e);
        }
    }

    protected List<String> extractItemsFromSearchResponse(JSONArray valueObject, String fieldName) throws SearchApiClientException {
        ArrayList<String> list = new ArrayList<String>();
        if (valueObject == null) {
            return list;
        }
        try {
            for (int i = 0; i < valueObject.length(); ++i) {
                JSONObject guidJson = valueObject.getJSONObject(i);
                String value = guidJson.getString(fieldName);
                if (list.contains(value)) continue;
                list.add(value);
            }
            return list;
        }
        catch (JSONException e) {
            throw new SearchApiClientException("Cannot parse search API response." + e.getMessage(), e);
        }
    }

    @Override
    public JSONObject searchItems(String uri, String postBody) throws SearchApiClientException {
        String responseBodyAsString = this.searchItemDescriptionsAsString(uri, postBody);
        try {
            return new JSONObject(responseBodyAsString);
        }
        catch (JSONException e) {
            throw new SearchApiClientException("Cannot parse search API response." + e.getMessage(), e);
        }
    }

    public String searchItemDescriptionsAsString(String url, String postBody) throws SearchApiClientException {
        try {
            HttpResponseHandler resp = postBody != null ? this.createHttpConnection().post(url, postBody, "application/json", null) : this.createHttpConnection().get(url, "application/json", null);
            if (resp == null) {
                throw new SearchApiClientException("An error occured when retrieving items through search API. isDefinedBy might not be a valid API URL.", null);
            }
            if (resp.getStatus() != 200) {
                throw new SearchApiClientException("Cannot retrieve items of user set. Response status: " + resp.getStatus() + " Response body: " + resp.getResponse(), null);
            }
            return resp.getResponse();
        }
        catch (IOException e) {
            throw new SearchApiClientException("Cannot access search API to retrieve items of user set." + e.getMessage(), e);
        }
        catch (RuntimeException e) {
            throw new SearchApiClientException("Cannot retrieve items of user set." + e.getMessage(), e);
        }
    }

    @Override
    public SearchApiResponse searchItemDescriptions(String uri, String searchPostBody, String apiKey) throws SearchApiClientException {
        return this.searchItems(uri, searchPostBody, apiKey, true);
    }

    @Override
    public void fillDepiction(String searchApiFullUrl, String searchPostBody, List<String> itemIds, String itemDataEndpoint, BaseWebResource depiction) throws SearchApiClientException {
        String firstFoundLocalId = null;
        String firstFoundItemlId = null;
        String searchResult = null;
        try {
            searchResult = this.searchItemDescriptionsAsString(searchApiFullUrl, searchPostBody);
            JSONArray itemsArray = new JSONObject(searchResult).getJSONArray("items");
            if (itemsArray == null || itemsArray.length() < 1) {
                return;
            }
            for (String itemId : itemIds) {
                String localId = UserSetUtils.extractItemIdentifier((String)itemId, (String)itemDataEndpoint);
                String recordIdJsonString = UserSetUtils.buildRecordIdJsonString((String)localId, (boolean)false, (boolean)false);
                if (!searchResult.contains(recordIdJsonString)) continue;
                firstFoundLocalId = localId;
                firstFoundItemlId = itemId;
                break;
            }
            if (firstFoundLocalId == null) {
                return;
            }
            for (int i = 0; i < itemsArray.length(); ++i) {
                JSONObject recordJsonObject = itemsArray.getJSONObject(i);
                if (!firstFoundLocalId.equals(recordJsonObject.getString("id"))) continue;
                this.fillDepictionFromRecord(firstFoundItemlId, recordJsonObject, depiction);
                break;
            }
        }
        catch (JSONException e) {
            throw new SearchApiClientException("Cannot extract depiction data from search Api response: " + searchResult, null);
        }
    }

    @Override
    public void fillDepiction(String searchApiFullUrl, String itemId, BaseWebResource depiction) throws SearchApiClientException {
        JSONObject searchResult = null;
        try {
            searchResult = this.searchItems(searchApiFullUrl, null);
            JSONArray items = searchResult.getJSONArray("items");
            if (items == null || items.length() < 1) {
                return;
            }
            this.fillDepictionFromRecord(itemId, items.getJSONObject(0), depiction);
        }
        catch (JSONException e) {
            throw new SearchApiClientException("Cannot extract depiction data from search Api response: " + String.valueOf(searchResult), null);
        }
    }

    private void fillDepictionFromRecord(String itemId, JSONObject recordJsonObject, BaseWebResource depiction) throws JSONException, SearchApiClientException {
        String thumbnail = recordJsonObject.getJSONArray("edmPreview").getString(0);
        String resourceId = this.getResourceId(thumbnail);
        depiction.setId(resourceId);
        depiction.setSource(itemId);
        depiction.setThumbnail(thumbnail);
    }

    private String getResourceId(String thumbnailUrl) throws SearchApiClientException {
        String queryString = StringUtils.substringAfter((String)thumbnailUrl, (String)"?");
        List params = URLEncodedUtils.parse((String)queryString, (Charset)StandardCharsets.UTF_8);
        for (NameValuePair param : params) {
            if (!"uri".equals(param.getName())) continue;
            return param.getValue();
        }
        throw new SearchApiClientException("Cannot extract resource id from thumbnail URL: " + thumbnailUrl, null);
    }
}

