/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.set.web.model;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.annotation.JsonSetter;
import dev.morphia.annotations.Transient;
import eu.europeana.set.definitions.model.BaseWebResource;
import eu.europeana.set.definitions.model.agent.Agent;
import eu.europeana.set.definitions.model.impl.Provider;
import eu.europeana.set.definitions.model.utils.UserSetUtils;
import eu.europeana.set.mongo.model.PersistentUserSetImpl;
import eu.europeana.set.web.model.PositiveIntegerFilter;
import eu.europeana.set.web.model.WebProvider;
import eu.europeana.set.web.model.WebResource;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.bson.types.ObjectId;

@JsonPropertyOrder(value={"id", "type", "collectionType", "title", "subject", "isShownBy", "description", "visibility", "isDefinedBy", "pinned", "items", "creator", "contributor", "provider", "created", "modified", "total", "next", "prev"})
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonIgnoreProperties(ignoreUnknown=true)
public class WebUserSetImpl
extends PersistentUserSetImpl {
    @Transient
    List<String> serializedItems;
    @Transient
    String baseUrl = "/set/";

    @Override
    @JsonProperty(value="items")
    public void setItems(List<String> items) {
        super.setItems(items);
    }

    @JsonProperty(value="items")
    @JsonRawValue
    public List<String> getSerializedItems() {
        return this.serializedItems;
    }

    @Override
    @JsonIgnore
    public List<String> getItems() {
        return super.getItems();
    }

    @JsonIgnore
    public void setSerializedItems(List<String> serializedItems) {
        this.serializedItems = serializedItems;
    }

    @Override
    @JsonIgnore
    public String getIdentifier() {
        return super.getIdentifier();
    }

    @Override
    @JsonProperty(value="type")
    public void setType(String type) {
        super.setType(type);
    }

    @Override
    @JsonProperty(value="collectionType")
    public void setCollectionType(String collType) {
        super.setCollectionType(collType);
    }

    @JsonProperty(value="visibility")
    public void setVisibility(String visibility) {
        super.setVisibility(visibility);
    }

    @Override
    @JsonProperty(value="title")
    public Map<String, String> getTitle() {
        return super.getTitle();
    }

    @Override
    @JsonProperty(value="description")
    public Map<String, String> getDescription() {
        return super.getDescription();
    }

    @Override
    @JsonProperty(value="subject")
    public List<String> getSubject() {
        return super.getSubject();
    }

    @Override
    @JsonGetter(value="pinned")
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=PositiveIntegerFilter.class)
    public int getPinned() {
        if (this.isEntityBestItemsSet()) {
            return super.getPinned();
        }
        return -1;
    }

    @JsonProperty(value="contributor")
    public List<String> getContributor() {
        return super.getContributor();
    }

    @Override
    @JsonProperty(value="total", access=JsonProperty.Access.READ_ONLY)
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=PositiveIntegerFilter.class)
    public int getTotal() {
        return super.getTotal();
    }

    @JsonProperty(value="isDefinedBy")
    public String getIsDefinedBy() {
        return super.getIsDefinedBy();
    }

    @JsonProperty(value="@context")
    public void setContext(String context) {
    }

    @Override
    @JsonProperty(value="creator")
    public Agent getCreator() {
        return super.getCreator();
    }

    @Override
    @JsonIgnore
    public void setCreator(Agent creator) {
        super.setCreator(creator);
    }

    @JsonGetter(value="provider")
    public Provider getProvider() {
        return super.getProvider();
    }

    @JsonSetter(value="provider")
    public void setProvider(WebProvider provider) {
        super.setProvider((Provider)provider);
    }

    @JsonGetter(value="isShownBy")
    public BaseWebResource getIsShownBy() {
        return super.getIsShownBy();
    }

    @JsonSetter(value="isShownBy")
    public void setIsShownBy(WebResource isShownBy) {
        super.setIsShownBy((BaseWebResource)isShownBy);
    }

    @Override
    @JsonIgnore
    public boolean isUgc() {
        return super.isUgc();
    }

    @Override
    @JsonProperty(value="first")
    public String getFirst() {
        return super.getFirst();
    }

    @Override
    @JsonProperty(value="last")
    public String getLast() {
        return super.getLast();
    }

    @JsonIgnore
    public int getCollectionPage() {
        return super.getCollectionPage();
    }

    @JsonGetter(value="id")
    public String getId() {
        return UserSetUtils.buildUserSetId((String)this.getBaseUrl(), (String)super.getIdentifier());
    }

    public void setId(String id) {
    }

    @Override
    public String toString() {
        StringBuilder resBuilder = new StringBuilder();
        resBuilder.append("WebUserSet [");
        if (this.getTitle() != null && StringUtils.isNotEmpty((CharSequence)this.getTitle().toString())) {
            resBuilder.append("Title: ");
            resBuilder.append(this.getTitle());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getIdentifier())) {
            resBuilder.append(", Identifier: ");
            resBuilder.append(this.getIdentifier());
        }
        if (StringUtils.isNotEmpty((CharSequence)Integer.toString(this.getTotal()))) {
            resBuilder.append(", Total items: ");
            resBuilder.append(this.getTotal());
        }
        if (this.getItems() != null && !this.getItems().isEmpty()) {
            resBuilder.append(", Items: ");
            resBuilder.append(this.getItems().size());
        }
        resBuilder.append(']');
        return resBuilder.toString();
    }

    @Override
    @JsonIgnore
    public ObjectId getObjectId() {
        return super.getObjectId();
    }

    @JsonIgnore
    public boolean isOpenSet() {
        return super.isOpenSet();
    }

    @JsonIgnore
    public boolean isPrivate() {
        return super.isPrivate();
    }

    @JsonIgnore
    public boolean isPublic() {
        return super.isPublic();
    }

    @JsonIgnore
    public boolean isPublished() {
        return super.isPublished();
    }

    @JsonIgnore
    public boolean isEntityBestItemsSet() {
        return super.isEntityBestItemsSet();
    }

    @JsonIgnore
    public boolean isBookmarksFolder() {
        return super.isBookmarksFolder();
    }

    @JsonIgnore
    public boolean isCollection() {
        return super.isCollection();
    }

    @JsonIgnore
    public boolean isGallery() {
        return super.isGallery();
    }

    @JsonIgnore
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @JsonIgnore
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }
}

