/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.set.mongo.service;

import com.mongodb.AggregationOptions;
import com.mongodb.BasicDBObject;
import com.mongodb.Cursor;
import com.mongodb.DBObject;
import dev.morphia.query.Criteria;
import dev.morphia.query.Meta;
import dev.morphia.query.Query;
import dev.morphia.query.QueryResults;
import dev.morphia.query.Sort;
import eu.europeana.api.commons.definitions.search.ResultSet;
import eu.europeana.api.commons.nosql.entity.NoSqlEntity;
import eu.europeana.api.commons.nosql.service.impl.AbstractNoSqlServiceImpl;
import eu.europeana.set.definitions.config.UserSetConfiguration;
import eu.europeana.set.definitions.exception.UserSetServiceException;
import eu.europeana.set.definitions.exception.UserSetValidationException;
import eu.europeana.set.definitions.model.UserSet;
import eu.europeana.set.definitions.model.search.UserSetFacetQuery;
import eu.europeana.set.definitions.model.search.UserSetQuery;
import eu.europeana.set.definitions.model.vocabulary.UserSetTypes;
import eu.europeana.set.definitions.model.vocabulary.VisibilityTypes;
import eu.europeana.set.mongo.dao.PersistentUserSetDao;
import eu.europeana.set.mongo.model.internal.PersistentUserSet;
import eu.europeana.set.mongo.service.PersistentUserSetService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;

public class PersistentUserSetServiceImpl
extends AbstractNoSqlServiceImpl<PersistentUserSet, String>
implements PersistentUserSetService {
    protected final Logger logger = LogManager.getLogger(this.getClass());
    private static final String NOT_PERSISTENT_OBJECT = "User set object in not an instance of persistent user set.";
    private static final String FIELD_IDENTIFIER = "identifier";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_CREATOR = "creator.httpUrl";
    List<String> publicPublishedList = Arrays.asList(VisibilityTypes.PUBLIC.getJsonValue(), VisibilityTypes.PUBLISHED.getJsonValue());
    @Resource
    private UserSetConfiguration configuration;

    public synchronized UserSetConfiguration getConfiguration() {
        return this.configuration;
    }

    public synchronized void setConfiguration(UserSetConfiguration configuration) {
        this.configuration = configuration;
    }

    private void validatePersistentUserSet(PersistentUserSet object) {
        if (object.getCreator() == null) {
            throw new UserSetValidationException("Creator must not be null");
        }
        String notInitializedLongId = "-1";
        if (StringUtils.isBlank((CharSequence)object.getIdentifier()) || notInitializedLongId.equals(object.getIdentifier())) {
            throw new UserSetValidationException("UserSet.identifier must be a valid alpha-numeric value or a positive number!");
        }
    }

    @Override
    public PersistentUserSet getByIdentifier(String identifier) {
        Query query = this.getUserSetDao().createQuery();
        query.filter(FIELD_IDENTIFIER, (Object)identifier);
        return (PersistentUserSet)this.getUserSetDao().findOne(query);
    }

    @Override
    public long getDistinct(String field, boolean fieldIsArray, String type) throws UserSetServiceException {
        long count = 0L;
        AggregationOptions aggregationOptions = AggregationOptions.builder().allowDiskUse(Boolean.TRUE).build();
        Cursor cursor = this.getDao().getCollection().aggregate(this.getDistinctCountPipeline(field, fieldIsArray, type), aggregationOptions);
        if (cursor.hasNext()) {
            count = Long.parseLong(((DBObject)cursor.next()).get("count").toString());
            if (cursor.hasNext()) {
                throw new UserSetServiceException("Unexpected result of aggregation operation for distinct objects, the db request must return only one results but currently more resutls were retrieved");
            }
        }
        return count;
    }

    @Override
    public long countItemsInEntitySets() {
        AggregationOptions aggregationOptions = AggregationOptions.builder().allowDiskUse(Boolean.TRUE).build();
        long totalItems = 0L;
        ConcurrentHashMap<String, DBObject> groupFieldsAdditional = new ConcurrentHashMap<String, DBObject>();
        groupFieldsAdditional.put("count", (DBObject)new BasicDBObject("$sum", (Object)"$total"));
        Cursor cursor = this.getDao().getCollection().aggregate(this.getAggregatePipeline(UserSetTypes.ENTITYBESTITEMSSET.getJsonValue(), groupFieldsAdditional), aggregationOptions);
        if (cursor.hasNext()) {
            totalItems = Long.parseLong(((DBObject)cursor.next()).get("count").toString());
        }
        return totalItems;
    }

    @Override
    public QueryResults<PersistentUserSet> getByCreator(String creatorId) {
        Query query = this.getUserSetDao().createQuery().disableValidation();
        query.filter(FIELD_CREATOR, (Object)creatorId);
        return this.getUserSetDao().find(query);
    }

    @Override
    public PersistentUserSet getBookmarkFolder(String creatorId) {
        Query query = this.getUserSetDao().createQuery().disableValidation();
        query.filter(FIELD_TYPE, (Object)UserSetTypes.BOOKMARKSFOLDER.getJsonValue());
        query.filter(FIELD_CREATOR, (Object)creatorId);
        return (PersistentUserSet)this.getUserSetDao().findOne(query);
    }

    public long generateUserSetId(String collection) {
        return this.getUserSetDao().generateNextUserSetId(collection);
    }

    @Override
    public UserSet create(UserSet userSet) {
        if (userSet.getIdentifier() != null) {
            throw new UserSetValidationException("UserSet.identifier must not be set when creating new user sets, for updating user set use the store method!");
        }
        long sequenceId = this.generateUserSetId("userset");
        userSet.setIdentifier("" + sequenceId);
        return this.store(userSet);
    }

    @Override
    public UserSet store(UserSet userSet) {
        PersistentUserSet persistentObject = null;
        if (!(userSet instanceof PersistentUserSet)) {
            throw new IllegalArgumentException(NOT_PERSISTENT_OBJECT);
        }
        persistentObject = (PersistentUserSet)userSet;
        return this.store(persistentObject);
    }

    public PersistentUserSet store(PersistentUserSet persistentUserSet) {
        Date now = new Date();
        persistentUserSet.setModified(now);
        if (persistentUserSet.getCreated() == null) {
            persistentUserSet.setCreated(now);
        }
        this.validatePersistentUserSet(persistentUserSet);
        this.resetTransientFields(persistentUserSet);
        this.updateTotal(persistentUserSet);
        return (PersistentUserSet)super.store((NoSqlEntity)persistentUserSet);
    }

    void updateTotal(UserSet existingUserSet) {
        if (existingUserSet.isOpenSet()) {
            existingUserSet.setTotal(-1);
        } else if (existingUserSet.getItems() == null) {
            existingUserSet.setTotal(0);
        } else {
            existingUserSet.setTotal(existingUserSet.getItems().size());
        }
    }

    private void resetTransientFields(PersistentUserSet persistentObject) {
        persistentObject.setFirst(null);
        persistentObject.setLast(null);
    }

    protected PersistentUserSetDao<PersistentUserSet, String> getUserSetDao() {
        return (PersistentUserSetDao)this.getDao();
    }

    @Override
    @Deprecated
    public PersistentUserSet findByID(String id) {
        return (PersistentUserSet)this.getDao().findOne("_id", (Object)new ObjectId(id));
    }

    private List<DBObject> getDistinctCountPipeline(String groupField, boolean groupFieldIsArray, String type) {
        ArrayList<DBObject> distinctCountPipeline = new ArrayList<DBObject>();
        if (StringUtils.isNotEmpty((CharSequence)type)) {
            distinctCountPipeline.add(this.getMatchFilter(FIELD_TYPE, type));
        }
        if (groupFieldIsArray) {
            distinctCountPipeline.add((DBObject)new BasicDBObject("$unwind", (Object)groupField));
        }
        distinctCountPipeline.add((DBObject)new BasicDBObject("$group", (Object)new BasicDBObject("_id", (Object)groupField)));
        distinctCountPipeline.add((DBObject)new BasicDBObject("$count", (Object)"count"));
        return distinctCountPipeline;
    }

    @Override
    public long count(UserSetQuery query) {
        Query<PersistentUserSet> mongoQuery = this.buildMongoQuery(query);
        return mongoQuery.count();
    }

    @Override
    public Map<String, Long> getFacets(UserSetFacetQuery facetQuery) {
        LinkedHashMap<String, Long> valueCountMap = new LinkedHashMap<String, Long>();
        AggregationOptions aggregationOptions = AggregationOptions.builder().allowDiskUse(null).build();
        Cursor cursor = this.getDao().getCollection().aggregate(this.getFacetPipeline(facetQuery), aggregationOptions);
        while (cursor.hasNext()) {
            DBObject object = (DBObject)cursor.next();
            List facet = (List)object.get(facetQuery.getOutputField());
            for (DBObject o : facet) {
                valueCountMap.put(String.valueOf(o.get("_id")), Long.valueOf(o.get("count").toString()));
            }
        }
        return valueCountMap;
    }

    private List<DBObject> getFacetPipeline(UserSetFacetQuery facetQuery) {
        return Arrays.asList(new BasicDBObject("$facet", (Object)this.getOutputFieldAndStages(facetQuery)));
    }

    private DBObject getOutputFieldAndStages(UserSetFacetQuery facetQuery) {
        ArrayList<Object> outputFieldAndStages = new ArrayList<Object>();
        if (facetQuery.getMatchField() != null && facetQuery.getMatchValue() != null) {
            outputFieldAndStages.add(this.getMatchFilter(facetQuery.getMatchField(), facetQuery.getMatchValue()));
        }
        if (facetQuery.isUnwind()) {
            outputFieldAndStages.add(new BasicDBObject("$unwind", (Object)facetQuery.getFacet()));
        }
        outputFieldAndStages.add(new BasicDBObject("$sortByCount", (Object)facetQuery.getFacet()));
        outputFieldAndStages.add(new BasicDBObject("$limit", (Object)facetQuery.getFacetLimit()));
        return new BasicDBObject(facetQuery.getOutputField(), outputFieldAndStages);
    }

    @Override
    public long countTotalLikes() {
        AggregationOptions aggregationOptions = AggregationOptions.builder().allowDiskUse(Boolean.TRUE).build();
        long totalLikes = 0L;
        ConcurrentHashMap<String, DBObject> groupFieldsAdditional = new ConcurrentHashMap<String, DBObject>();
        groupFieldsAdditional.put("totalLikes", (DBObject)new BasicDBObject("$sum", (Object)"$total"));
        Cursor cursor = this.getDao().getCollection().aggregate(this.getAggregatePipeline(UserSetTypes.BOOKMARKSFOLDER.getJsonValue(), groupFieldsAdditional), aggregationOptions);
        while (cursor.hasNext()) {
            DBObject object = (DBObject)cursor.next();
            totalLikes += Long.parseLong(String.valueOf(object.get("totalLikes")));
        }
        return totalLikes;
    }

    private List<DBObject> getAggregatePipeline(String collectionType, Map<String, DBObject> groupFieldsAdditional) {
        DBObject match = this.getMatchFilter(FIELD_TYPE, collectionType);
        BasicDBObject groupFields = new BasicDBObject("_id", null);
        for (Map.Entry<String, DBObject> field : groupFieldsAdditional.entrySet()) {
            groupFields.put(field.getKey(), (Object)field.getValue());
        }
        BasicDBObject group = new BasicDBObject("$group", (Object)groupFields);
        return Arrays.asList(match, group);
    }

    private DBObject getMatchFilter(String field, String fieldValue) {
        return new BasicDBObject("$match", (Object)new BasicDBObject(field, (Object)fieldValue));
    }

    @Override
    public List<PersistentUserSet> getEntitySetsItemAndSubject(UserSetQuery userSetQuery) {
        return this.buildMongoQuery(userSetQuery).project("items", true).project(FIELD_TYPE, true).project("subject", true).asList();
    }

    @Override
    public ResultSet<PersistentUserSet> find(UserSetQuery query) {
        Query<PersistentUserSet> mongoQuery = this.buildMongoQuery(query);
        long totalInCollection = mongoQuery.count();
        List userSets = new ArrayList();
        if (mongoQuery.getLimit() > 0) {
            userSets = mongoQuery.asList();
        }
        ResultSet res = new ResultSet();
        res.setResults(userSets);
        res.setResultSize(totalInCollection);
        return res;
    }

    private void setPaginationOptions(Query<PersistentUserSet> mongoQuery, UserSetQuery query) {
        int mongoPageIndex = query.getPageNr() - 1;
        mongoQuery.offset(mongoPageIndex * query.getPageSize());
        mongoQuery.limit(query.getPageSize());
    }

    private Query<PersistentUserSet> buildMongoQuery(UserSetQuery query) {
        Query<PersistentUserSet> searchQuery = this.buildUserConditionsQuery(query);
        this.setPaginationOptions(searchQuery, query);
        this.setOrder(searchQuery, query);
        if (query.isAdmin()) {
            return searchQuery;
        }
        if (query.getVisibility() == null) {
            Criteria publicCriterion = (Criteria)searchQuery.criteria("visibility").in(this.publicPublishedList);
            Criteria ownerCriterion = (Criteria)searchQuery.criteria(FIELD_CREATOR).equal((Object)query.getUser());
            searchQuery.and(new Criteria[]{searchQuery.or(new Criteria[]{publicCriterion, ownerCriterion})});
        } else if (query.getVisibility().contains(VisibilityTypes.PRIVATE.getJsonValue())) {
            List<String> visibilitiesWithoutPrivate = query.getVisibility().stream().filter(el -> !el.equals(VisibilityTypes.PRIVATE.getJsonValue())).toList();
            Criteria visibilityCriterion = (Criteria)searchQuery.criteria("visibility").in(visibilitiesWithoutPrivate);
            Criteria ownerCriterion = (Criteria)searchQuery.criteria(FIELD_CREATOR).equal((Object)query.getUser());
            searchQuery.and(new Criteria[]{searchQuery.or(new Criteria[]{visibilityCriterion, ownerCriterion})});
        }
        return searchQuery;
    }

    private Query<PersistentUserSet> buildUserConditionsQuery(UserSetQuery query) {
        Query mongoQuery = this.getUserSetDao().createQuery();
        mongoQuery.disableValidation();
        if (query.getVisibility() != null) {
            mongoQuery.filter("visibility in", (Object)query.getVisibility());
        }
        if (query.getType() != null) {
            mongoQuery.filter("type in", (Object)query.getType());
        }
        if (query.getCollectionType() != null) {
            mongoQuery.filter("collectionType in", (Object)query.getCollectionType());
        }
        if (query.getCreator() != null) {
            mongoQuery.filter("creator.httpUrl in", (Object)query.getCreator());
        }
        if (query.getProvider() != null) {
            mongoQuery.filter("provider.id in", (Object)query.getProvider());
        }
        if (query.getContributor() != null) {
            mongoQuery.filter("contributor in", (Object)query.getContributor());
        }
        if (query.getSubject() != null) {
            mongoQuery.filter("subject in", (Object)query.getSubject());
        }
        if (query.getItem() != null) {
            mongoQuery.filter("items in", (Object)query.getItem());
        }
        if (query.getSetId() != null) {
            mongoQuery.filter("identifier in", (Object)query.getSetId());
        }
        if (query.getText() != null) {
            mongoQuery.search(query.getText());
        }
        if (query.getTitleLang() != null) {
            mongoQuery.filter("title." + query.getTitleLang() + " exists", (Object)1);
        }
        return mongoQuery;
    }

    private void setOrder(Query<PersistentUserSet> mongoQuery, UserSetQuery query) {
        if (query.getSortCriteria() == null) {
            mongoQuery.order(new Sort[]{Sort.descending((String)"modified")});
            return;
        }
        for (String sortField : query.getSortCriteria()) {
            if (sortField.contains("score")) {
                mongoQuery.order(Meta.textScore());
                mongoQuery.order(new Sort[]{Sort.ascending((String)"_id")});
                continue;
            }
            if (!sortField.contains(" ")) {
                mongoQuery.order(new Sort[]{Sort.ascending((String)sortField)});
                continue;
            }
            String[] sortParts = sortField.split(" ", 2);
            if ("desc".equals(sortParts[1])) {
                mongoQuery.order(new Sort[]{Sort.descending((String)sortParts[0])});
                continue;
            }
            mongoQuery.order(new Sort[]{Sort.ascending((String)sortParts[0])});
        }
    }

    @Override
    public void remove(String id) {
        PersistentUserSet userSet = this.getByIdentifier(id);
        if (userSet != null) {
            this.getDao().delete((Object)userSet);
        }
    }

    @Override
    public void removeAll(List<PersistentUserSet> userSets) {
        ArrayList<String> identifiers = new ArrayList<String>();
        if (!userSets.isEmpty()) {
            for (PersistentUserSet userSet : userSets) {
                identifiers.add(userSet.getIdentifier());
            }
        }
        this.getUserSetDao().deleteByIdentifier(identifiers);
    }

    @Override
    public List<String> getDuplicateUserSetsIds(UserSet userSet) {
        if (userSet.getSubject() == null || userSet.getSubject().isEmpty()) {
            return null;
        }
        Query query = this.getUserSetDao().createQuery().disableValidation();
        query.filter(FIELD_TYPE, (Object)UserSetTypes.ENTITYBESTITEMSSET.toString());
        if (StringUtils.isNotBlank((CharSequence)userSet.getIdentifier())) {
            query.filter("identifier !=", (Object)userSet.getIdentifier());
        }
        query.filter("subject size", (Object)userSet.getSubject().size());
        query.filter("subject all", (Object)userSet.getSubject());
        query.project(FIELD_IDENTIFIER, true);
        List resultMongo = this.getUserSetDao().find(query).asList();
        ArrayList<String> result = null;
        if (resultMongo != null && !resultMongo.isEmpty()) {
            result = new ArrayList<String>(resultMongo.size());
            for (PersistentUserSet set : resultMongo) {
                result.add(set.getIdentifier());
            }
        }
        return result;
    }
}

