/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.set.mongo.dao;

import dev.morphia.Datastore;
import dev.morphia.query.Query;
import dev.morphia.query.UpdateOperations;
import eu.europeana.api.commons.nosql.dao.impl.NosqlDaoImpl;
import eu.europeana.set.definitions.config.UserSetConfiguration;
import eu.europeana.set.mongo.dao.PersistentUserSetDao;
import eu.europeana.set.mongo.model.PersistentUserSetImpl;
import eu.europeana.set.mongo.model.internal.GeneratedUserSetIdImpl;
import eu.europeana.set.mongo.model.internal.PersistentUserSet;
import eu.europeana.set.web.model.WebUserSetImpl;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;

public class PersistentUserSetDaoImpl<E extends PersistentUserSet, T extends Serializable>
extends NosqlDaoImpl<E, T>
implements PersistentUserSetDao<E, T> {
    @Resource
    private UserSetConfiguration configuration;
    private Object syncObj = new Object();
    protected final Logger logger = LogManager.getLogger(this.getClass());

    public UserSetConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(UserSetConfiguration configuration) {
        this.configuration = configuration;
    }

    public PersistentUserSetDaoImpl(Class<E> clazz, Datastore datastore) {
        super(datastore, clazz);
        datastore.ensureIndexes(PersistentUserSetImpl.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long generateNextUserSetId(String provider) {
        GeneratedUserSetIdImpl nextUserSetId = null;
        Object object = this.syncObj;
        synchronized (object) {
            Query q = this.getDatastore().createQuery(GeneratedUserSetIdImpl.class);
            q.filter("_id", (Object)provider);
            UpdateOperations uOps = this.getDatastore().createUpdateOperations(GeneratedUserSetIdImpl.class).inc("userSetId");
            nextUserSetId = (GeneratedUserSetIdImpl)this.getDatastore().findAndModify(q, uOps);
            if (nextUserSetId == null) {
                nextUserSetId = new GeneratedUserSetIdImpl(provider, "1");
                this.ds.save((Object)nextUserSetId);
            }
        }
        return nextUserSetId.getUserSetId();
    }

    @Override
    public void deleteByObjectId(List<ObjectId> objectIds) {
        this.getDatastore().delete(WebUserSetImpl.class, objectIds);
    }

    @Override
    public void deleteByIdentifier(List<String> setIds) {
        Query query = this.createQuery();
        query.filter("identifier in", setIds);
        this.getDatastore().delete(query);
    }
}

