/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.set.web.model;

import eu.europeana.set.definitions.model.UserSet;
import eu.europeana.set.definitions.model.util.UserSetTestObjectBuilder;
import eu.europeana.set.definitions.model.vocabulary.UserSetTypes;
import eu.europeana.set.definitions.model.vocabulary.VisibilityTypes;
import eu.europeana.set.web.model.WebUserSetImpl;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class WebUserSetImplTest {
    private static final String IDENTIFIER = "test_identifier";
    UserSetTestObjectBuilder objectBuilder = new UserSetTestObjectBuilder();
    private WebUserSetImpl collectionUserSet;
    private WebUserSetImpl bookmarkUserSet;

    public UserSetTestObjectBuilder getObjectBuilder() {
        return this.objectBuilder;
    }

    @BeforeEach
    void initialiseUserSet() {
        this.collectionUserSet = new WebUserSetImpl();
        this.bookmarkUserSet = new WebUserSetImpl();
        this.getObjectBuilder().buildUserSet((UserSet)this.collectionUserSet, true);
        this.getObjectBuilder().buildUserSet((UserSet)this.bookmarkUserSet, false);
    }

    @Test
    public void testCollectionWebUserSet() {
        this.checkWebUserSets(this.collectionUserSet);
        Assertions.assertTrue((boolean)StringUtils.equals((CharSequence)UserSetTypes.COLLECTION.getJsonValue(), (CharSequence)this.collectionUserSet.getType()));
        Assertions.assertTrue((boolean)StringUtils.equals((CharSequence)VisibilityTypes.PUBLIC.getJsonValue(), (CharSequence)this.collectionUserSet.getVisibility()));
        Assertions.assertTrue((boolean)this.collectionUserSet.isPublic());
    }

    @Test
    public void testBookmarkFolderWebUserSet() {
        this.checkWebUserSets(this.bookmarkUserSet);
        Assertions.assertTrue((boolean)StringUtils.equals((CharSequence)UserSetTypes.BOOKMARKSFOLDER.getJsonValue(), (CharSequence)this.bookmarkUserSet.getType()));
        Assertions.assertTrue((boolean)StringUtils.equals((CharSequence)VisibilityTypes.PRIVATE.getJsonValue(), (CharSequence)this.bookmarkUserSet.getVisibility()));
        Assertions.assertTrue((boolean)this.bookmarkUserSet.isPrivate());
    }

    @Test
    public void testGetId() {
        this.collectionUserSet.setIdentifier(IDENTIFIER);
        String id = this.collectionUserSet.getId();
        Assertions.assertTrue((boolean)StringUtils.contains((CharSequence)id, (CharSequence)IDENTIFIER));
    }

    private void checkWebUserSets(WebUserSetImpl userSet) {
        String title = (String)userSet.getTitle().get(Locale.ENGLISH.getLanguage());
        String description = (String)userSet.getDescription().get(Locale.ENGLISH.getLanguage());
        Assertions.assertTrue((boolean)StringUtils.equals((CharSequence)"Sportswear", (CharSequence)title));
        Assertions.assertTrue((boolean)StringUtils.equals((CharSequence)"From tennis ensemble to golf uniforms, browse Europeana Fashion wide collection of historical sportswear and activewear designs!", (CharSequence)description));
        Assertions.assertNotNull((Object)userSet.getCreator());
        Assertions.assertTrue((boolean)StringUtils.equals((CharSequence)"testAgent", (CharSequence)userSet.getCreator().getName()));
        Assertions.assertTrue((boolean)StringUtils.equals((CharSequence)"http://www.pro.europeana.eu/web/europeana-creative", (CharSequence)userSet.getCreator().getHomepage()));
        Assertions.assertTrue((boolean)StringUtils.contains((CharSequence)userSet.getCreator().getHttpUrl(), (CharSequence)"testAgent"));
        Assertions.assertNotNull((Object)userSet.getItems());
        Assertions.assertNotNull((Object)userSet.getCreated());
        Assertions.assertNotNull((Object)userSet.getModified());
        Assertions.assertTrue((userSet.getItems().size() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((userSet.getTotal() == userSet.getItems().size() ? 1 : 0) != 0);
    }
}

