/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.set.mongo.service.impl;

import dev.morphia.query.QueryResults;
import eu.europeana.api.commons.nosql.dao.NosqlDao;
import eu.europeana.set.definitions.config.UserSetConfiguration;
import eu.europeana.set.definitions.model.UserSet;
import eu.europeana.set.definitions.model.UserSetId;
import eu.europeana.set.definitions.model.search.UserSetQuery;
import eu.europeana.set.definitions.model.search.UserSetQueryImpl;
import eu.europeana.set.definitions.model.util.UserSetTestObjectBuilder;
import eu.europeana.set.definitions.model.utils.UserSetUtils;
import eu.europeana.set.definitions.model.vocabulary.UserSetTypes;
import eu.europeana.set.definitions.model.vocabulary.VisibilityTypes;
import eu.europeana.set.mongo.model.PersistentUserSetImpl;
import eu.europeana.set.mongo.model.internal.PersistentUserSet;
import eu.europeana.set.mongo.service.PersistentUserSetService;
import eu.europeana.set.mongo.service.impl.UserSetTestDataBuilder;
import eu.europeana.set.web.model.WebUserSetImpl;
import java.util.List;
import javax.annotation.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
@ContextConfiguration(locations={"classpath:set-mongo-test.xml"})
@Disabled(value="needs configuration file")
public class PersistentUserSetServiceTest
extends UserSetTestDataBuilder {
    @Resource(name="configuration")
    UserSetConfiguration configuration;
    @Resource(name="set_db_setDao")
    NosqlDao<PersistentUserSet, UserSetId> userSetDao;
    @Resource(name="set_db_setService")
    PersistentUserSetService userSetService;
    UserSetTestObjectBuilder objectBuilder = new UserSetTestObjectBuilder();

    public PersistentUserSetServiceTest() {
        super(null);
    }

    public UserSetTestObjectBuilder getObjectBuilder() {
        return this.objectBuilder;
    }

    @BeforeEach
    public void setup() {
        this.setBaseUserSetUrl(this.configuration.getSetDataEndpoint());
    }

    @Test
    public void storeUserSet() {
        UserSet storedUserSet = this.createUserSet(true);
        Assertions.assertTrue((boolean)(storedUserSet instanceof UserSet));
        this.userSetService.remove(storedUserSet.getIdentifier());
    }

    @Test
    public void storeBookmarkFoder() {
        UserSet storedUserSet = this.createUserSet(false);
        Assertions.assertTrue((boolean)(storedUserSet instanceof UserSet));
        Assertions.assertEquals((Object)UserSetTypes.BOOKMARKSFOLDER.getJsonValue(), (Object)storedUserSet.getType());
        this.deleteBookmarkFolder();
    }

    @Test
    public void getUserSetById() {
        UserSet storedUserSet = this.createUserSet(true);
        PersistentUserSet foundUserSet = this.userSetService.findByID(((PersistentUserSetImpl)storedUserSet).getObjectId().toString());
        this.checkUserSet((UserSet)foundUserSet, storedUserSet);
        Assertions.assertTrue((boolean)(storedUserSet instanceof UserSet));
        Assertions.assertEquals((Object)((WebUserSetImpl)storedUserSet).getObjectId().toString(), (Object)((WebUserSetImpl)foundUserSet).getObjectId().toString());
        this.userSetService.remove(storedUserSet.getIdentifier());
    }

    @Test
    public void getUserSetByIdentifier() {
        UserSet storedUserSet = this.createUserSet(true);
        PersistentUserSet foundUserSet = this.userSetService.getByIdentifier(storedUserSet.getIdentifier());
        this.checkUserSet((UserSet)foundUserSet, storedUserSet);
        Assertions.assertTrue((boolean)(storedUserSet instanceof UserSet));
        Assertions.assertEquals((Object)storedUserSet.getIdentifier(), (Object)foundUserSet.getIdentifier());
        this.userSetService.remove(storedUserSet.getIdentifier());
    }

    @Test
    public void getBookmarksFolder() {
        UserSet storedUserSet = this.createUserSet(false);
        PersistentUserSet foundUserSet = this.userSetService.getBookmarkFolder(storedUserSet.getCreator().getHttpUrl());
        Assertions.assertNotNull((Object)foundUserSet);
        this.checkUserSet((UserSet)foundUserSet, storedUserSet);
        Assertions.assertTrue((boolean)(storedUserSet instanceof UserSet));
        this.userSetService.remove(storedUserSet.getIdentifier());
    }

    @Test
    public void getByCreator() {
        UserSet storedUserSet = this.createUserSet(true);
        String creatorId = this.buildTestUserIdUri();
        QueryResults foundUserSet = this.userSetService.getByCreator(creatorId);
        Assertions.assertNotNull((Object)foundUserSet);
        Assertions.assertTrue((boolean)foundUserSet.iterator().hasNext());
        Assertions.assertEquals((Object)creatorId, (Object)((PersistentUserSet)foundUserSet.iterator().next()).getCreator().getHttpUrl());
        this.userSetService.remove(storedUserSet.getIdentifier());
    }

    private String buildTestUserIdUri() {
        String creatorId = UserSetUtils.buildUserUri((String)this.configuration.getUserDataEndpoint(), (String)"testAgent");
        return creatorId;
    }

    @Test
    public void findBookmarkFolder() {
        UserSet bf = this.retrieveOrCreateBookmarkFolder();
        String creatorId = this.buildTestUserIdUri();
        UserSetQueryImpl query = new UserSetQueryImpl();
        query.setPageSize(10);
        query.setUser(creatorId);
        query.setType(List.of(UserSetTypes.BOOKMARKSFOLDER.getJsonValue()));
        query.setVisibility(List.of(VisibilityTypes.PRIVATE.getJsonValue()));
        List userSetList = this.userSetService.find((UserSetQuery)query).getResults();
        Assertions.assertTrue((userSetList.size() > 0 ? 1 : 0) != 0);
        this.userSetService.remove(bf.getIdentifier());
    }

    @Test
    public void findPublicSets() {
        UserSet set = this.createUserSet(true);
        String creatorId = this.buildTestUserIdUri();
        UserSetQueryImpl query = new UserSetQueryImpl();
        query.setPageSize(10);
        query.setUser(creatorId);
        query.setType(List.of(UserSetTypes.COLLECTION.getJsonValue()));
        List userSetList = this.userSetService.find((UserSetQuery)query).getResults();
        Assertions.assertTrue((userSetList.size() > 0 ? 1 : 0) != 0);
        this.userSetService.remove(set.getIdentifier());
    }

    @Test
    public void findWithAdmin() {
        UserSet set = this.createUserSet(true);
        UserSetQueryImpl query = new UserSetQueryImpl();
        query.setAdmin(true);
        query.setPageSize(10);
        List userSetList = this.userSetService.find((UserSetQuery)query).getResults();
        Assertions.assertTrue((userSetList.size() > 0 ? 1 : 0) != 0);
        this.userSetService.remove(set.getIdentifier());
    }

    @Test
    public void remove() {
        UserSet storedUserSet = this.createUserSet(true);
        this.userSetService.remove(storedUserSet.getIdentifier());
        PersistentUserSet deletedUserSet = this.userSetService.getByIdentifier(storedUserSet.getIdentifier());
        Assertions.assertNull((Object)deletedUserSet);
    }

    @Disabled
    @Test
    public void removeAll() {
        UserSet collectionUserSet = this.createUserSet(true);
        Assertions.assertNotNull((Object)collectionUserSet);
        UserSet bookmarkFolderUserSet = this.createUserSet(false);
        Assertions.assertNotNull((Object)bookmarkFolderUserSet);
        UserSetQueryImpl query = new UserSetQueryImpl();
        query.setAdmin(true);
        query.setPageSize(10);
        List userSetList = this.userSetService.find((UserSetQuery)query).getResults();
        Assertions.assertTrue((userSetList.size() > 0 ? 1 : 0) != 0);
        this.userSetService.removeAll(userSetList);
        List userSetListnow = this.userSetService.find((UserSetQuery)query).getResults();
        Assertions.assertTrue((userSetListnow.size() == 0 ? 1 : 0) != 0);
    }

    private UserSet createUserSet(boolean isCollection) {
        WebUserSetImpl userSet = new WebUserSetImpl();
        UserSet persistentUserSet = this.getObjectBuilder().buildUserSet((UserSet)userSet, isCollection);
        UserSet storedUserSet = this.userSetService.create(persistentUserSet);
        this.checkUserSet(persistentUserSet, storedUserSet);
        return storedUserSet;
    }

    private UserSet retrieveOrCreateBookmarkFolder() {
        UserSet set = this.retrieveBookmarkFolder();
        if (set == null) {
            set = this.createUserSet(false);
        }
        return set;
    }

    private UserSet retrieveBookmarkFolder() {
        PersistentUserSet set = this.userSetService.getBookmarkFolder(this.buildTestUserIdUri());
        return set;
    }

    private void deleteBookmarkFolder() {
        UserSet set = this.retrieveBookmarkFolder();
        if (set != null) {
            this.userSetService.remove(set.getIdentifier());
        }
    }
}

