/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.set.definitions.model.util;

import eu.europeana.set.definitions.exception.UserSetAttributeInstantiationException;
import eu.europeana.set.definitions.model.UserSet;
import eu.europeana.set.definitions.model.agent.Agent;
import eu.europeana.set.definitions.model.agent.impl.Person;
import eu.europeana.set.definitions.model.utils.UserSetUtils;
import eu.europeana.set.definitions.model.vocabulary.UserSetTypes;
import eu.europeana.set.definitions.model.vocabulary.VisibilityTypes;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.IOUtils;

public class UserSetTestObjectBuilder {
    public static final String TEST_TITLE = "Sportswear";
    public static final String TEST_DESCRIPTION = "From tennis ensemble to golf uniforms, browse Europeana Fashion wide collection of historical sportswear and activewear designs!";
    public static final String TEST_AGENT = "testAgent";
    public static final String TEST_HOMEPAGE = "http://www.pro.europeana.eu/web/europeana-creative";
    public static final String CONTENT_DIR = "/content/";
    public static final String ITEMS_TEST_INPUT_FILE = "/content/test_items.txt";
    public static final String ITEMS_1200_TEST_INPUT_FILE = "/content/test_items_1200.txt";
    UserSetUtils userSetUtils = new UserSetUtils();

    public UserSetUtils getUserSetUtils() {
        return this.userSetUtils;
    }

    public UserSet buildUserSet(UserSet userSet, boolean isCollection) {
        return this.buildUserSet(userSet, ITEMS_TEST_INPUT_FILE, isCollection);
    }

    public UserSet buildUserSet(UserSet userSet, String classpathFile, boolean isCollection) {
        userSet.setTitle(this.getUserSetUtils().createMap(Locale.ENGLISH.getLanguage(), TEST_TITLE));
        userSet.setDescription(this.getUserSetUtils().createMap(Locale.ENGLISH.getLanguage(), TEST_DESCRIPTION));
        if (isCollection) {
            userSet.setType(UserSetTypes.COLLECTION.getJsonValue());
            userSet.setVisibility(VisibilityTypes.PUBLIC.getJsonValue());
        } else {
            userSet.setType(UserSetTypes.BOOKMARKSFOLDER.getJsonValue());
            userSet.setVisibility(VisibilityTypes.PRIVATE.getJsonValue());
        }
        Date now = new Date();
        userSet.setCreated(now);
        userSet.setModified(now);
        Person creator = new Person();
        creator.setName(TEST_AGENT);
        creator.setHttpUrl(UserSetUtils.buildUserUri((String)"http://data.europeana.eu/user/", (String)TEST_AGENT));
        creator.setHomepage(TEST_HOMEPAGE);
        userSet.setCreator((Agent)creator);
        try {
            userSet.setItems(this.loadItems(classpathFile));
        }
        catch (IOException e) {
            throw new UserSetAttributeInstantiationException("items", null, "cannot read item list from classpath: " + classpathFile, (Throwable)e);
        }
        userSet.setTotal(userSet.getItems().size());
        return userSet;
    }

    private List<String> loadItems(String path) throws IOException {
        return IOUtils.readLines((InputStream)this.getClass().getResourceAsStream(path), (String)"UTF-8");
    }

    protected File getClasspathFile(String fileName) throws URISyntaxException, IOException, FileNotFoundException {
        URL resource = this.getClass().getResource(fileName);
        if (resource == null) {
            return null;
        }
        URI fileLocation = resource.toURI();
        return new File(fileLocation);
    }
}

