/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.set.integration.connection.http;

import eu.europeana.api.set.integration.config.SetIntegrationConfiguration;
import eu.europeana.api.set.integration.exception.TechnicalRuntimeException;
import eu.europeana.set.common.http.HttpConnection;
import java.io.IOException;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class EuropeanaOauthClient {
    public static final String HEADER_AUTHORIZATION = "Authorization";

    public String getOauthToken() {
        try {
            String accessToken = "access_token";
            String oauthUri = SetIntegrationConfiguration.getInstance().getOauthServiceUri();
            String oauthParams = SetIntegrationConfiguration.getInstance().getOauthRequestParams();
            HttpConnection connection = new HttpConnection();
            ResponseEntity response = connection.post(oauthUri, oauthParams, "application/x-www-form-urlencoded");
            if (HttpStatus.OK == response.getStatusCode()) {
                String body = (String)response.getBody();
                JSONObject json = new JSONObject(body);
                if (json.has(accessToken)) {
                    return "Bearer " + json.getString(accessToken);
                }
                throw new TechnicalRuntimeException("Cannot extract authentication token from reponse:" + body);
            }
            throw new TechnicalRuntimeException("Error occured when calling oath service! " + response);
        }
        catch (IOException | JSONException e) {
            throw new TechnicalRuntimeException("Cannot retrieve authentication token!", (Exception)e);
        }
    }
}

