/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.set.integration.config;

import eu.europeana.api.set.integration.exception.TechnicalRuntimeException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class SetIntegrationConfiguration {
    protected static final String SET_INTEGRATION_TESTING_PROPERTIES_FILE = "/set-integration-testing.properties";
    protected static final String PROP_OAUTH_SERVICE_URI = "oauth.service.uri";
    protected static final String PROP_OAUTH_REQUEST_PARAMS = "oauth.token.request.params";
    private static Properties properties = null;
    private static SetIntegrationConfiguration singleton;

    private SetIntegrationConfiguration() {
    }

    public static synchronized SetIntegrationConfiguration getInstance() {
        if (singleton == null) {
            singleton = new SetIntegrationConfiguration();
            singleton.loadProperties();
        }
        return singleton;
    }

    public synchronized void loadProperties() {
        try {
            properties = new Properties();
            InputStream resourceAsStream = this.getClass().getResourceAsStream(SET_INTEGRATION_TESTING_PROPERTIES_FILE);
            if (resourceAsStream == null) {
                throw new TechnicalRuntimeException("No properties file found in classpath! /set-integration-testing.properties");
            }
            this.getProperties().load(resourceAsStream);
        }
        catch (IOException e) {
            throw new TechnicalRuntimeException("Cannot read configuration file: /set-integration-testing.properties", e);
        }
    }

    Properties getProperties() {
        return properties;
    }

    String getConfigurationFile() {
        return SET_INTEGRATION_TESTING_PROPERTIES_FILE;
    }

    public String getOauthServiceUri() {
        return this.getProperties().getProperty(PROP_OAUTH_SERVICE_URI);
    }

    public String getOauthRequestParams() {
        return this.getProperties().getProperty(PROP_OAUTH_REQUEST_PARAMS);
    }
}

