/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.set.client.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import eu.europeana.set.definitions.model.agent.Agent;
import eu.europeana.set.definitions.model.agent.impl.Person;
import eu.europeana.set.definitions.model.agent.impl.SoftwareAgent;
import eu.europeana.set.definitions.model.vocabulary.AgentTypes;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public class AgentDeserializer
extends JsonDeserializer<Agent> {
    public Agent deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        ObjectMapper mapper = (ObjectMapper)jsonParser.getCodec();
        ObjectNode root = (ObjectNode)mapper.readTree(jsonParser);
        if (root.has("type")) {
            String agentType = root.get("type").asText();
            if (StringUtils.equals((CharSequence)agentType, (CharSequence)AgentTypes.PERSON.getJsonValue())) {
                return (Agent)mapper.readValue(root.toString(), Person.class);
            }
            if (StringUtils.equals((CharSequence)agentType, (CharSequence)AgentTypes.SOFTWARE.getJsonValue())) {
                return (Agent)mapper.readValue(root.toString(), SoftwareAgent.class);
            }
        }
        return null;
    }
}

