/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.set.client.connection;

import eu.europeana.api.commons.auth.AuthenticationHandler;
import eu.europeana.set.client.connection.BaseApiConnection;
import eu.europeana.set.client.exception.SetApiClientException;
import eu.europeana.set.client.model.result.RecordPreview;
import eu.europeana.set.definitions.model.UserSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class UserSetApiConnection
extends BaseApiConnection {
    public UserSetApiConnection(String setServiceUri, AuthenticationHandler auth) {
        super(setServiceUri, auth);
    }

    public UserSet createUserSet(String set, String profile) throws SetApiClientException {
        StringBuilder urlBuilder = this.getUserSetServiceUri();
        if (StringUtils.isNotEmpty((CharSequence)profile)) {
            urlBuilder.append('?').append("profile").append('=').append(profile);
        }
        String resUrl = urlBuilder.toString();
        LOGGER.trace("Ivoking create set: {} ", (Object)resUrl);
        return this.getCreateUserSetResponse(resUrl, set);
    }

    public UserSet getUserSet(String identifier, String profile) throws SetApiClientException {
        StringBuilder urlBuilder = this.getUserSetServiceUri().append(UserSetApiConnection.buildGetUrls(identifier + ".jsonld", profile));
        return this.getUserSetResponse(urlBuilder.toString());
    }

    public UserSet updateUserSet(String identifier, String updateUserSet, String profile) throws SetApiClientException {
        StringBuilder urlBuilder = this.getUserSetServiceUri();
        urlBuilder.append(identifier);
        if (StringUtils.isNotEmpty((CharSequence)profile)) {
            urlBuilder.append('?');
            urlBuilder.append("profile").append('=').append(profile);
        }
        return this.getUpdateUserSetResponse(urlBuilder.toString(), updateUserSet);
    }

    public String deleteUserSet(String identifier) throws SetApiClientException {
        StringBuilder urlBuilder = this.getUserSetServiceUri();
        urlBuilder.append(identifier);
        return this.deleteURL(urlBuilder.toString());
    }

    public List<RecordPreview> getPaginationUserSet(String identifier, String sort, String sortOrder, String page, String pageSize, String profile) throws SetApiClientException {
        StringBuilder urlBuilder = this.getUserSetServiceUri().append(UserSetApiConnection.buildPaginatedGetUrls(identifier + ".jsonld", sort, sortOrder, page, pageSize, profile));
        return this.getUserSetPaginatedResponse(urlBuilder.toString(), profile);
    }

    public List<? extends UserSet> searchUserSet(String query, String[] qf, String sort, String page, String pageSize, String facet, int facetLimit, String profile) throws SetApiClientException {
        StringBuilder urlBuilder = this.getUserSetServiceUri().append(UserSetApiConnection.buildSearchUrl(query, qf, sort, page, pageSize, facet, facetLimit, profile));
        return this.getSearchUserSetResponse(urlBuilder.toString(), profile);
    }
}

