/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.set.client.connection;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import eu.europeana.api.commons.auth.AuthenticationHandler;
import eu.europeana.api.commons.definitions.search.result.impl.ResultsPageImpl;
import eu.europeana.api.commons.http.HttpConnection;
import eu.europeana.api.commons.http.HttpResponseHandler;
import eu.europeana.set.client.exception.SetApiClientException;
import eu.europeana.set.client.json.AgentDeserializer;
import eu.europeana.set.client.json.UserSetDeserializer;
import eu.europeana.set.client.model.result.AbstractUserSetApiResponse;
import eu.europeana.set.client.model.result.RecordPreview;
import eu.europeana.set.definitions.model.UserSet;
import eu.europeana.set.definitions.model.agent.Agent;
import eu.europeana.set.definitions.model.impl.BaseUserSet;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BaseApiConnection {
    protected static final Logger LOGGER = LogManager.getLogger(BaseApiConnection.class);
    private static final String DELETE_URL_RESPONSE = ". Returns status code.";
    private static final String ERROR_MESSAGE = "Set API Client call failed - ";
    private final HttpConnection httpConnection = new HttpConnection();
    private final ObjectMapper mapper = new ObjectMapper();
    private String setServiceUri;
    private AuthenticationHandler authHandler;

    public BaseApiConnection(String setServiceUri, AuthenticationHandler authHandler) {
        this.setServiceUri = setServiceUri;
        this.authHandler = authHandler;
        SimpleModule module = new SimpleModule();
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        module.addDeserializer(Agent.class, (JsonDeserializer)new AgentDeserializer());
        module.addDeserializer(UserSet.class, (JsonDeserializer)new UserSetDeserializer());
        this.mapper.registerModule((Module)module);
        this.mapper.findAndRegisterModules();
    }

    public HttpConnection getHttpConnection() {
        return this.httpConnection;
    }

    public AuthenticationHandler getAuthenticationHandler() {
        return this.authHandler;
    }

    public void setAuthenticationHandler(AuthenticationHandler auth) {
        this.authHandler = auth;
    }

    protected UserSet getUserSetResponse(String url) throws SetApiClientException {
        try {
            LOGGER.trace("Call to Get UserSet API (GET) : {}.", (Object)url);
            return this.parseSetApiResponse(this.getHttpConnection().get(url, null, this.getAuthenticationHandler()), new ArrayList<Integer>(Arrays.asList(200, 304)));
        }
        catch (IOException e) {
            throw new SetApiClientException(ERROR_MESSAGE + e.getMessage(), 500, e);
        }
    }

    protected UserSet getCreateUserSetResponse(String url, String requestBody) throws SetApiClientException {
        try {
            LOGGER.trace("Call to Create UserSet API (POST) : {}.", (Object)url);
            return this.parseSetApiResponse(this.getHttpConnection().post(url, requestBody, ContentType.APPLICATION_JSON.getMimeType(), this.getAuthenticationHandler()), new ArrayList<Integer>(Arrays.asList(201)));
        }
        catch (IOException e) {
            throw new SetApiClientException(ERROR_MESSAGE + e.getMessage(), 500, e);
        }
    }

    protected UserSet getUpdateUserSetResponse(String url, String requestBody) throws SetApiClientException {
        try {
            LOGGER.trace("Call to Update UserSet API : {PUT}. {} ", (Object)url);
            return this.parseSetApiResponse(this.getHttpConnection().put(url, requestBody, this.getAuthenticationHandler()), new ArrayList<Integer>(Arrays.asList(200)));
        }
        catch (IOException e) {
            throw new SetApiClientException(ERROR_MESSAGE + e.getMessage(), 500, e);
        }
    }

    protected String deleteURL(String url) throws SetApiClientException {
        try {
            LOGGER.trace("Call to UserSet API (DELETE): {} {} ", (Object)url, (Object)DELETE_URL_RESPONSE);
            HttpResponseHandler response = this.getHttpConnection().deleteURL(url, this.getAuthenticationHandler());
            if (response.getStatus() != 204) {
                String responseBody = response.getResponse();
                AbstractUserSetApiResponse errorResponse = (AbstractUserSetApiResponse)this.mapper.readValue(responseBody, AbstractUserSetApiResponse.class);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Set API Client call failed -  {} ", (Object)errorResponse.getMessage());
                }
                throw new SetApiClientException(ERROR_MESSAGE + errorResponse.getMessage(), response.getStatus());
            }
            return String.valueOf(response.getStatus());
        }
        catch (IOException e) {
            throw new SetApiClientException(ERROR_MESSAGE + e.getMessage(), 500, e);
        }
    }

    private UserSet parseSetApiResponse(HttpResponseHandler response, List<Integer> statusToCheckList) throws SetApiClientException, JsonProcessingException {
        String responseBody = response.getResponse();
        if (statusToCheckList.contains(response.getStatus())) {
            return (UserSet)this.mapper.readValue(responseBody, UserSet.class);
        }
        AbstractUserSetApiResponse errorResponse = (AbstractUserSetApiResponse)this.mapper.readValue(responseBody, AbstractUserSetApiResponse.class);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Set API Client call failed -  {} ", (Object)errorResponse.getMessage());
        }
        throw new SetApiClientException(ERROR_MESSAGE + errorResponse.getMessage(), response.getStatus());
    }

    protected List<RecordPreview> getUserSetPaginatedResponse(String url, String profile) throws SetApiClientException {
        try {
            LOGGER.trace("Call to Get UserSet API (Paginated): {} ", (Object)url);
            HttpResponseHandler response = this.getHttpConnection().get(url, ContentType.APPLICATION_JSON.getMimeType(), this.getAuthenticationHandler());
            String responseBody = response.getResponse();
            if (response.getStatus() == 200) {
                TypeReference<ResultsPageImpl<RecordPreview>> typeRef = new TypeReference<ResultsPageImpl<RecordPreview>>(){};
                return ((ResultsPageImpl)this.mapper.readValue(responseBody, (TypeReference)typeRef)).getItems();
            }
            AbstractUserSetApiResponse errorResponse = (AbstractUserSetApiResponse)this.mapper.readValue(responseBody, AbstractUserSetApiResponse.class);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Set API Client call failed -  {} ", (Object)errorResponse.getMessage());
            }
            throw new SetApiClientException(ERROR_MESSAGE + errorResponse.getMessage(), response.getStatus());
        }
        catch (IOException e) {
            throw new SetApiClientException(ERROR_MESSAGE + e.getMessage(), 500, e);
        }
    }

    protected List<? extends UserSet> getSearchUserSetResponse(String url, String profile) throws SetApiClientException {
        try {
            LOGGER.trace("Call to UserSet API (SEARCH): {} ", (Object)url);
            HttpResponseHandler response = this.getHttpConnection().get(url, "application/json", this.getAuthenticationHandler());
            String responseBody = response.getResponse();
            if (response.getStatus() == 200) {
                if (StringUtils.equals((CharSequence)profile, (CharSequence)"items")) {
                    TypeReference<ResultsPageImpl<String>> typeRef = new TypeReference<ResultsPageImpl<String>>(){};
                    List items = ((ResultsPageImpl)this.mapper.readValue(responseBody, (TypeReference)typeRef)).getItems();
                    ArrayList<BaseUserSet> sets = new ArrayList<BaseUserSet>(items.size());
                    for (String id : items) {
                        BaseUserSet set = new BaseUserSet();
                        set.setIdentifier(StringUtils.substringAfterLast((String)id, (String)"/"));
                        sets.add(set);
                    }
                    return sets;
                }
                TypeReference<ResultsPageImpl<UserSet>> typeRef = new TypeReference<ResultsPageImpl<UserSet>>(){};
                return ((ResultsPageImpl)this.mapper.readValue(responseBody, (TypeReference)typeRef)).getItems();
            }
            AbstractUserSetApiResponse errorResponse = (AbstractUserSetApiResponse)this.mapper.readValue(responseBody, AbstractUserSetApiResponse.class);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Set API Client call failed -  {} ", (Object)errorResponse.getMessage());
            }
            throw new SetApiClientException(ERROR_MESSAGE + errorResponse.getMessage(), response.getStatus());
        }
        catch (IOException e) {
            throw new SetApiClientException(ERROR_MESSAGE + e.getMessage(), 500, e);
        }
    }

    public StringBuilder getUserSetServiceUri() {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(this.setServiceUri);
        if (!this.setServiceUri.endsWith(String.valueOf('/'))) {
            urlBuilder.append('/');
        }
        return urlBuilder;
    }

    public static URI buildGetUrls(String path, String profile) throws SetApiClientException {
        try {
            URIBuilder builder = new URIBuilder(path);
            if (profile != null) {
                builder.addParameter("profile", profile);
            }
            return builder.build();
        }
        catch (URISyntaxException e) {
            throw new SetApiClientException("Error creating Get url -  " + e.getMessage(), 500, e);
        }
    }

    public static URI buildPaginatedGetUrls(String path, String sort, String sortOrder, String page, String pageSize, String profile) throws SetApiClientException {
        try {
            URIBuilder builder = new URIBuilder(path).addParameter("page", page).addParameter("pageSize", pageSize);
            if (sort != null) {
                builder.addParameter("sort", sort);
            }
            if (sortOrder != null) {
                builder.addParameter("sortOrder", sortOrder);
            }
            if (profile != null) {
                builder.addParameter("profile", profile);
            }
            return builder.build();
        }
        catch (URISyntaxException e) {
            throw new SetApiClientException("Error creating Paginated Get Urls " + e.getMessage(), 500, e);
        }
    }

    public static URI buildSearchUrl(String query, String[] qf, String sort, String page, String pageSize, String facet, int facetLimit, String profile) throws SetApiClientException {
        try {
            URIBuilder builder = new URIBuilder("search").addParameter("query", query).addParameter("page", page).addParameter("pageSize", pageSize);
            if (qf != null) {
                builder.addParameter("qf", String.valueOf(qf));
            }
            if (sort != null) {
                builder.addParameter("sort", sort);
            }
            if (facet != null) {
                builder.addParameter("facet", facet);
                builder.addParameter("facet.limit", String.valueOf(facetLimit));
            }
            if (profile != null) {
                builder.addParameter("profile", profile);
            }
            return builder.build();
        }
        catch (URISyntaxException e) {
            throw new SetApiClientException("Error creating Search Urls ", 500, e);
        }
    }

    public String getSetServiceUri() {
        return this.setServiceUri;
    }
}

