/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.set.client.config;

import eu.europeana.api.commons.auth.AuthenticationConfig;
import java.io.IOException;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientConfiguration
extends AuthenticationConfig {
    private static final Logger LOGGER = LogManager.getLogger(ClientConfiguration.class);
    protected static final String SET_CLIENT_PROPERTIES_FILE = "/set-client.user.properties";
    public static final String PROP_SET_SERVICE_URI = "set.service.uri";

    public ClientConfiguration() {
        this.loadProperties(SET_CLIENT_PROPERTIES_FILE);
    }

    public ClientConfiguration(Properties properties) {
        super(properties);
    }

    private void loadProperties(String propertiesFile) {
        try {
            this.load(((Object)((Object)this)).getClass().getResourceAsStream(propertiesFile));
        }
        catch (IOException e) {
            LOGGER.error("Error loading the properties file {}", (Object)propertiesFile);
        }
    }

    public String getConfigurationFile() {
        return SET_CLIENT_PROPERTIES_FILE;
    }

    public String getServiceUri() {
        return this.getProperty(PROP_SET_SERVICE_URI);
    }
}

