/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.set.client;

import eu.europeana.api.commons.auth.AuthenticationHandler;
import eu.europeana.set.client.BaseUserSetApi;
import eu.europeana.set.client.config.ClientConfiguration;
import eu.europeana.set.client.exception.SetApiClientException;
import eu.europeana.set.client.model.result.RecordPreview;
import eu.europeana.set.client.web.SearchUserSetApi;
import eu.europeana.set.client.web.WebUserSetApi;
import eu.europeana.set.definitions.model.UserSet;
import java.util.List;

public class UserSetApiClient
extends BaseUserSetApi {
    private final WebUserSetClient webUserSetClient = new WebUserSetClient();
    private final SearchUserSetClient searchUserSetClient = new SearchUserSetClient();

    public UserSetApiClient(ClientConfiguration configuration) throws SetApiClientException {
        super(configuration);
    }

    public UserSetApiClient(String serviceUri, AuthenticationHandler auth) throws SetApiClientException {
        super(serviceUri, auth);
    }

    public WebUserSetApi getWebUserSetApi() {
        return this.webUserSetClient;
    }

    public SearchUserSetApi getSearchUserSetApi() {
        return this.searchUserSetClient;
    }

    private class WebUserSetClient
    implements WebUserSetApi {
        private WebUserSetClient() {
        }

        @Override
        public UserSet createUserSet(String set, String profile) throws SetApiClientException {
            return UserSetApiClient.this.getApiConnection().createUserSet(set, profile);
        }

        @Override
        public String deleteUserSet(String identifier) throws SetApiClientException {
            return UserSetApiClient.this.getApiConnection().deleteUserSet(identifier);
        }

        @Override
        public UserSet getUserSet(String identifier, String profile) throws SetApiClientException {
            return UserSetApiClient.this.getApiConnection().getUserSet(identifier, profile);
        }

        @Override
        public UserSet updateUserSet(String identifier, String set, String profile) throws SetApiClientException {
            return UserSetApiClient.this.getApiConnection().updateUserSet(identifier, set, profile);
        }

        @Override
        public List<RecordPreview> getPaginationUserSet(String identifier, String sort, String sortOrder, String page, String pageSize, String profile) throws SetApiClientException {
            return UserSetApiClient.this.getApiConnection().getPaginationUserSet(identifier, sort, sortOrder, page, pageSize, profile);
        }
    }

    private class SearchUserSetClient
    implements SearchUserSetApi {
        private SearchUserSetClient() {
        }

        @Override
        public List<? extends UserSet> searchUserSet(String query, String[] qf, String sort, String page, String pageSize, String facet, int facetLimit, String profile) throws SetApiClientException {
            return UserSetApiClient.this.getApiConnection().searchUserSet(query, qf, sort, page, pageSize, facet, facetLimit, profile);
        }
    }
}

