/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.set.client;

import eu.europeana.api.commons.auth.AuthenticationBuilder;
import eu.europeana.api.commons.auth.AuthenticationConfig;
import eu.europeana.api.commons.auth.AuthenticationHandler;
import eu.europeana.set.client.config.ClientConfiguration;
import eu.europeana.set.client.connection.UserSetApiConnection;
import eu.europeana.set.client.exception.SetApiClientException;

public class BaseUserSetApi {
    private UserSetApiConnection apiConnection;

    protected BaseUserSetApi(ClientConfiguration config) throws SetApiClientException {
        this(config.getServiceUri(), AuthenticationBuilder.newAuthentication((AuthenticationConfig)config));
    }

    protected BaseUserSetApi(String serviceUri, AuthenticationHandler auth) throws SetApiClientException {
        if (serviceUri == null) {
            throw new SetApiClientException(" Set Api Endpoint not provided !!!");
        }
        this.apiConnection = new UserSetApiConnection(serviceUri, auth);
    }

    public AuthenticationHandler getAuthenticationHandler() {
        return this.apiConnection.getAuthenticationHandler();
    }

    public void setAuthenticationHandler(AuthenticationHandler auth) {
        this.apiConnection.setAuthenticationHandler(auth);
    }

    public UserSetApiConnection getApiConnection() {
        return this.apiConnection;
    }
}

