/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.set.client.connection;

import eu.europeana.set.client.config.ClientConfiguration;
import eu.europeana.set.client.connection.BaseApiConnection;
import java.io.IOException;
import org.springframework.http.ResponseEntity;

public class UserSetApiConnection
extends BaseApiConnection {
    public UserSetApiConnection(String setServiceUri, String apiKey) {
        super(setServiceUri, apiKey);
    }

    public UserSetApiConnection() {
        this(ClientConfiguration.getInstance().getServiceUri(), ClientConfiguration.getInstance().getApiKey());
    }

    public ResponseEntity<String> createUserSet(String wskey, String set, String userToken) throws IOException {
        StringBuilder urlBuilder = this.getUserSetServiceUri();
        urlBuilder.append("?");
        urlBuilder.append("wskey").append("=").append(wskey).append("&");
        urlBuilder.append("userToken").append("=").append(userToken).append("&");
        String resUrl = urlBuilder.toString();
        this.logger.trace("Ivoking create set: " + resUrl);
        return this.postURL(resUrl, set);
    }

    public ResponseEntity<String> getUserSet(String wskey, String identifier, String userToken) throws IOException {
        StringBuilder urlBuilder = this.getUserSetServiceUri();
        urlBuilder.append(identifier).append(".jsonld");
        urlBuilder.append("?");
        urlBuilder.append("wskey").append("=").append(wskey).append("&");
        urlBuilder.append("userToken").append("=").append(userToken);
        return this.getURL(urlBuilder.toString());
    }

    public ResponseEntity<String> updateUserSet(String wskey, String identifier, String updateUserSet, String userToken) throws IOException {
        StringBuilder urlBuilder = this.getUserSetServiceUri();
        urlBuilder.append(identifier).append(".jsonld");
        urlBuilder.append("?");
        urlBuilder.append("wskey").append("=").append(wskey).append("&");
        return this.putURL(urlBuilder.toString(), updateUserSet);
    }

    public ResponseEntity<String> deleteUserSet(String wskey, String identifier, String userToken) throws IOException {
        StringBuilder urlBuilder = this.getUserSetServiceUri();
        urlBuilder.append(identifier).append(".jsonld");
        urlBuilder.append("?");
        urlBuilder.append("wskey").append("=").append(wskey).append("&");
        return this.deleteURL(urlBuilder.toString());
    }
}

