/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.set.client.connection;

import com.google.gson.Gson;
import eu.europeana.set.client.http.HttpConnection;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.ResponseEntity;

public class BaseApiConnection {
    private String apiKey;
    private String setServiceUri = "";
    private HttpConnection httpConnection = new HttpConnection();
    Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private Gson gson;

    public String getApiKey() {
        return this.apiKey;
    }

    public String getAdminApiKey() {
        return "apiadmin";
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public StringBuilder getUserSetServiceUri() {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(this.setServiceUri);
        if (!this.setServiceUri.endsWith("/")) {
            urlBuilder.append("/");
        }
        return urlBuilder;
    }

    public void setUserSetServiceUri(String setServiceUri) {
        this.setServiceUri = setServiceUri;
    }

    public HttpConnection getHttpConnection() {
        return this.httpConnection;
    }

    public void setHttpConnection(HttpConnection httpConnection) {
        this.httpConnection = httpConnection;
    }

    public BaseApiConnection(String setServiceUri, String apiKey) {
        this.apiKey = apiKey;
        this.setServiceUri = setServiceUri;
    }

    String getJSONResult(String url) throws IOException {
        this.logger.trace("Call to UserSet API (GET): " + url);
        return this.getHttpConnection().getURLContent(url);
    }

    String getJSONResult(String url, String paramName, String jsonPost) throws IOException {
        this.logger.trace("Call to UserSet API (POST): " + url);
        return this.getHttpConnection().getURLContent(url, paramName, jsonPost);
    }

    String getJSONResultWithBody(String url, String jsonPost) throws IOException {
        this.logger.trace("Call to UserSet API (POST) with body: " + url);
        return this.getHttpConnection().getURLContentWithBody(url, jsonPost);
    }

    ResponseEntity<String> postURL(String url, String jsonPost) throws IOException {
        this.logger.trace("Call to UserSet API (POST) with body: " + url + ". Returns body, headers and status code.");
        return this.getHttpConnection().postURL(url, jsonPost);
    }

    ResponseEntity<String> putURL(String url, String jsonPut) throws IOException {
        this.logger.trace("Call to UserSet API (PUT) with body: " + url + ". Returns body, headers and status code.");
        ResponseEntity<String> response = this.getHttpConnection().putURL(url, jsonPut);
        response.getStatusCode();
        return response;
    }

    public ResponseEntity<String> getURL(String url) throws IOException {
        this.logger.trace("Call to UserSet API (GET): " + url + ". Returns body, headers and status code.");
        return this.getHttpConnection().getURL(url);
    }

    ResponseEntity<String> deleteURL(String url) throws IOException {
        this.logger.trace("Call to UserSet API (DELETE): " + url + ". Returns headers and status code.");
        return this.getHttpConnection().deleteURL(url);
    }
}

