/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.set.client.config;

import eu.europeana.set.client.exception.TechnicalRuntimeException;
import java.io.InputStream;
import java.util.Properties;

public class ClientConfiguration {
    protected static final String SET_CLIENT_PROPERTIES_FILE = "/set-client.properties";
    protected static final String PROP_SET_API_KEY = "set.api.key";
    protected static final String PROP_SET_SERVICE_URI = "set.service.uri";
    private static Properties properties = null;
    private static ClientConfiguration singleton;

    private ClientConfiguration() {
    }

    public static synchronized ClientConfiguration getInstance() {
        singleton = new ClientConfiguration();
        singleton.loadProperties();
        return singleton;
    }

    public synchronized void loadProperties() {
        try {
            properties = new Properties();
            InputStream resourceAsStream = this.getClass().getResourceAsStream(SET_CLIENT_PROPERTIES_FILE);
            if (resourceAsStream == null) {
                throw new TechnicalRuntimeException("No properties file found in classpath! /set-client.properties");
            }
            this.getProperties().load(resourceAsStream);
        }
        catch (Exception e) {
            throw new TechnicalRuntimeException("Cannot read configuration file: /set-client.properties", e);
        }
    }

    Properties getProperties() {
        return properties;
    }

    String getConfigurationFile() {
        return SET_CLIENT_PROPERTIES_FILE;
    }

    public String getApiKey() {
        return this.getProperties().getProperty(PROP_SET_API_KEY);
    }

    public String getServiceUri() {
        return this.getProperties().getProperty(PROP_SET_SERVICE_URI);
    }
}

