/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.features;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.http.IdleConnectionReaper;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import eu.europeana.exception.S3ObjectStorageException;
import eu.europeana.features.MetadataUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class S3ObjectStorageClient {
    private static final Logger LOG = LogManager.getLogger(S3ObjectStorageClient.class);
    private static final String ERROR_MSG_RETRIEVE = "Error retrieving storage object ";
    private final AmazonS3 s3Client;
    private final String bucketName;
    private boolean isIbmCloud = false;

    public S3ObjectStorageClient(String clientKey, String secretKey, String region, String bucketName) {
        this(clientKey, secretKey, region, bucketName, (ClientConfiguration)null);
    }

    public S3ObjectStorageClient(String clientKey, String secretKey, String region, String bucketName, ClientConfiguration clientConfiguration) {
        AmazonS3ClientBuilder builder = (AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(clientKey, secretKey)))).withRegion(region);
        if (clientConfiguration != null) {
            builder.withClientConfiguration(clientConfiguration);
        }
        this.s3Client = (AmazonS3)builder.build();
        this.bucketName = bucketName;
        LOG.info("Connected to Amazon S3 bucket {}, region {} ", (Object)bucketName, (Object)region);
    }

    public S3ObjectStorageClient(String clientKey, String secretKey, String region, String bucketName, String endpoint) {
        System.setProperty("com.amazonaws.sdk.disableDNSBuckets", "True");
        BasicAWSCredentials creds = new BasicAWSCredentials(clientKey, secretKey);
        this.s3Client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)creds))).withPathStyleAccessEnabled(Boolean.valueOf(true))).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endpoint, region))).build();
        this.bucketName = bucketName;
        this.isIbmCloud = true;
        LOG.info("Connected to IBM Cloud S3 bucket {}, region {} ", (Object)bucketName, (Object)region);
    }

    public String getServiceName() {
        return this.isIbmCloud ? "IBM Cloud S3" : "Amazon S3";
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public List<Bucket> listBuckets() {
        return this.s3Client.listBuckets();
    }

    public ListObjectsV2Result listAll(String continuationToken) {
        return this.listAll(continuationToken, null);
    }

    public ListObjectsV2Result listAll(String continuationToken, Integer maxPageSize) {
        ListObjectsV2Request listObjectsV2Request = new ListObjectsV2Request().withBucketName(this.bucketName).withContinuationToken(continuationToken);
        if (maxPageSize != null) {
            listObjectsV2Request.setMaxKeys(maxPageSize);
        }
        return this.s3Client.listObjectsV2(listObjectsV2Request);
    }

    public boolean isObjectAvailable(String id) {
        return this.s3Client.doesObjectExist(this.bucketName, id);
    }

    public String putObject(String id, InputStream inputStream, ObjectMetadata objectMetadata) {
        PutObjectResult putObjectResult = this.s3Client.putObject(new PutObjectRequest(this.bucketName, id, inputStream, objectMetadata));
        return putObjectResult == null ? null : putObjectResult.getETag();
    }

    public String putObject(String id, InputStream inputStream, String contentType, int contentLength, String md5) {
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setContentType(contentType);
        objectMetadata.setContentLength((long)contentLength);
        objectMetadata.setContentMD5(md5);
        return this.putObject(id, inputStream, objectMetadata);
    }

    public String putObject(String id, String textContents) {
        byte[] data = textContents.getBytes(StandardCharsets.UTF_8);
        ObjectMetadata objectMetadata = MetadataUtils.generateObjectMetadata(data);
        return this.putObject(id, new ByteArrayInputStream(data), objectMetadata);
    }

    public S3Object getObject(String id) {
        try {
            return this.s3Client.getObject(this.bucketName, id);
        }
        catch (AmazonS3Exception e) {
            if (!this.is404Exception((Exception)((Object)e))) {
                throw new S3ObjectStorageException(ERROR_MSG_RETRIEVE + id, e);
            }
            return null;
        }
    }

    public InputStream getObjectStream(String id) {
        try {
            S3Object object = this.s3Client.getObject(this.bucketName, id);
            return object.getObjectContent().getDelegateStream();
        }
        catch (AmazonS3Exception e) {
            if (!this.is404Exception((Exception)((Object)e))) {
                throw new S3ObjectStorageException(ERROR_MSG_RETRIEVE + id, e);
            }
            return null;
        }
    }

    public byte[] getObjectContent(String id) {
        byte[] byArray;
        block9: {
            S3Object object = this.s3Client.getObject(this.bucketName, id);
            try {
                byArray = object.getObjectContent().readAllBytes();
                if (object == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (object != null) {
                        try {
                            object.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AmazonS3Exception | IOException e) {
                    if (!this.is404Exception((Exception)e)) {
                        throw new S3ObjectStorageException(ERROR_MSG_RETRIEVE + id, e);
                    }
                    return new byte[0];
                }
            }
            object.close();
        }
        return byArray;
    }

    public ObjectMetadata getObjectMetadata(String id) {
        try {
            return this.s3Client.getObjectMetadata(this.bucketName, id);
        }
        catch (AmazonS3Exception e) {
            if (!this.is404Exception((Exception)((Object)e))) {
                throw new S3ObjectStorageException(ERROR_MSG_RETRIEVE + id, e);
            }
            return null;
        }
    }

    public void deleteObject(String id) {
        try {
            DeleteObjectRequest deleteObjectRequest = new DeleteObjectRequest(this.bucketName, id);
            this.s3Client.deleteObject(deleteObjectRequest);
        }
        catch (AmazonS3Exception e) {
            throw new S3ObjectStorageException("Error deleting object " + id, e);
        }
    }

    public void close() {
        LOG.info("Shutting down connections to {}...", (Object)this.getServiceName());
        ((AmazonS3Client)this.s3Client).shutdown();
        IdleConnectionReaper.shutdown();
    }

    private boolean is404Exception(Exception e) {
        AmazonServiceException ase;
        return e instanceof AmazonServiceException && (ase = (AmazonServiceException)e).getStatusCode() == 404;
    }
}

